import com.ridgesoft.intellibrain.*;
import com.ridgesoft.robotics.sensors.CMUcam.*;

public class RoboCamera implements Runnable
{   private CMUcam              camera;
    private CMUcamTrackingData  trackingData;
    private int                 cameraGreenLED;
    private boolean             on;
    private RoboSerial          serial;
    private RoboDisplay         display;

    public RoboCamera(RoboSerial s1, RoboSerial s2, RoboDisplay d, boolean m, boolean w, boolean a)
    {   this.camera = new CMUcam (s2.getSerial(), s2.getBaud());
        this.trackingData = this.camera.getTrackingData();
        this.cameraGreenLED = 1;
        this.on = false;
        this.serial = s1;
        this.display = d;

        try
        {   this.camera.open();
            this.camera.setRGBMode(m);
            this.camera.setWhiteBalance(w);
            this.camera.setAutoExposure(a);
            Thread.sleep(5000);
            this.camera.setWhiteBalance(false); // disable further adjustment
            this.camera.setAutoExposure(false);
        }   catch (Throwable t) { t.printStackTrace(); }
    }

    public void stop ()
    {   try
        {   this.camera.stop();
        }
        catch(Throwable t) { t.printStackTrace(); }
    }

    public void trackWindow ()
    {   this.stop();
        try
        {   this.camera.trackWindow();
            this.camera.setTrackingLed(this.cameraGreenLED, this.camera.LED_TRACK);
        }
        catch (Throwable t) { t.printStackTrace(); }
    }

    public void trackColor (String color)
    {   this.stop();
        try
        {   if (color.equals("green"))
                this.camera.trackGreen();
            else if (color.equals("red"))
                this.camera.trackRed();
            else if (color.equals("blue"))
                this.camera.trackBlue();
            else
                this.camera.trackWindow();            
            this.camera.setTrackingLed(this.cameraGreenLED, this.camera.LED_TRACK);
        }   catch (Throwable t) { t.printStackTrace(); }
    }

    public void trackColor (int rOcMin, int rOcMax, int gOyMin, int gOyMax, int bOcMin, int bOcMax)
    {   this.stop();
        try
        {   this.camera.trackColor(rOcMin, rOcMax, gOyMin, gOyMax, bOcMin, bOcMax);
            this.camera.setTrackingLed(this.cameraGreenLED, this.camera.LED_TRACK);
        }   catch (Throwable t) { t.printStackTrace(); }
    }

    public void display ()
    {   if (this.trackingData != null)
        {   this.display.writeTextLine(0, "mx: " + this.trackingData.mx + " my: " + this.trackingData.my);
            this.display.writeTextLine(1, "c: " + this.trackingData.confidence + " p: " + this.trackingData.pixels);
        }
    }

    public void send ()
    {   if (this.trackingData != null)
        {   this.serial.writeOut ((""+'c'+'w'+'i'+'0'+'t'+'0'+'0'+'d'+"mx-"+this.trackingData.mx+":"+
                                                                      "my-"+this.trackingData.my+":"+
                                                                      "c-" +this.trackingData.confidence+":"+
                                                                      "p-" +this.trackingData.pixels+'\r'));
        }
    }

    public void run()
    {   while (true)
        {   try
            {   this.trackingData = this.camera.getTrackingData();
                this.send();
            }   catch (Throwable t) { t.printStackTrace(); }
        }
    }
}