import com.ridgesoft.intellibrain.IntelliBrain;

public class RoboBuffer implements RoboQueue
{   private static final int CAPACITY = 5;

    private String[] queu;
    private int      size;
    private int      front;
    private int      back;

    public RoboBuffer ()
    {   this.queu = new String[RoboBuffer.CAPACITY];
        this.setEmpty( );
    }

    public boolean isEmpty()
    {   return this.size == 0;
    }

    public void setEmpty()
    {   this.size = 0;
        this.front = 0;
        this.back = -1;
    }

    public String dequeue()
    {   if(isEmpty()) return null;
        
		this.size--;
        String command = queu[this.front];
		this.front = this.increment(this.front);
        return command;
    }
    
    public void enqueue(String s)
    {   if (this.size == queu.length)
            this.doubleCapacity();
        this.back = this.increment(this.back);
        this.queu[this.back] = s;
        this.size++;
	}

    public String getFront ()
    {   if(isEmpty()) return "empty";
        return queu[this.front];
    }

    private int increment(int x)
    {   if(++x == this.queu.length)
            x = 0;
        return x;
    }

    private void doubleCapacity()
    {   String[] newQueu = new String[this.queu.length*2];

        for (int i=0; i<this.size; i++, this.front = this.increment(this.front))
            newQueu[i] = this.queu[front];

        this.queu = newQueu;
        front = 0;
        back = this.size - 1;
}   }