package hive;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class HiveSerialComm implements Runnable, SerialPortEventListener
{   private InputStream     inputStream;
    private byte[]          readBuffer;
    private OutputStream    outputStream;
    private SerialPort      serialPort;
    private String          defaultSerialPort;
    private HiveBuffer      oBuffer;  //TO ROBO BUFFER
    private HiveBuffer      iBuffer;  //FROM ROBO BUFFER
    private int             commandLength;
    private int             spacerLength;
    private int             timeOut;
    private HiveView        guiHandle;

    public HiveSerialComm (HiveView hv)
    {   this(hv, "COM4", 100);
    }

    public HiveSerialComm (HiveView hv, String sp)
    {   this(hv, sp, 100);
    }

    public HiveSerialComm (HiveView hv, String sp, int to)
    {   this.guiHandle = hv;
        
        this.timeOut = to;
        this.commandLength = 25;
        this.spacerLength = 2;
        this.oBuffer = new HiveBuffer();
        this.iBuffer = new HiveBuffer();
        this.readBuffer = new byte[this.commandLength];

        if ( System.getProperty("os.name","").toLowerCase().startsWith("windows") )
            this.defaultSerialPort = "COM4";    //SPECIFIC TO MY LAPTOP
        else if (System.getProperty("os.name","").toLowerCase().startsWith("linux"))
            this.defaultSerialPort = "/dev/ttyS0";
        else if (System.getProperty("os.name","").toLowerCase().startsWith("mac") )
            this.defaultSerialPort = "????";

        this.serialPort = this.getSerialPort(this.getPortId(sp), this.timeOut);
    }

    private ArrayList<CommPortIdentifier> getPortList ()
    {   ArrayList<CommPortIdentifier> al = new ArrayList<CommPortIdentifier>();
        Enumeration<CommPortIdentifier> portListEnum = CommPortIdentifier.getPortIdentifiers();
   
        while (portListEnum.hasMoreElements())
        {   CommPortIdentifier pid = portListEnum.nextElement();
            if (pid.getPortType() == CommPortIdentifier.PORT_SERIAL)
                al.add(pid);
        }

        return al;
    }

    public static Object[] getPortListArray ()
    {   ArrayList<String> al = new ArrayList<String>();
        Enumeration<CommPortIdentifier> portListEnum = CommPortIdentifier.getPortIdentifiers();
        
        while (portListEnum.hasMoreElements())
        {   CommPortIdentifier pid = portListEnum.nextElement();
            if (pid.getPortType() == CommPortIdentifier.PORT_SERIAL)
                al.add(pid.getName());
        }

        return al.toArray();
    }

    private CommPortIdentifier getPortId (String port)
    {   Iterator<CommPortIdentifier> i = this.getPortList().iterator();
        CommPortIdentifier cpi = null;

        while(i.hasNext())
        {   cpi = i.next();
            if(!cpi.getName().equals(port))
            {   cpi = null;
        }   }

        return cpi;
    }

    public void setPortId (String port, int to)
    {   this.serialPort.close();
        this.serialPort = this.getSerialPort(this.getPortId(port), to);
    }

    public int getCommandLength()
    {   return this.commandLength;
    }

    public void close ()
    {   this.serialPort.close();
    }

    private SerialPort getSerialPort(CommPortIdentifier cpi, int to)
    {   SerialPort sp = null;

        try
        {   sp = (SerialPort) cpi.open("RoboHiveApp", to);
            sp.setSerialPortParams(115200, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            sp.addEventListener(this);
            sp.notifyOnDataAvailable(true);
            sp.notifyOnOutputEmpty(true);
            this.inputStream = sp.getInputStream();
            this.outputStream = sp.getOutputStream();
        } catch (Throwable e) {e.printStackTrace();}

        return sp;
    }

    public String readIn ()
    {   return this.iBuffer.dequeue();
    }

    public void writeOut (String cmd)
    {   this.oBuffer.enqueue(cmd);
    }

    private void write ()
    {   byte[] newb = new byte[this.commandLength+2];
        String cmd = this.oBuffer.dequeue();

        try
		{   //ADD PREAMBLE
            for (int i=0; i<2; ++i)
                newb[i] = (byte)0;
            //ADD MESSAGE
            for (int i=0; i<cmd.length(); ++i)
                newb[i+2] = (byte)cmd.charAt(i);
            //SEND OUT
            this.outputStream.flush();
			this.outputStream.write(newb);
            System.out.println("LAPTOP TO ROBO: "+cmd);
		}	catch (Exception e) { e.printStackTrace(); }
    } 
/*
    private void read ()
    {   byte[] data = new byte[this.commandLength];

        int countByte = 0;
        int dataByte = 0;
        try
        {   if ((dataByte = this.inputStream.read()) != -1)
            {   while ((dataByte = this.inputStream.read()) != -1)
                {   //REMOVE PREAMBLE
                    if ((char)dataByte == 0) continue;
                    //WHILE WE HAVE A LINE
                    else if (countByte < data.length - 1)
                    {   data[countByte++] = (byte)dataByte;
                        //BREAK ON CR
                        if ((byte)dataByte == '\r')
                        {   this.iBuffer.enqueue(new String(data));
                            //AS A SIDE EFECT '\R' IS NO LONGER AVAILABLE
                            this.executeReadBuffer();
        }   }   }   }   }
        catch (Throwable t){t.printStackTrace();}
    }
*/
    int readHpacket() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void run() 
    {   try
        {   while (true)
            {   if (!this.oBuffer.isEmpty()) 
                {   this.write();
                    //this.read();
                }
                Thread.sleep(50);
            }
        } catch (Throwable t) {t.printStackTrace();}
    }

    public void serialEvent(SerialPortEvent event)
    {   byte[] data = new byte[this.commandLength];

        switch (event.getEventType())
        {   case SerialPortEvent.BI:
            case SerialPortEvent.OE:
            case SerialPortEvent.FE:
            case SerialPortEvent.PE:
            case SerialPortEvent.CD:
            case SerialPortEvent.CTS:
            case SerialPortEvent.DSR:
            case SerialPortEvent.RI:
            case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
                break;
            case SerialPortEvent.DATA_AVAILABLE:
                int countByte = 0;
                int dataByte = 0;
                try
                {   while ((dataByte = this.inputStream.read()) != -1)
                    {   //REMOVE PREAMBLE
                        if ((char)dataByte == 0) continue;
                        //WHILE WE HAVE A LINE
                        else if (countByte < data.length - 1)
                            {   data[countByte++] = (byte)dataByte;
                                //BREAK ON CR
                                if ((byte)dataByte == '\r')
                                {   this.iBuffer.enqueue(new String(data));
                                    //AS A SIDE EFECT '\R' IS NO LONGER AVAILABLE
                                    this.executeReadBuffer();
                }   }       }   }
                catch (Throwable t){t.printStackTrace();}
        }
    }

    public void executeReadBuffer()
    {   byte[] data = this.iBuffer.dequeue().getBytes();
        String mess = "";
        System.out.println("ROBO TO LAPTOP:"+new String(data));


        switch ((char)data[0])
        {   // DISPLAY READ
            case 'd':   if ((char)data[1] == 'w' && (char)data[2] == 'i' &&
                            (char)data[4] == 't' && (char)data[7] == 'd')
                        {   for (int i=8; i<24; ++i)
                                if ((char)data[i] != (byte)0)
                                    mess += (char)data[i];
                            if ((char)data[3] == '0')
                                this.guiHandle.getTextDisplay1().setText(mess.trim());
                            else if ((char)data[3] == '1')
                                this.guiHandle.getTextDisplay2().setText(mess.trim());
                        }
                        break;
                        // INFRARED RANGE READ
            case 'r':   if ((char)data[1] == 'i' && (char)data[2] == 'i' &&
                            (char)data[4] == 't' && (char)data[7] == 'd')
                        {   for (int i=8; i<24; ++i)
                                if ((char)data[i] != (byte)0)
                                    mess += (char)data[i];
                            if ((char)data[3] == '0')
                                this.guiHandle.getTextFieldInfraredRangeLeft().setText(this.getStandardNotationUnits(mess.trim()));
                            else if ((char)data[3] == '1')
                                this.guiHandle.getTextFieldInfraredRangeRight().setText(this.getStandardNotationUnits(mess.trim()));
                        }
                        // SONAR RANGE READ
                        else if ((char)data[1] == 's' && (char)data[2] == 'i' &&
                            (char)data[4] == 't' && (char)data[7] == 'd')
                        {   for (int i=8; i<24; ++i)
                                if ((char)data[i] != (byte)0)
                                    mess += (char)data[i];
                            this.guiHandle.getTextFieldSonarRange().setText(this.getStandardNotationUnits(mess.trim()));
                        }
                        // LINE READ
                        else if ((char)data[1] == 'l' && (char)data[2] == 'i' &&
                            (char)data[4] == 't' && (char)data[7] == 'd')
                        {   for (int i=8; i<24; ++i)
                                if ((char)data[i] != (byte)0)
                                    mess += (char)data[i];
                            if ((char)data[3] == '0')
                                this.guiHandle.getTextFieldLineRangeLeft().setText(this.getStandardNotationUnits(mess.trim()));
                            else if ((char)data[3] == '1')
                                this.guiHandle.getTextFieldLineRangeRight().setText(this.getStandardNotationUnits(mess.trim()));
                        }
                        break;

            default:    System.out.println("FROM ROBO TO LAPTOP: ERROR!" + new String (data));
                        break;
        }
    }

    private String getStandardNotationUnits (String num)
    {   return String.valueOf(Double.valueOf(num.substring(0, num.indexOf('E'))).doubleValue()*Math.pow(10, Integer.valueOf(num.substring(num.indexOf('E')+1)).intValue()))+" cm";
    }
}
