/*
 * Decompiled with CFR 0.152.
 */
package hive;

import hive.HiveAboutBox;
import hive.HiveApp;
import hive.HiveLogBox;
import hive.HiveSerialComm;
import hive.HiveSpeakerTones;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class HiveView
extends FrameView {
    private JButton buttonClearScript;
    private JButton buttonLoadScript;
    private JButton buttonRunScript;
    private JButton buttonSaveScript;
    private JButton buttonSpeakerBuzz;
    private JButton buttonSpeakerClick;
    private JButton buttonStartMoveBackward;
    private JButton buttonStartMoveForward;
    private JButton buttonStartReadInfrared;
    private JButton buttonStartTurnLeft;
    private JButton buttonStartTurnRight;
    private JButton jButton13;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel4;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JMenuItem menuItemLog;
    private JPanel panelDisplay;
    private JPanel panelMoveAction;
    private JPanel panelRangeSensorInfrared;
    private JPanel panelRangeSensorSonar;
    private JPanel panelScript;
    private JPanel panelSensorAction;
    private JPanel panelSensorAction1;
    private JPanel panelSensors;
    private JPanel panelVisualSensorFrame;
    private JTabbedPane panelVisualSensorHistogram;
    private JPanel panelVisualSensorMotion;
    private JProgressBar progressBar;
    private JScrollPane scrollPanelScript;
    private JMenuItem serialPortMenuItem;
    private JMenu settingsMenu;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JTabbedPane tabbedPanelDistance;
    private JTable tableScript;
    private JTextField textDisplay1;
    private JTextField textDisplay2;
    private JTextField textFieldInfraredRangeLeft;
    private JTextField textFieldInfraredRangeRight;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JDialog executionLog;
    private JTextArea log = new JTextArea();
    private HiveSerialComm serial;
    private Thread serialThread;
    private HiveSpeakerTones notePicker;
    private final boolean START = true;
    private final boolean STOP = false;
    private boolean flagBuzz = true;
    private boolean flagClick = true;

    public HiveView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HiveView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HiveView.this.busyIconIndex = (HiveView.this.busyIconIndex + 1) % HiveView.this.busyIcons.length;
                HiveView.this.statusAnimationLabel.setIcon(HiveView.this.busyIcons[HiveView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!HiveView.this.busyIconTimer.isRunning()) {
                        HiveView.this.statusAnimationLabel.setIcon(HiveView.this.busyIcons[0]);
                        HiveView.this.busyIconIndex = 0;
                        HiveView.this.busyIconTimer.start();
                    }
                    HiveView.this.progressBar.setVisible(true);
                    HiveView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    HiveView.this.busyIconTimer.stop();
                    HiveView.this.statusAnimationLabel.setIcon(HiveView.this.idleIcon);
                    HiveView.this.progressBar.setVisible(false);
                    HiveView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    HiveView.this.statusMessageLabel.setText(text == null ? "" : text);
                    HiveView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    HiveView.this.progressBar.setVisible(true);
                    HiveView.this.progressBar.setIndeterminate(false);
                    HiveView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = HiveApp.getApplication().getMainFrame();
            this.aboutBox = new HiveAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        HiveApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void showExecutionLog() {
        if (this.executionLog == null) {
            JFrame mainFrame = HiveApp.getApplication().getMainFrame();
            this.executionLog = new HiveLogBox(mainFrame, this.log.getText());
            this.executionLog.setLocationRelativeTo(mainFrame);
        }
        HiveApp.getApplication().show(this.executionLog);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.panelMoveAction = new JPanel();
        this.jLabel1 = new JLabel();
        this.buttonStartMoveForward = new JButton();
        this.jLabel2 = new JLabel();
        this.buttonStartMoveBackward = new JButton();
        this.jLabel3 = new JLabel();
        this.buttonStartTurnLeft = new JButton();
        this.jLabel4 = new JLabel();
        this.buttonStartTurnRight = new JButton();
        this.panelScript = new JPanel();
        this.buttonSaveScript = new JButton();
        this.buttonRunScript = new JButton();
        this.buttonClearScript = new JButton();
        this.buttonLoadScript = new JButton();
        this.scrollPanelScript = new JScrollPane();
        this.tableScript = new JTable();
        this.panelSensors = new JPanel();
        this.panelVisualSensorHistogram = new JTabbedPane();
        this.panelVisualSensorFrame = new JPanel();
        this.panelVisualSensorMotion = new JPanel();
        this.jPanel4 = new JPanel();
        this.tabbedPanelDistance = new JTabbedPane();
        this.panelRangeSensorInfrared = new JPanel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.textFieldInfraredRangeLeft = new JTextField();
        this.textFieldInfraredRangeRight = new JTextField();
        this.panelRangeSensorSonar = new JPanel();
        this.panelDisplay = new JPanel();
        this.textDisplay1 = new JTextField();
        this.textDisplay2 = new JTextField();
        this.panelSensorAction = new JPanel();
        this.jLabel5 = new JLabel();
        this.jButton9 = new JButton();
        this.jLabel6 = new JLabel();
        this.buttonStartReadInfrared = new JButton();
        this.jLabel7 = new JLabel();
        this.jButton13 = new JButton();
        this.panelSensorAction1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.buttonSpeakerBuzz = new JButton();
        this.jLabel9 = new JLabel();
        this.buttonSpeakerClick = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        this.settingsMenu = new JMenu();
        this.serialPortMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.menuItemLog = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(600, 500));
        ResourceMap resourceMap = Application.getInstance(HiveApp.class).getContext().getResourceMap(HiveView.class);
        this.panelMoveAction.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("panelMoveAction.border.title", new Object[0])));
        this.panelMoveAction.setName("panelMoveAction");
        this.panelMoveAction.setPreferredSize(new Dimension(180, 227));
        this.panelMoveAction.setLayout(new GridLayout(0, 2));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setDoubleBuffered(true);
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setNextFocusableComponent(this.buttonStartMoveForward);
        this.panelMoveAction.add(this.jLabel1);
        this.buttonStartMoveForward.setText(resourceMap.getString("buttonStartMoveForward.text", new Object[0]));
        this.buttonStartMoveForward.setMaximumSize(new Dimension(35, 23));
        this.buttonStartMoveForward.setMinimumSize(new Dimension(35, 23));
        this.buttonStartMoveForward.setName("buttonStartMoveForward");
        this.buttonStartMoveForward.setPreferredSize(new Dimension(35, 23));
        this.buttonStartMoveForward.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonStartMoveForwardMouseClicked(evt);
            }
        });
        this.panelMoveAction.add(this.buttonStartMoveForward);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.panelMoveAction.add(this.jLabel2);
        this.buttonStartMoveBackward.setText(resourceMap.getString("buttonStartMoveBackward.text", new Object[0]));
        this.buttonStartMoveBackward.setName("buttonStartMoveBackward");
        this.buttonStartMoveBackward.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonStartMoveBackwardMouseClicked(evt);
            }
        });
        this.panelMoveAction.add(this.buttonStartMoveBackward);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.panelMoveAction.add(this.jLabel3);
        this.buttonStartTurnLeft.setText(resourceMap.getString("buttonStartTurnLeft.text", new Object[0]));
        this.buttonStartTurnLeft.setName("buttonStartTurnLeft");
        this.buttonStartTurnLeft.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonStartTurnLeftMouseClicked(evt);
            }
        });
        this.panelMoveAction.add(this.buttonStartTurnLeft);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.panelMoveAction.add(this.jLabel4);
        this.buttonStartTurnRight.setText(resourceMap.getString("buttonStartTurnRight.text", new Object[0]));
        this.buttonStartTurnRight.setName("buttonStartTurnRight");
        this.buttonStartTurnRight.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonStartTurnRightMouseClicked(evt);
            }
        });
        this.panelMoveAction.add(this.buttonStartTurnRight);
        this.panelScript.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("scriptPanel.border.title", new Object[0])));
        this.panelScript.setName("scriptPanel");
        this.panelScript.setPreferredSize(new Dimension(180, 227));
        this.buttonSaveScript.setText(resourceMap.getString("buttonSaveScript.text", new Object[0]));
        this.buttonSaveScript.setName("buttonSaveScript");
        this.buttonSaveScript.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonSaveScriptMouseClicked(evt);
            }
        });
        this.buttonRunScript.setText(resourceMap.getString("buttonRunScript.text", new Object[0]));
        this.buttonRunScript.setMaximumSize(new Dimension(69, 23));
        this.buttonRunScript.setMinimumSize(new Dimension(69, 23));
        this.buttonRunScript.setName("buttonRunScript");
        this.buttonRunScript.setPreferredSize(new Dimension(69, 23));
        this.buttonClearScript.setLabel(resourceMap.getString("buttonClearScript.label", new Object[0]));
        this.buttonClearScript.setMaximumSize(new Dimension(69, 23));
        this.buttonClearScript.setMinimumSize(new Dimension(69, 23));
        this.buttonClearScript.setName("buttonClearScript");
        this.buttonClearScript.setPreferredSize(new Dimension(69, 23));
        this.buttonClearScript.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonClearScriptMouseClicked(evt);
            }
        });
        this.buttonLoadScript.setText(resourceMap.getString("buttonLoadScript.text", new Object[0]));
        this.buttonLoadScript.setMaximumSize(new Dimension(69, 23));
        this.buttonLoadScript.setMinimumSize(new Dimension(69, 23));
        this.buttonLoadScript.setName("buttonLoadScript");
        this.buttonLoadScript.setPreferredSize(new Dimension(69, 23));
        this.scrollPanelScript.setName("scrollPanelScript");
        this.tableScript.setAutoCreateRowSorter(true);
        this.tableScript.setModel(new DefaultTableModel(new String[]{"Action", "Time(ms)", "Freq(Hz)"}, 10));
        this.tableScript.setColumnSelectionAllowed(true);
        this.tableScript.setDoubleBuffered(true);
        this.tableScript.setDragEnabled(true);
        this.tableScript.setFillsViewportHeight(true);
        this.tableScript.setName("tableScript");
        this.scrollPanelScript.setViewportView(this.tableScript);
        this.tableScript.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.tableScript.getAccessibleContext().setAccessibleName(resourceMap.getString("tableScript.AccessibleContext.accessibleName", new Object[0]));
        GroupLayout panelScriptLayout = new GroupLayout(this.panelScript);
        this.panelScript.setLayout(panelScriptLayout);
        panelScriptLayout.setHorizontalGroup(panelScriptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelScriptLayout.createSequentialGroup().addContainerGap().addGroup(panelScriptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelScriptLayout.createSequentialGroup().addComponent(this.scrollPanelScript, -1, 372, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(panelScriptLayout.createSequentialGroup().addComponent(this.buttonLoadScript, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonSaveScript, -1, 123, Short.MAX_VALUE).addGap(22, 22, 22).addComponent(this.buttonRunScript, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonClearScript, -2, 69, -2).addContainerGap()))));
        panelScriptLayout.setVerticalGroup(panelScriptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelScriptLayout.createSequentialGroup().addComponent(this.scrollPanelScript, -1, 558, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(panelScriptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonLoadScript, -2, -1, -2).addComponent(this.buttonSaveScript).addComponent(this.buttonClearScript, -2, -1, -2).addComponent(this.buttonRunScript, -2, -1, -2)).addContainerGap()));
        this.panelSensors.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("sensorPanel.border.title", new Object[0])));
        this.panelSensors.setName("sensorPanel");
        this.panelSensors.setPreferredSize(new Dimension(180, 227));
        this.panelVisualSensorHistogram.setName("panelVisualSensorHistogram");
        this.panelVisualSensorFrame.setToolTipText(resourceMap.getString("panelVisualSensorFrame.toolTipText", new Object[0]));
        this.panelVisualSensorFrame.setName("panelVisualSensorFrame");
        GroupLayout panelVisualSensorFrameLayout = new GroupLayout(this.panelVisualSensorFrame);
        this.panelVisualSensorFrame.setLayout(panelVisualSensorFrameLayout);
        panelVisualSensorFrameLayout.setHorizontalGroup(panelVisualSensorFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 239, Short.MAX_VALUE));
        panelVisualSensorFrameLayout.setVerticalGroup(panelVisualSensorFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 210, Short.MAX_VALUE));
        this.panelVisualSensorHistogram.addTab(resourceMap.getString("panelVisualSensorFrame.TabConstraints.tabTitle", new Object[0]), this.panelVisualSensorFrame);
        this.panelVisualSensorMotion.setName("panelVisualSensorMotion");
        GroupLayout panelVisualSensorMotionLayout = new GroupLayout(this.panelVisualSensorMotion);
        this.panelVisualSensorMotion.setLayout(panelVisualSensorMotionLayout);
        panelVisualSensorMotionLayout.setHorizontalGroup(panelVisualSensorMotionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 239, Short.MAX_VALUE));
        panelVisualSensorMotionLayout.setVerticalGroup(panelVisualSensorMotionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 210, Short.MAX_VALUE));
        this.panelVisualSensorHistogram.addTab(resourceMap.getString("panelVisualSensorMotion.TabConstraints.tabTitle", new Object[0]), this.panelVisualSensorMotion);
        this.jPanel4.setName("jPanel4");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 239, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 210, Short.MAX_VALUE));
        this.panelVisualSensorHistogram.addTab(resourceMap.getString("jPanel4.TabConstraints.tabTitle", new Object[0]), this.jPanel4);
        this.tabbedPanelDistance.setName("tabbedPanelDistance");
        this.panelRangeSensorInfrared.setName("panelRangeSensorInfrared");
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.textFieldInfraredRangeLeft.setText(resourceMap.getString("textFieldInfraredRangeLeft.text", new Object[0]));
        this.textFieldInfraredRangeLeft.setName("textFieldInfraredRangeLeft");
        this.textFieldInfraredRangeRight.setText(resourceMap.getString("textFieldInfraredRangeRight.text", new Object[0]));
        this.textFieldInfraredRangeRight.setName("textFieldInfraredRangeRight");
        GroupLayout panelRangeSensorInfraredLayout = new GroupLayout(this.panelRangeSensorInfrared);
        this.panelRangeSensorInfrared.setLayout(panelRangeSensorInfraredLayout);
        panelRangeSensorInfraredLayout.setHorizontalGroup(panelRangeSensorInfraredLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRangeSensorInfraredLayout.createSequentialGroup().addContainerGap().addGroup(panelRangeSensorInfraredLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(panelRangeSensorInfraredLayout.createSequentialGroup().addComponent(this.jLabel11).addGap(18, 18, 18).addComponent(this.textFieldInfraredRangeLeft, -2, 170, -2)).addGroup(panelRangeSensorInfraredLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textFieldInfraredRangeRight))).addContainerGap(18, Short.MAX_VALUE)));
        panelRangeSensorInfraredLayout.setVerticalGroup(panelRangeSensorInfraredLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRangeSensorInfraredLayout.createSequentialGroup().addGap(46, 46, 46).addGroup(panelRangeSensorInfraredLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.textFieldInfraredRangeLeft, -2, -1, -2)).addGap(27, 27, 27).addGroup(panelRangeSensorInfraredLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.textFieldInfraredRangeRight, -2, -1, -2)).addContainerGap(101, Short.MAX_VALUE)));
        this.tabbedPanelDistance.addTab(resourceMap.getString("panelRangeSensorInfrared.TabConstraints.tabTitle", new Object[0]), this.panelRangeSensorInfrared);
        this.panelRangeSensorSonar.setName("panelRangeSensorSonar");
        GroupLayout panelRangeSensorSonarLayout = new GroupLayout(this.panelRangeSensorSonar);
        this.panelRangeSensorSonar.setLayout(panelRangeSensorSonarLayout);
        panelRangeSensorSonarLayout.setHorizontalGroup(panelRangeSensorSonarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 239, Short.MAX_VALUE));
        panelRangeSensorSonarLayout.setVerticalGroup(panelRangeSensorSonarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 214, Short.MAX_VALUE));
        this.tabbedPanelDistance.addTab(resourceMap.getString("panelRangeSensorSonar.TabConstraints.tabTitle", new Object[0]), this.panelRangeSensorSonar);
        this.panelDisplay.setBackground(resourceMap.getColor("panelDisplay.background"));
        this.panelDisplay.setName("panelDisplay");
        this.textDisplay1.setBackground(resourceMap.getColor("textDisplay1.background"));
        this.textDisplay1.setText(resourceMap.getString("textDisplay1.text", new Object[0]));
        this.textDisplay1.setName("textDisplay1");
        this.textDisplay2.setBackground(resourceMap.getColor("textDisplay2.background"));
        this.textDisplay2.setText(resourceMap.getString("textDisplay2.text", new Object[0]));
        this.textDisplay2.setName("textDisplay2");
        GroupLayout panelDisplayLayout = new GroupLayout(this.panelDisplay);
        this.panelDisplay.setLayout(panelDisplayLayout);
        panelDisplayLayout.setHorizontalGroup(panelDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDisplayLayout.createSequentialGroup().addContainerGap().addGroup(panelDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textDisplay1, -1, 224, Short.MAX_VALUE).addComponent(this.textDisplay2, -1, 224, Short.MAX_VALUE)).addContainerGap()));
        panelDisplayLayout.setVerticalGroup(panelDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelDisplayLayout.createSequentialGroup().addContainerGap().addComponent(this.textDisplay1, -1, 32, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textDisplay2, -2, 30, -2).addContainerGap()));
        GroupLayout panelSensorsLayout = new GroupLayout(this.panelSensors);
        this.panelSensors.setLayout(panelSensorsLayout);
        panelSensorsLayout.setHorizontalGroup(panelSensorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSensorsLayout.createSequentialGroup().addContainerGap().addGroup(panelSensorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelDisplay, -1, -1, Short.MAX_VALUE).addComponent(this.panelVisualSensorHistogram, -1, 244, Short.MAX_VALUE).addComponent(this.tabbedPanelDistance, -1, 244, Short.MAX_VALUE)).addContainerGap()));
        panelSensorsLayout.setVerticalGroup(panelSensorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSensorsLayout.createSequentialGroup().addComponent(this.panelVisualSensorHistogram, -2, 238, -2).addGap(11, 11, 11).addComponent(this.tabbedPanelDistance, -2, 242, -2).addGap(18, 18, 18).addComponent(this.panelDisplay, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelSensorAction.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("panelSensorAction.border.title", new Object[0])));
        this.panelSensorAction.setName("panelSensorAction");
        this.panelSensorAction.setPreferredSize(new Dimension(180, 227));
        this.panelSensorAction.setLayout(new GridLayout(0, 2));
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setDoubleBuffered(true);
        this.jLabel5.setName("jLabel5");
        this.jLabel5.setNextFocusableComponent(this.buttonStartMoveForward);
        this.panelSensorAction.add(this.jLabel5);
        this.jButton9.setText(resourceMap.getString("jButton9.text", new Object[0]));
        this.jButton9.setMaximumSize(new Dimension(35, 23));
        this.jButton9.setMinimumSize(new Dimension(35, 23));
        this.jButton9.setName("jButton9");
        this.jButton9.setPreferredSize(new Dimension(35, 23));
        this.panelSensorAction.add(this.jButton9);
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.panelSensorAction.add(this.jLabel6);
        this.buttonStartReadInfrared.setText(resourceMap.getString("buttonStartReadInfrared.text", new Object[0]));
        this.buttonStartReadInfrared.setName("buttonStartReadInfrared");
        this.buttonStartReadInfrared.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonStartReadInfraredMouseClicked(evt);
            }
        });
        this.panelSensorAction.add(this.buttonStartReadInfrared);
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.panelSensorAction.add(this.jLabel7);
        this.jButton13.setText(resourceMap.getString("jButton13.text", new Object[0]));
        this.jButton13.setName("jButton13");
        this.panelSensorAction.add(this.jButton13);
        this.panelSensorAction1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("panelSensorAction1.border.title", new Object[0])));
        this.panelSensorAction1.setName("panelSensorAction1");
        this.panelSensorAction1.setPreferredSize(new Dimension(180, 227));
        this.panelSensorAction1.setLayout(new GridLayout(0, 2));
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setDoubleBuffered(true);
        this.jLabel8.setName("jLabel8");
        this.jLabel8.setNextFocusableComponent(this.buttonStartMoveForward);
        this.panelSensorAction1.add(this.jLabel8);
        this.buttonSpeakerBuzz.setText(resourceMap.getString("buttonSpeakerBuzz.text", new Object[0]));
        this.buttonSpeakerBuzz.setMaximumSize(new Dimension(35, 23));
        this.buttonSpeakerBuzz.setMinimumSize(new Dimension(35, 23));
        this.buttonSpeakerBuzz.setName("buttonSpeakerBuzz");
        this.buttonSpeakerBuzz.setPreferredSize(new Dimension(35, 23));
        this.buttonSpeakerBuzz.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonSpeakerBuzzMouseClicked(evt);
            }
        });
        this.panelSensorAction1.add(this.buttonSpeakerBuzz);
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.panelSensorAction1.add(this.jLabel9);
        this.buttonSpeakerClick.setText(resourceMap.getString("buttonSpeakerClick.text", new Object[0]));
        this.buttonSpeakerClick.setName("buttonSpeakerClick");
        this.buttonSpeakerClick.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HiveView.this.buttonSpeakerClickMouseClicked(evt);
            }
        });
        this.panelSensorAction1.add(this.buttonSpeakerClick);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelMoveAction, -1, -1, Short.MAX_VALUE).addComponent(this.panelSensorAction, -1, 180, Short.MAX_VALUE).addComponent(this.panelSensorAction1, -1, 180, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.panelScript, -2, 408, -2).addGap(18, 18, 18).addComponent(this.panelSensors, -2, 280, -2).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelScript, -2, 640, -2).addComponent(this.panelSensors, GroupLayout.Alignment.TRAILING, -1, 640, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.panelMoveAction, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelSensorAction, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelSensorAction1, -2, 74, -2))).addContainerGap()));
        this.panelMoveAction.getAccessibleContext().setAccessibleName(resourceMap.getString("panelMoveAction.AccessibleContext.accessibleName", new Object[0]));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(HiveApp.class).getContext().getActionMap(HiveView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.settingsMenu.setText(resourceMap.getString("settingsMenu.text", new Object[0]));
        this.settingsMenu.setName("settingsMenu");
        this.serialPortMenuItem.setAction(actionMap.get("selectedSerialPortMenuItem"));
        this.serialPortMenuItem.setText(resourceMap.getString("serialPortMenuItem.text", new Object[0]));
        this.serialPortMenuItem.setName("serialPortMenuItem");
        this.settingsMenu.add(this.serialPortMenuItem);
        this.menuBar.add(this.settingsMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("menuItemAbout");
        helpMenu.add(aboutMenuItem);
        this.menuItemLog.setAction(actionMap.get("showExecutionLog"));
        this.menuItemLog.setText(resourceMap.getString("menuItemLog.text", new Object[0]));
        this.menuItemLog.setToolTipText(resourceMap.getString("menuItemLog.toolTipText", new Object[0]));
        this.menuItemLog.setName("menuItemLog");
        helpMenu.add(this.menuItemLog);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setText(resourceMap.getString("statusMessageLabel.text", new Object[0]));
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 924, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.progressBar, -1, 711, Short.MAX_VALUE).addGap(84, 84, 84).addComponent(this.statusMessageLabel).addGap(31, 31, 31).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.statusAnimationLabel).addGap(17, 17, 17)).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.statusMessageLabel, -2, 26, -2).addContainerGap()))).addGroup(statusPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.progressBar, -2, -1, -2).addContainerGap()))));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    public JTextField getTextDisplay2() {
        return this.textDisplay2;
    }

    public JTextField getTextDisplay1() {
        return this.textDisplay1;
    }

    private void buttonSaveScriptMouseClicked(MouseEvent evt) {
        File file = null;
        JFileChooser fc = new JFileChooser();
        ExtensionFileFilter fcFilter = new ExtensionFileFilter("csv");
        fc.setFileFilter(fcFilter);
        if (fc.showSaveDialog(null) == 0) {
            this.progressBar.setVisible(true);
            this.progressBar.setMaximum(this.tableScript.getRowCount() * this.tableScript.getColumnCount());
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            file = fcFilter.accept(fc.getSelectedFile()) ? fc.getSelectedFile() : new File(fc.getSelectedFile().getAbsolutePath() + "." + fcFilter.getExtension());
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                BufferedWriter fileIn = new BufferedWriter(new FileWriter(file.getAbsoluteFile()));
                for (int i = 0; i < this.tableScript.getRowCount(); ++i) {
                    for (int j = 0; j < this.tableScript.getColumnCount(); ++j) {
                        fileIn.write((String)this.tableScript.getValueAt(i, j) + ",");
                        this.progressBar.setValue(this.progressBar.getValue() + 1);
                    }
                    fileIn.write("\n");
                }
                fileIn.flush();
                fileIn.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
            this.log.append("Saving: " + file.getAbsolutePath() + "." + "\n");
            this.progressBar.setVisible(false);
        } else {
            this.log.append("Save command cancelled by user.\n");
        }
        this.log.setCaretPosition(this.log.getDocument().getLength());
    }

    private void buttonClearScriptMouseClicked(MouseEvent evt) {
        for (int i = 0; i < this.tableScript.getRowCount(); ++i) {
            for (int j = 0; j < this.tableScript.getColumnCount(); ++j) {
                this.tableScript.setValueAt(null, i, j);
            }
        }
    }

    private void buttonStartMoveForwardMouseClicked(MouseEvent evt) {
        int count = 0;
        byte[] command = new byte[this.serial.getCommandLength()];
        command[count++] = 109;
        command[count++] = 102;
        command[count++] = 116;
        int n = count++;
        command[count++] = 48;
        command[n] = 48;
        command[count++] = 108;
        command[count++] = 49;
        command[count++] = 114;
        command[count++] = 49;
        while (count < this.serial.getCommandLength() - 1) {
            command[count++] = 0;
        }
        command[count] = 13;
        if (command.length == this.serial.getCommandLength()) {
            this.serial.addCommand(command);
        }
    }

    private void buttonStartMoveBackwardMouseClicked(MouseEvent evt) {
        int count = 0;
        byte[] command = new byte[this.serial.getCommandLength()];
        command[count++] = 109;
        command[count++] = 98;
        command[count++] = 116;
        int n = count++;
        command[count++] = 48;
        command[n] = 48;
        command[count++] = 108;
        command[count++] = 49;
        command[count++] = 114;
        command[count++] = 49;
        while (count < this.serial.getCommandLength() - 1) {
            command[count++] = 0;
        }
        command[count] = 13;
        if (command.length == this.serial.getCommandLength()) {
            this.serial.addCommand(command);
        }
    }

    private void buttonStartTurnLeftMouseClicked(MouseEvent evt) {
        int count = 0;
        byte[] command = new byte[this.serial.getCommandLength()];
        command[count++] = 109;
        command[count++] = 108;
        command[count++] = 116;
        int n = count++;
        command[count++] = 48;
        command[n] = 48;
        command[count++] = 108;
        command[count++] = 49;
        command[count++] = 114;
        command[count++] = 49;
        while (count < this.serial.getCommandLength() - 1) {
            command[count++] = 0;
        }
        command[count] = 13;
        if (command.length == this.serial.getCommandLength()) {
            this.serial.addCommand(command);
        }
    }

    private void buttonStartTurnRightMouseClicked(MouseEvent evt) {
        int count = 0;
        byte[] command = new byte[this.serial.getCommandLength()];
        command[count++] = 109;
        command[count++] = 114;
        command[count++] = 116;
        int n = count++;
        command[count++] = 48;
        command[n] = 48;
        command[count++] = 108;
        command[count++] = 49;
        command[count++] = 114;
        command[count++] = 49;
        while (count < this.serial.getCommandLength() - 1) {
            command[count++] = 0;
        }
        command[count] = 13;
        if (command.length == this.serial.getCommandLength()) {
            this.serial.addCommand(command);
        }
    }

    private void buttonSpeakerBuzzMouseClicked(MouseEvent evt) {
        if (this.flagBuzz) {
            this.flagBuzz = false;
            this.buttonSpeakerBuzz.setText("stop");
            this.serial.addCommand(this.getCommand('s', 'b', (byte)0, (byte)0, (byte)0, ""));
        } else {
            this.flagBuzz = true;
            this.buttonSpeakerBuzz.setText("start");
            this.serial.addCommand(this.getCommand('s', 's', (byte)0, (byte)0, (byte)0, ""));
        }
    }

    private void buttonSpeakerClickMouseClicked(MouseEvent evt) {
        if (this.flagClick) {
            this.flagClick = false;
            this.buttonSpeakerClick.setText("stop");
            this.serial.addCommand(this.getCommand('s', 'c', (byte)0, (byte)0, (byte)0, ""));
        } else {
            this.flagClick = true;
            this.buttonSpeakerClick.setText("start");
            this.serial.addCommand(this.getCommand('s', 's', (byte)0, (byte)0, (byte)0, ""));
        }
    }

    private void buttonStartReadInfraredMouseClicked(MouseEvent evt) {
        this.compileReadRangeCommand('i');
    }

    private void compileReadRangeCommand(char s) {
        int count = 0;
        byte[] command = new byte[this.serial.getCommandLength()];
        command[count++] = 114;
        command[count++] = (byte)s;
        command[count++] = 116;
        int n = count++;
        command[count++] = 48;
        command[n] = 48;
        while (count < this.serial.getCommandLength() - 1) {
            command[count++] = 0;
        }
        command[count] = 13;
        if (command.length == this.serial.getCommandLength()) {
            this.serial.addCommand(command);
        }
    }

    private byte[] getCommand(char c, char m, byte i, byte tu, byte tl, String d) {
        byte[] command = new byte[this.serial.getCommandLength()];
        command[0] = (byte)c;
        command[1] = (byte)m;
        command[2] = 105;
        command[3] = i;
        command[4] = 116;
        command[5] = tu;
        command[6] = tl;
        command[7] = 100;
        for (int n = 8; n < command.length - 1; ++n) {
            command[n] = n - 8 > d.length() - 1 ? (byte)0 : d.getBytes()[n - 8];
        }
        command[this.serial.getCommandLength() - 1] = 13;
        return command;
    }

    @Action
    public void selectedSerialPortMenuItem() {
        try {
            this.serial = new HiveSerialComm(this);
            this.serialThread = new Thread(this.serial);
            this.serialThread.start();
            this.statusMessageLabel.setText("CONNECTED");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public JTextField getTextFieldInfraredRangeLeft() {
        return this.textFieldInfraredRangeLeft;
    }

    public JTextField getTextFieldInfraredRangeRight() {
        return this.textFieldInfraredRangeRight;
    }

    private class ExtensionFileFilter
    extends FileFilter {
        String description;
        String extension;

        public ExtensionFileFilter() {
            this.extension = "";
            this.description = "";
        }

        public ExtensionFileFilter(String description) {
            this.description = this.extension = description.toLowerCase();
        }

        public ExtensionFileFilter(String description, String extension) {
            this.description = description.toLowerCase();
            this.extension = extension.toLowerCase();
        }

        public String getDescription() {
            return this.description;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean accept(File file) {
            if (file.isDirectory() || this.extension.length() == 0) {
                return true;
            }
            String path = file.getAbsolutePath().toLowerCase();
            return path.endsWith(this.extension) && path.charAt(path.length() - this.extension.length() - 1) == '.';
        }
    }
}

