/*
 * Decompiled with CFR 0.152.
 */
package hive;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import hive.HiveView;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiveSerialComm
implements Runnable,
SerialPortEventListener {
    private CommPortIdentifier portId;
    private Enumeration portListEnum;
    private ArrayList<CommPortIdentifier> portListArray;
    private InputStream inputStream;
    private byte[] readBuffer;
    private OutputStream outputStream;
    private SerialPort serialPort;
    private String defaultSerialPort;
    private ArrayList<Byte> commandBuffer;
    private int commandLength;
    private int timeOut;
    private int threadSleep;
    private static Thread serialThread;
    private HiveView guiHandle;

    public HiveSerialComm(HiveView hv) {
        this.guiHandle = hv;
        this.timeOut = 2000;
        this.threadSleep = 1000;
        this.commandLength = 25;
        this.commandBuffer = new ArrayList();
        this.portListArray = new ArrayList();
        this.portListEnum = CommPortIdentifier.getPortIdentifiers();
        this.readBuffer = new byte[255];
        while (this.portListEnum.hasMoreElements() && this.portId == null) {
            CommPortIdentifier pid = (CommPortIdentifier)this.portListEnum.nextElement();
            if (pid.getPortType() != 1) continue;
            if (System.getProperty("os.name", "").toLowerCase().startsWith("windows")) {
                this.defaultSerialPort = "COM6";
            } else if (System.getProperty("os.name", "").toLowerCase().startsWith("linux")) {
                this.defaultSerialPort = "/dev/ttyS0";
            } else if (System.getProperty("os.name", "").toLowerCase().startsWith("mac")) {
                this.defaultSerialPort = "????";
            } else {
                System.out.println("Sorry, your operating system is not supported");
                System.exit(1);
            }
            this.portListArray.add(pid);
            if (!pid.getName().equals(this.defaultSerialPort)) continue;
            this.portId = pid;
            this.initSerialPort();
        }
        if (this.portId == null) {
            System.out.println("Sorry, your operating system has no serial ports");
            System.exit(1);
        }
    }

    public HiveSerialComm(String dsp, int to, HiveView hv) {
        this.guiHandle = hv;
        this.defaultSerialPort = dsp;
        this.timeOut = to;
        this.threadSleep = 1000;
        this.commandLength = 25;
        this.commandBuffer = new ArrayList();
        this.portListArray = new ArrayList();
        this.portListEnum = CommPortIdentifier.getPortIdentifiers();
        this.readBuffer = new byte[255];
        while (this.portListEnum.hasMoreElements() && this.portId == null) {
            CommPortIdentifier pid = (CommPortIdentifier)this.portListEnum.nextElement();
            if (pid.getPortType() != 1) continue;
            this.portListArray.add(pid);
            if (!pid.getName().equals(this.defaultSerialPort)) continue;
            this.portId = pid;
            this.initSerialPort();
        }
        if (this.portId == null) {
            System.out.println("Sorry, your operating system has no serial ports");
            System.exit(1);
        }
    }

    public int getCommandLength() {
        return this.commandLength;
    }

    public Enumeration getPortListEnum() {
        return this.portListEnum;
    }

    public ArrayList<CommPortIdentifier> getPortListArray() {
        return this.portListArray;
    }

    public void setSerialPort(String dsp) {
        this.defaultSerialPort = dsp;
        for (CommPortIdentifier cpi : this.portListArray) {
            if (!cpi.getName().equals(this.defaultSerialPort)) continue;
            this.portId = cpi;
            this.initSerialPort();
        }
    }

    public void setSerialPort(CommPortIdentifier cpi) {
        this.defaultSerialPort = cpi.getName();
        this.portId = cpi;
        this.initSerialPort();
    }

    private void initSerialPort() {
        try {
            this.serialPort = (SerialPort)this.portId.open("RoboHiveApp", this.timeOut);
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
            this.serialPort.addEventListener((SerialPortEventListener)this);
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.notifyOnOutputEmpty(true);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public ArrayList<Byte> getCommandBuffer() {
        return this.commandBuffer;
    }

    public byte[] getCommandBufferInBytes() {
        byte[] b = new byte[this.commandLength];
        int count = 0;
        Iterator<Byte> i = this.commandBuffer.iterator();
        while (i.hasNext()) {
            b[count++] = i.next();
            i.remove();
        }
        return b;
    }

    public void addCommand(byte[] c) {
        for (byte b : c) {
            this.commandBuffer.add(b);
        }
    }

    public void writeToPort(String s) {
        try {
            this.outputStream.write(s.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToPort(byte[] b) {
        try {
            this.outputStream.write(b);
            System.out.println("LAPTOP To ROBO: " + new String(b));
            this.outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    int readHpacket() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.commandBuffer.size() != this.commandLength) {
                    continue;
                }
                this.writeToPort(this.getCommandBufferInBytes());
                Thread.sleep(this.threadSleep);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                int countByte = 0;
                int dataByte = 0;
                try {
                    while ((dataByte = this.inputStream.read()) != -1) {
                        if (dataByte == 0 || dataByte == 10 || countByte >= this.readBuffer.length - 1) continue;
                        this.readBuffer[countByte++] = (byte)dataByte;
                        if ((byte)dataByte != 13) continue;
                        this.executeReadBuffer(countByte);
                    }
                    break;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public void executeReadBuffer(int c) {
        switch ((char)this.readBuffer[0]) {
            case 'd': {
                if ((char)this.readBuffer[1] != 'r' || (char)this.readBuffer[2] != 'i' || (char)this.readBuffer[4] != 't' || (char)this.readBuffer[7] != 'd' || (char)this.readBuffer[this.readBuffer.length - 1] != '\r') break;
                if (this.readBuffer[3] == 0) {
                    this.guiHandle.getTextDisplay1().setText(new String(this.readBuffer, 8, 16));
                    break;
                }
                if (this.readBuffer[3] != 1) break;
                this.guiHandle.getTextDisplay2().setText(new String(this.readBuffer, 8, 16));
                break;
            }
        }
    }
}

