/*
 * Chris Ragland
 * September 18th 2008
 * 
 * SeniorProject.cs
 * 
 * Main file for the game. Based off the code provided by XNA.
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

using System.Xml;

namespace SeniorProject
{
	public class SeniorProject:Microsoft.Xna.Framework.Game
	{
		private const int FixedWidth = 1280;
		private const int FixedHeight = 720;
		private const string title = "Vacare";
		private static GameState gameState = GameState.TitleScreen;
		private static GameState randState = GameState.None;
		private static GraphicsDeviceManager graphics;
		private static SpriteBatch spriteBatch;
		private static ContentManager contentManager;
		private static SpriteFont fontOne;
		private static SpriteFont fontTwo;
		private static KeyboardController controller;
		private static XMLManager xml;
		private HighScores highScoresArray;

		private static AudioEngine audio;
		private static WaveBank waves;
		private static SoundBank sounds;

		Screen screen;

		public static ContentManager ContentManager
		{
			get
			{
				return contentManager;
			}
		}

		public static SpriteBatch SpriteBatch
		{
			get
			{
				return spriteBatch;
			}
		}

		public static GraphicsDeviceManager Graphics
		{
			get
			{
				return graphics;
			}
		}

		public static SpriteFont FontOne
		{
			get
			{
				return fontOne;
			}
		}

		public static SpriteFont FontTwo
		{
			get
			{
				return fontTwo;
			}
		}

		public static ControlUnit Controller
		{
			get { return controller; }
		}

		public static XMLManager XMLManager
		{
			get { return xml; }
		}

		public static SoundBank Sounds
		{
			get { return sounds; }
		}

		public SeniorProject()
		{
			graphics = new GraphicsDeviceManager(this);
			graphics.PreferredBackBufferWidth = FixedWidth;
			graphics.PreferredBackBufferHeight = FixedHeight;
		}

		protected override void Initialize()
		{
			Window.Title = "Vacare";
			Window.AllowUserResizing = false;

			base.Initialize();
			controller = new KeyboardController(1);
			xml = new XMLManager();

			highScoresArray = new HighScores();
			highScoresArray.loadScores();
			screen = new TitleScreen(title);
			sounds.PlayCue("mainbgm");
		}

		protected override void LoadContent()
		{
			spriteBatch = new SpriteBatch(GraphicsDevice);
			contentManager = new ContentManager(Services);
			fontOne = contentManager.Load<SpriteFont>(@"Content\Georgia72");
			fontTwo = contentManager.Load<SpriteFont>(@"Content\Arial24");
			audio = new AudioEngine(@"Content\Sounds\GameSounds.xgs");
			waves = new WaveBank(audio, @"Content\Sounds\waveBank.xwb");
			sounds = new SoundBank(audio, @"Content\Sounds\soundBank.xsb");
		}

		protected override void UnloadContent()
		{
		}

		protected override void Update(GameTime gameTime)
		{
			TimeSpan elapsedTime = gameTime.ElapsedGameTime;
			TimeSpan time = gameTime.TotalGameTime;
			audio.Update();
			Controller.Update();

			randState = screen.Update(time, elapsedTime);
			if(controller.EscPressed)
			{
				if(gameState == GameState.TitleScreen)
				{
					highScoresArray.saveScores();
					this.Exit();
				}
				else
					randState = GameState.TitleScreen;
			}
			ChangedState(randState);

			base.Update(gameTime);
		}

		private void ChangedState(GameState nextState)
		{
			if(nextState == GameState.HighScore)
			{
				if(screen is NameEntryScreen)
				{
					highScoresArray.insertScore(((NameEntryScreen)screen).Entry);
					highScoresArray.saveScores();
				}
				gameState = GameState.HighScore;
				screen = new HighScoreScreen(highScoresArray.HighScoreArray);
			}
			else if(nextState == GameState.TitleScreen)
			{
				gameState = GameState.TitleScreen;
				screen = new TitleScreen(title);
			}
			else if(nextState == GameState.IntroScreen)
			{
				gameState = GameState.IntroScreen;
				screen = new IntroScreen();
			}
			else if(nextState == GameState.PlayGame)
			{
				gameState = GameState.PlayGame;
				screen = new GameScreen(highScoresArray.HighScoreArray[0].Score);
			}
			else if(nextState == GameState.GameOver)
			{
				gameState = GameState.GameOver;
				long score = 0;
				highScoresArray.sortScores();
				if(screen is GameScreen)
					score = ((GameScreen)screen).Score;
				screen = new GameOverScreen(score, highScoresArray.HighScoreArray[9].Score);
			}
			else if(nextState == GameState.NameEntry)
			{
				long score = 0;
				if(screen is GameOverScreen)
					score = ((GameOverScreen)screen).Score;
				gameState = GameState.NameEntry;
				screen = new NameEntryScreen(score);
			}
		}

		protected override void Draw(GameTime gameTime)
		{
			graphics.GraphicsDevice.Clear(Color.CornflowerBlue);
			base.Draw(gameTime);
			screen.Render();
		}
	}
}
