/*
 * Chris Ragland
 * September 18th 2008
 * 
 * Screen.cs
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
    abstract public class Screen
    {
        protected Texture2D texture;

        public Screen()
        {
            this.texture = null;
        }

        public Screen(Texture2D texture)
        {
            this.texture = texture;
        }

        public virtual GameState Update(TimeSpan time, TimeSpan elapsed)
        {
            return GameState.None;
        }

        public virtual void Render()
        {
            if (texture != null)
            {
                SeniorProject.SpriteBatch.Begin();
                SeniorProject.SpriteBatch.Draw(texture, Vector2.Zero, Color.White);
                SeniorProject.SpriteBatch.End();
            }
        }
    }
}
