/*
 * Chris Ragland
 * September 18th 2008
 * 
 * PuzzleGame.cs
 * 
 */

using System;
using System.IO;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class PuzzleGame
	{
		private const int NUMBER_OF_LEVELS = 15;
		private ScoreBar scoreBar;
		protected LevelBuilder[] levelInfo = new LevelBuilder[NUMBER_OF_LEVELS];
		protected Level level;
		protected long score = 0;
		protected long highScore = 0;
		protected double timeLeft = -1;
		protected bool gameOver = false;

		public PuzzleGame(long highScore)
		{
			this.highScore = highScore;
			String temp;
			for(int i = 0; i < NUMBER_OF_LEVELS; i++)
			{
				temp = @"Content\Levels\Level" + (i + 1).ToString() + "Info.xml";
				levelInfo[i] = SeniorProject.XMLManager.DeserializeLevelObject(temp);
			}
			level = new Level(levelInfo[0]);
			scoreBar = new ScoreBar(score, (int)timeLeft, highScore);
		}

		public void Update(TimeSpan elapsed)
		{
			timeLeft = level.Update(elapsed);
			if(timeLeft == 0)
			{
				score = 0;
				gameOver = true;
			}
			LevelFinished();
		}

		private void LevelFinished()
		{
			if(level.LevelFinished())
			{
				score += level.LevelScore();
				scoreBar = new ScoreBar(score, (int)timeLeft, highScore);
				int temp = level.LevelNumber;
				level = null;
				if(temp < NUMBER_OF_LEVELS)
					level = new Level(levelInfo[temp]);
				else
				{
					gameOver = true;
				}
			}
		}

		public void Render()
		{
			SeniorProject.SpriteBatch.Begin();
			scoreBar.Render((int)timeLeft);
			level.Render();
			SeniorProject.SpriteBatch.End();
		}

		public bool GameOver
		{
			get { return gameOver; }
		}

		public long Score
		{
			get { return score; }
		}
	}
}
