/*
 * Chris Ragland
 * November 17th 2008
 * 
 * Player.cs
 * 
 * This is the player class. A simple little ship is drawn
 * and rotated depending on the current angle the player
 * is pointing to.
 * 
 */

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class Player:DrawnObject
	{
		public Player(Vector2 position)
			: base(position, SeniorProject.ContentManager.Load<Texture2D>(@"Content\ship"), new Rectangle((int)position.X, (int)position.Y, 40, 40))
		{
		}

		//Draws the player with the correct rotation (angle)
		public void Render(float angle)
		{
			SeniorProject.SpriteBatch.Draw(texture, rectangle, null, Color.White, angle, new Vector2(20, 20), SpriteEffects.None, 0f);
		}
	}
}