/*
 * Chris Ragland
 * December 15th 2008
 * 
 * NameEntryScreen.cs
 * Lets the player select their initals to be displayed in the
 * High Score list.
 * 
 * Entry from a winning game with a score higher than the 10th place
 * score. Exits to the HighScoreScreen.
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class NameEntryScreen:Screen
	{
		private long score;
		private int index = 0;
		private char[] name = { 'A', 'A', 'A' };
		private HighScoreEntry entry;

		public NameEntryScreen(long score)
			: base(SeniorProject.ContentManager.Load<Texture2D>(@"Content\mainScreen"))
		{
			this.score = score;
		}

		//Determines what letters to show for the inital selection screen
		public override GameState Update(TimeSpan time, TimeSpan elapsed)
		{
			if(SeniorProject.Controller.LeftPressed)
			{
				if(index == 0)
					index = 2;
				else
					index--;
			}

			if(SeniorProject.Controller.RightPressed)
			{
				if(index == 2)
					index = 0;
				else
					index++;
			}

			if(SeniorProject.Controller.UpPressed)
			{
				char temp = name[index];
				int tempValue = (int)temp;

				if(tempValue == 65)
					tempValue = 90;
				else
					tempValue--;

				name[index] = (char)tempValue;
			}

			if(SeniorProject.Controller.DownPressed)
			{
				char temp = name[index];
				int tempValue = (int)temp;

				if(tempValue == 90)
					tempValue = 65;
				else
					tempValue++;

				name[index] = (char)tempValue;
			}

			//If enter is pressed, create a new HighScoreEntry and go to the HighScoreScreen
			if(SeniorProject.Controller.EnterPressed)
			{
				entry = new HighScoreEntry(name[0] + "" + name[1] + "" + name[2], score);
				return GameState.HighScore;
			}
			else
				return GameState.None;
		}

		//Render the 3 chars with a fake 3-d style
		//Current selected letter is yellow
		public override void Render()
		{
			string a = name[0] + "";
			string b = name[1] + "";
			string c = name[2] + "";
			Vector2 positionA = new Vector2(300, 260);
			Vector2 positionB = new Vector2(500, 260);
			Vector2 positionC = new Vector2(700, 260);
			SeniorProject.SpriteBatch.Begin();
			SeniorProject.SpriteBatch.Draw(texture, Vector2.Zero, Color.White);
			for(int i = 0; i < 15; i++)
			{
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, a, positionA, Color.Black);
				positionA.X++;
				positionA.Y++;
			}
			for(int i = 0; i < 15; i++)
			{
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, b, positionB, Color.Black);
				positionB.X++;
				positionB.Y++;
			}
			for(int i = 0; i < 15; i++)
			{
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, c, positionC, Color.Black);
				positionC.X++;
				positionC.Y++;
			}
			if(index == 0)
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, a, positionA, Color.Yellow);
			else
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, a, positionA, Color.BlanchedAlmond);

			if(index == 1)
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, b, positionB, Color.Yellow);
			else
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, b, positionB, Color.BlanchedAlmond);

			if(index == 2)
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, c, positionC, Color.Yellow);
			else
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, c, positionC, Color.BlanchedAlmond);

			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, "Use the arrow keys to enter your initials", new Vector2(320, 100), Color.BlanchedAlmond);
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, "Press Enter To Confirm", new Vector2(880, 660), Color.GreenYellow);
			SeniorProject.SpriteBatch.End();

		}

		//Return the entry created, only called when transfering to HighScoreScreen
		public HighScoreEntry Entry
		{
			get { return entry; }
		}
	}
}
