/*
 * Chris Ragland
 * November 14th 2008
 * 
 * LevelBuilder.cs
 * 
 * Creates the level from the XML files. Reads in only those values
 * actually present in the XML file and disregards the rest.
 * 
 */


using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using Microsoft.Xna.Framework;

namespace SeniorProject
{
    [XmlRootAttribute(ElementName = "LevelData", IsNullable = false)]
    public class LevelBuilder
    {
        private int levelNumber;
        private string levelTitle;
        private Vector2 playerLocation;
        private List<Vector2> targetLocations;
        private List<Vector4> bouncyWalls;
        private List<int> bounceDirectionPerWall;
        private List<Vector4> collideWalls;
        private float velocity;
        private int gravity;
        private int gravitySwitchable;
        private int gravityAutoSwitch;
		private List<Vector2> gravityAutoSwitchTimesAndValues;
        private float gravityValue;
        private int time;
        private int switchLimit;

        public int LevelNumber
        {
            get{return levelNumber;}
            set{levelNumber = value;}
        }
        public string LevelTitle
        {
            get { return levelTitle; }
            set { levelTitle = value; }
        }
        public Vector2 PlayerLocation
        {
            get {return playerLocation;}
            set {playerLocation = value;}
        }
        public List<Vector2> TargetLocations
        {
            get { return targetLocations; }
            set { targetLocations = value; }
        }
        public List<Vector4> BouncyWalls
        {
            get { return bouncyWalls; }
            set { bouncyWalls = value; }
        }
        public List<int> BounceDirectionPerWall
        {
            get { return bounceDirectionPerWall; }
            set { bounceDirectionPerWall = value; }
        }
        public List<Vector4> CollideWalls
        {
            get { return collideWalls; }
            set { collideWalls = value; }
        }
        public float Velocity
        {
            get { return velocity; }
            set { velocity = value; }
        }
        public int Gravity
        {
            get { return gravity; }
            set { gravity = value; }
        }
        public int GravitySwitchable
        {
            get { return gravitySwitchable; }
            set { gravitySwitchable = value; }
        }
        public int GravityAutoSwitch
        {
            get { return gravityAutoSwitch; }
            set { gravityAutoSwitch = value; }
        }
		public List<Vector2> GravityAutoSwitchTimesAndValues
		{
			get { return gravityAutoSwitchTimesAndValues; }
			set { gravityAutoSwitchTimesAndValues = value; }
		}
        public float GravityValue
        {
            get { return gravityValue; }
            set { gravityValue = value; }
        }
        public int Time
        {
            get { return time; }
            set { time = value; }
        }
        public int SwitchLimit
        {
            get { return switchLimit; }
            set { switchLimit = value; }
        }

        public LevelBuilder()
        {
        }
    }
}
