/*
 * Chris Ragland
 * November 14th 2008
 * 
 * HighScores.cs
 * 
 * Reads in the high scores from the scores.txt file.
 * Makes it possible to load, save, insert, and sort the list
 * of high scores.
 * 
 */

using System.IO;

namespace SeniorProject
{
	public class HighScores
	{
		private HighScoreEntry[] scores;

		public HighScores()
		{
			scores = new HighScoreEntry[10];
		}

		public void loadScores()
		{
			FileStream file = new FileStream("scores.txt", FileMode.Open, FileAccess.Read);
			StreamReader reader = new StreamReader(file);
			string tempName;
			string tempScore;
			long realScore;
			for(int i = 0; i < 10; i++)
			{
				tempName = reader.ReadLine();
				tempScore = reader.ReadLine();
				realScore = long.Parse(tempScore);
				scores[i] = new HighScoreEntry(tempName, realScore);
			}
			reader.Close();
			file.Close();
			sortScores();
		}

		public void saveScores()
		{
			sortScores();
			FileStream file = new FileStream("scores.txt", FileMode.Open, FileAccess.Write);
			StreamWriter writer = new StreamWriter(file);
			string tempName;
			string tempScore;
			for(int i = 0; i < 10; i++)
			{
				tempName = scores[i].Name;
				tempScore = scores[i].Score.ToString();
				writer.WriteLine(tempName);
				writer.WriteLine(tempScore);
			}
			writer.Close();
			file.Close();
		}

		public void insertScore(HighScoreEntry newEntry)
		{
			sortScores();
			long temp = newEntry.Score;
			int n = 0;
			bool goingToEnter = false;
			for(int i = 0; i < 10; i++)
			{
				if(temp > scores[i].Score)
				{
					n = i;
					goingToEnter = true;
					break;
				}
			}

			if(goingToEnter)
			{
				HighScoreEntry swapA = scores[n];
				HighScoreEntry swapB;
				scores[n] = newEntry;
				n++;

				for(int j = n; j < 10; j++)
				{
					swapB = scores[j];
					scores[j] = swapA;
					swapA = swapB;
				}
			}
		}

		//Quicksort on the scores so we can compare with the last element to determine
		//If the score we enter is high enough, or to display the highest score
		public void sortScores()
		{
			qs(0, scores.Length - 1);
			int n = 0;
			HighScoreEntry[] newScores = new HighScoreEntry[10];
			for(int i = 9; i >= 0; i--)
			{
				newScores[n] = scores[i];
				n++;
			}
			scores = newScores;
		}

		public void qs(int start, int end)
		{
			int i = start;
			int k = end;

			if(end - start >= 1)
			{
				HighScoreEntry pivot = scores[i];
				while(k > i)
				{
					while(scores[i].Score <= pivot.Score && i <= end && k > i)
						i++;
					while(scores[k].Score > pivot.Score && k >= start && k >= i)
						k--;
					if(k > i)
						swap(i, k);
				}
				swap(start, k);
				qs(start, k - 1);
				qs(k + 1, end);
			}
			else
			{
				return;
			}
		}

		public void swap(int a, int b)
		{
			HighScoreEntry temp = scores[a];
			scores[a] = scores[b];
			scores[b] = temp;
		}

		public HighScoreEntry[] HighScoreArray
		{
			get { return scores; }
		}
	}
}
