/*
 * Chris Ragland
 * November 14th 2008
 * 
 * HighScoreScreen.cs
 * Gets the current high scores and the players to score them
 * and displays them on the screen. After a set period of time
 * or after a button press, gameState goes back to the title
 * screen.
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace SeniorProject
{
	public class HighScoreScreen:Screen
	{
		private double timeout = 5;
		private double endTime = -1;
		private string[] scores = new string[10];
		private string[] names = new string[10];

		public HighScoreScreen(HighScoreEntry[] highScores)
			: base(SeniorProject.ContentManager.Load<Texture2D>(@"Content\mainScreen"))
		{
			for(int i = 0; i < 10; i++)
			{
				names[i] = highScores[i].Name;
				scores[i] = new string('0', 10 - highScores[i].Score.ToString().Length) + highScores[i].Score;
			}
		}

		public override GameState Update(TimeSpan time, TimeSpan elapsed)
		{
			if(endTime < 0)
			{
				endTime = time.TotalSeconds + timeout;
			}

			if(timeout != 0 && time.TotalSeconds > endTime)
			{
				return GameState.TitleScreen;
			}
			else if(SeniorProject.Controller.AnyPressed)
			{
				return GameState.TitleScreen;
			}
			else
			{
				return GameState.None;
			}
		}

		public override void Render()
		{
			Vector2 namePosition = new Vector2(380, 200);
			Vector2 scorePosition = new Vector2(740, 200);

			SeniorProject.SpriteBatch.Begin();
			SeniorProject.SpriteBatch.Draw(texture, Vector2.Zero, Color.White);
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, "HIGH SCORES", new Vector2(80, 20), Color.BlanchedAlmond);
			for(int i = 0; i < 10; i++)
			{
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, names[i], namePosition, Color.BlanchedAlmond);
				namePosition.Y += 50;
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, scores[i], scorePosition, Color.BlanchedAlmond);
				scorePosition.Y += 50;
			}
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, "Press Any Button", new Vector2(980, 660), Color.GreenYellow);
			SeniorProject.SpriteBatch.End();
		}

	}
}