/*
 * Chris Ragland
 * December 15th 2008
 * 
 * GameOverScreen.cs
 * 
 * Determines if the player won or lost, and if they won, if their
 * score is high enough to register as a high score. Displays the correct
 * message for each case.
 * 
 */

using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class GameOverScreen:Screen
	{
		private long myScore;
		private long highScore;
		private bool notHigh = true;

		public GameOverScreen(long myScore, long highScore)
			: base(SeniorProject.ContentManager.Load<Texture2D>(@"Content\mainScreen"))
		{
			this.myScore = myScore;
			this.highScore = highScore;
		}

		public override GameState Update(TimeSpan time, TimeSpan elapsed)
		{
			if(SeniorProject.Controller.AnyPressed)
			{
				if(notHigh)
				{
					return GameState.TitleScreen;
				}
				else
				{
					return GameState.NameEntry;
				}
			}
			else
			{
				return GameState.None;
			}
		}

		public override void Render()
		{
			if(myScore == 0)
			{
				WhatToRender("Game Over", "You lost!!! Try harder next time, and act faster!");
			}
			else
			{
				if(myScore > highScore)
				{
					notHigh = false;
					WhatToRender("YOU WON!", "Plus, your score is high enough to register as a high score!");
				}
				else
					WhatToRender("YOU WON!", "Sorry, but your score is not high enough to be a high score!");
			}
		}

		private void WhatToRender(string stringA, string stringB)
		{
			Vector2 position = new Vector2(240, 200);
			SeniorProject.SpriteBatch.Begin();
			SeniorProject.SpriteBatch.Draw(texture, Vector2.Zero, Color.White);
			for(int i = 0; i < 15; i++)
			{
				SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, stringA, position, Color.Black);		// Faux 3-d Title
				position.X++;
				position.Y++;
			}
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontOne, stringA, position, Color.BlanchedAlmond);
			position = new Vector2(260, 400);
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, stringB, position, Color.BlanchedAlmond);
			SeniorProject.SpriteBatch.DrawString(SeniorProject.FontTwo, "Press Any Button", new Vector2(980, 660), Color.GreenYellow);
			SeniorProject.SpriteBatch.End();
		}

		public long Score
		{
			get { return myScore; }
		}
	}
}
