/*
 * Chris Ragland
 * September 18th 2008
 * 
 * DrawnObject.cs
 * 
 * Base class for all drawn objects (targets, players, ect)
 * 
 */

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	abstract public class DrawnObject
	{
		protected Vector2 position;
		protected Texture2D texture;
		protected Rectangle rectangle;

		#region Properties
		public Vector2 Position
		{
			get { return position; }
			set { position = value; }
		}
		public Rectangle Rectangle
		{
			get { return rectangle; }
			set { rectangle = value; }
		}
		#endregion

		public DrawnObject(Vector2 position, Texture2D texture, Rectangle rectangle)
		{
			this.position = position;
			this.texture = texture;
			this.rectangle = rectangle;
		}

		public DrawnObject(Texture2D texture, Rectangle rectangle)
		{
			this.position = Vector2.Zero;
			this.texture = texture;
			this.rectangle = rectangle;
		}

		public virtual void Render()
		{
			SeniorProject.SpriteBatch.Draw(texture, rectangle, Color.White);
		}
	}
}