/*
 * Chris Ragland
 * November 14th 2008
 * 
 * CollideWall.cs
 * 
 * Makes a wall that destroys bullets.
 * Uses one large texture but only draws the location
 * of the wall, makes for seamless joining.
 * 
 */

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace SeniorProject
{
	public class CollideWall:DrawnObject
	{
		public CollideWall(Vector2 position, Rectangle rectangle)
			: base(position, SeniorProject.ContentManager.Load<Texture2D>(@"Content\collide"), rectangle)
		{
		}

		public override void Render()
		{
			SeniorProject.SpriteBatch.Draw(texture, rectangle, rectangle, Color.White);
		}
	}
}