using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Xml;
using System.Xml.XPath;

namespace Shared.XML.SnapShot
{
    public class Reader
    {
        public static Objects.Service.Log LogConfig()
        {
            Objects.Service.Log s = new Objects.Service.Log();

            try
            {
                s.collectiondaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionDaemonize"));
                s.collectionenumprocesses = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionEnumProcesses"));
                s.collectionenumthreads = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionEnumThreads"));
                s.collectionenumchildwndproc = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionEnumChildWndProc"));
                s.collectionenumthreadwndproc = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionEnumThreadWndProc"));
                s.collectionenumtoplvlwndproc = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionEnumTopLvlWndProc"));
                s.collectionheartbeatforclient = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionHeartBeatForGame"));
                s.collectionheartbeatforphotograph = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionHeartBeatForPhotograph"));
                s.collectionheartbeatforprocess = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionHeartBeatForProcess"));
                s.collectionheartbeatfortrampoline = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/CollectionHeartBeatForTrampoline"));
                s.debuggerdaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/DebuggerDaemonize"));
                s.impersonategetcurrentconsoleusersecuritytoken = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/ImpersonateGetCurrentConsoleUserSecurityToken"));
                s.impersonategetexplorerprocesshandle = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/ImpersonateGetExplorerProcessHandle"));
                s.messengerdaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/MessengerDaemonize"));
                s.photographdaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/PhotographDaemonize"));
                s.photographformat1bppindexed = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/PhotographFormat1BPPIndexed"));
                s.photographformat8bppindexed = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/PhotographFormat8BPPIndexed"));
                s.photographrectangle = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/PhotographRectangle"));
                s.photographrectangletofilejpeg = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/PhotographRectangleToFileJpeg"));
                s.preloadrewritegetexitcodeprocess = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/PreLoadReWriteGetExitCodeProcess"));
                s.preloadrewriteasusergetexitcodeprocess = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/PreLoadReWriteAsUserGetExitCodeProcess"));
                s.rewritedoesdllexportordinal1 = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/ReWriteDoesDllExportOrdinal1"));
                s.rewriteexportcallback = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/ReWriteExportCallback"));
                s.trampolineconnecttonewclient = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/TrampolineConnectToNewClient"));
                s.trampolinedaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/TrampolineDaemonize"));
                s.trampolinedisconnectandreconnect = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/TrampolineDisconnectAndReconnect"));
                s.trampolineparseclientrequest = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Log/TrampolineParseClientRequest"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::LogConfig()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return s;
        }
        public static Objects.Service.Collection CollectionConfig()
        {
            Objects.Service.Collection c = new Objects.Service.Collection();

            try
            {
                c.daemonizegarbagecollectioninterval = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Collection/DaemonizeGarbageCollectionInterval"));
                c.daemonizepollinginterval = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Collection/DaemonizePollingInterval"));
                c.enumchildwndprocbuffersize = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Collection/EnumChildWndProcBufferSize"));
                c.enumthreadwndprocbuffersize = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Collection/EnumThreadWndProcBufferSize"));
                c.enumtoplvlwndprocbuffersize = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Collection/EnumTopLvlWndProcBufferSize"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::CollectionConfig())");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return c;
        }
        public static Objects.Service.Debugger DebuggerConfig()
        {
            Objects.Service.Debugger d = new Objects.Service.Debugger();

            try
            {
                d.daemonizepollinginterval = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Debugger/DaemonizePollingInterval"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::DebuggerConfig())");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return d;
        }
        public static Objects.Service.Messenger MessengerConfig()
        {
            Objects.Service.Messenger m = new Objects.Service.Messenger();

            try
            {
                m.ip = ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Messenger/IP");
                m.port = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Messenger/Port"));
                m.protocol = ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Messenger/Protocol");
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::MessengerConfig()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return m;
        }
        public static Objects.Service.Photograph PhotographConfig()
        {
            Objects.Service.Photograph p = new Objects.Service.Photograph();

            try
            {
                p.daemonizegarbagecollectioninterval = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Photograph/DaemonizeGarbageCollectionInterval"));
                p.daemonizepollinginterval = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Photograph/DaemonizePollingInterval"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::PhotographConfig())");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return p;
        }
        public static Objects.Service.Trampoline TrampolineConfig()
        {
            Objects.Service.Trampoline t = new Objects.Service.Trampoline();

            try
            {
                t.buffersize = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Trampoline/BufferSize"));
                t.instances = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Trampoline/Instances"));
                t.path = ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Trampoline/Path");
                t.timeout = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Trampoline/TimeOut"));
                t.daemon = ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Trampoline/Daemon");
                t.library = ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Trampoline/Library"); ;
                t.reporter = ParseInnerXML(Globals.configs, "/Ludus/SnapShot/Trampoline/Reporter");
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::TrampolineConfig()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return t;
        }

        public static Boolean AllowAutoReSizeConfig(String process, String type)
        {
            Boolean allow = new Boolean();

            try
            {
                allow = Boolean.Parse(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Size/@AllowAutoReSize"));
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::AllowAutoReSizeConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return allow;
        }
        public static Hashtable LayoutsAvailableConfig(String process)
        {
            Hashtable layouts = new Hashtable();

            try
            {
                foreach (String ln in ParseSiblingValues(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout/@Type"))
                {
                    layouts.Add(ln, ln);
                }
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::LayoutsAvailableConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return layouts;
        }
        public static Hashtable LayoutConfig(String process, String type)
        {
            Hashtable layout = new Hashtable();

            try
            {
                Private.SnapShot.Objects.XY potxy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Table/Pot"));
                Private.SnapShot.Objects.Element potelement = new Private.SnapShot.Objects.Element(potxy, "tablepot");
                layout.Add(potelement.xy.ToString().GetHashCode(), potelement);

                foreach (String button in ParseSiblingValues(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Play/@Button"))
                {
                    Private.SnapShot.Objects.XY xy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Play[@Button='" + button + "']"));
                    Private.SnapShot.Objects.Element buttonelement = new Private.SnapShot.Objects.Element(xy, "tablebutton" + button);
                    layout.Add(buttonelement.xy.ToString().GetHashCode(), buttonelement);
                }
                foreach (String card in ParseSiblingValues(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Table/Card/@ID"))
                {
                    Private.SnapShot.Objects.XY xy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Table/Card[@ID='" + card + "']"));
                    Private.SnapShot.Objects.Element cardelement = new Private.SnapShot.Objects.Element(xy, "tablecard" + card);
                    layout.Add(cardelement.xy.ToString().GetHashCode(), cardelement);
                }
                foreach (String player in ParseSiblingValues(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Player/@Position"))
                {
                    Private.SnapShot.Objects.XY bankrollxy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Player[@Position='" + player + "']/BankRoll"));
                    Private.SnapShot.Objects.Element bankrollelement = new Private.SnapShot.Objects.Element(bankrollxy, "player" + player + "bankroll");
                    layout.Add(bankrollelement.xy.ToString().GetHashCode(), bankrollelement);

                    Private.SnapShot.Objects.XY dealerxy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Player[@Position='" + player + "']/Dealer"));
                    Private.SnapShot.Objects.Element dealerelement = new Private.SnapShot.Objects.Element(dealerxy, "player" + player + "dealer");
                    layout.Add(dealerelement.xy.ToString().GetHashCode(), dealerelement);

                    Private.SnapShot.Objects.XY namexy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Player[@Position='" + player + "']/Name"));
                    Private.SnapShot.Objects.Element nameelement = new Private.SnapShot.Objects.Element(namexy, "player" + player + "name");
                    layout.Add(nameelement.xy.ToString().GetHashCode(), nameelement);

                    foreach (String card in ParseSiblingValues(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Player[@Position='" + player + "']/Card/@ID"))
                    {
                        Private.SnapShot.Objects.XY cardxy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Player[@Position='" + player + "']/Card[@ID='" + card + "']"));
                        Private.SnapShot.Objects.Element cardelement = new Private.SnapShot.Objects.Element(cardxy, "player" + player + "card" + card);
                        layout.Add(cardelement.xy.ToString().GetHashCode(), cardelement);
                    }
                }
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::LayoutsConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return layout;
        }
        public static Hashtable LookupConfig(String process, String type)
        {
            Hashtable lookup = new Hashtable();

            try
            {
                foreach (String photograph in ParseSiblingValues(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Lookup/@ID"))
                {
                    UInt64 id = UInt64.Parse(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Lookup[@ID='" + photograph + "']"));
                    lookup.Add(id, photograph);
                }
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::LookupConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return lookup;
        }
        public static Private.SnapShot.Objects.XY SizeConfig(String process, String type)
        {
            Private.SnapShot.Objects.XY xy = new Private.SnapShot.Objects.XY();

            try
            {
                xy = new Private.SnapShot.Objects.XY(ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Layout[@Type='" + type + "']/Size"));
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::SizeConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return xy;
        }
        public static String ProcessesAvailableArgsConfig(String process)
        {
            String args = String.Empty;

            try
            {
                args = ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/ExeArgs");
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::ProcessesAvailableArgsConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return args;
        }
        public static String ProcessesAvailableLocationConfig(String process)
        {
            String path = String.Empty;

            try
            {
                path = ParseInnerXML(Globals.attribsPoker, "/Ludus/Process[@Name='" + process + "']/Exe");
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::ProcessesLocationConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return path;
        }
        public static ArrayList ProcessesAvailableConfig()
        {
            ArrayList process = new ArrayList();

            try
            {
                foreach (String pn in ParseSiblingValues(Globals.attribsPoker, "/Ludus/Process/@Name"))
                {
                    process.Add(pn);
                }
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::ProcessesAvailableConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return process;
        }

        private static String ParseInnerXML(String file, String path)
        {
            String rslt = String.Empty;

            try
            {
                XmlNode node;
                XmlDocument xmldoc = new XmlDocument();
                xmldoc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);

                /* Compile a standard XPath expression. */
                node = xmldoc.SelectSingleNode(path);

                rslt = node.InnerXml;
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::ParseInnerXML()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return rslt;
        }
        private static ArrayList ParseSiblingValues(String file, String path)
        {
            ArrayList list = new ArrayList();

            try
            {
                /* Compile a standard XPath expression. */
                XPathDocument xpathdoc = new XPathDocument(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);
                XPathNavigator nav = xpathdoc.CreateNavigator();
                XPathExpression expr = nav.Compile(path);
                XPathNodeIterator iterator = nav.Select(expr);

                while (iterator.MoveNext())
                {
                    XPathNavigator navDomain = iterator.Current.Clone();
                    list.Add(navDomain.Value);
                }
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::SnapShot::Reader::ParseSiblingValues()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return list;
        }
    }
}
