using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Xml;
using System.Xml.XPath;

namespace Shared.XML.Logic
{
    public class Writer
    {
        public static void AddProfile(Shared.Logic.Poker.Messages.Profile p)
        {
            try
            {
                /* Initialize our empty objects. */
                XmlDocument doc = new XmlDocument();

                /* Load config file into XML parsing libraries. */
                doc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);

                XmlNode root = doc.SelectSingleNode("/Ludus");

                XmlElement profile = doc.CreateElement("Profile");

                XmlElement preflop = doc.CreateElement("PreFlop");
                XmlElement preflopallin = doc.CreateElement("AllIn");
                XmlElement preflopraise = doc.CreateElement("Raise");
                XmlElement preflopbet = doc.CreateElement("Bet");
                XmlElement preflopcall = doc.CreateElement("Call");
                XmlElement preflopcheck = doc.CreateElement("Check");
                XmlElement preflopfold = doc.CreateElement("Fold");
                XmlElement prefloppostsb = doc.CreateElement("PostSB");
                XmlElement prefloppostbb = doc.CreateElement("PostBB");

                profile.SetAttribute("Description", p.description);
                preflop.SetAttribute("Enable", p.preflop.enable.ToString().ToLower());
                preflopallin.SetAttribute("Enable", p.preflop.allin.enable.ToString().ToLower());
                preflopallin.SetAttribute("Amount", p.preflop.allin.amount.ToString());
                preflopallin.SetAttribute("Chance", p.preflop.allin.chance.ToString());
                preflopraise.SetAttribute("Enable", p.preflop.raise.enable.ToString().ToLower());
                preflopraise.SetAttribute("Amount", p.preflop.raise.amount.ToString());
                preflopraise.SetAttribute("Chance", p.preflop.raise.chance.ToString());
                preflopbet.SetAttribute("Enable", p.preflop.bet.enable.ToString().ToLower());
                preflopbet.SetAttribute("Amount", p.preflop.bet.amount.ToString());
                preflopbet.SetAttribute("Chance", p.preflop.bet.chance.ToString());
                preflopcall.SetAttribute("Enable", p.preflop.call.enable.ToString().ToLower());
                preflopcall.SetAttribute("Amount", p.preflop.call.amount.ToString());
                preflopcall.SetAttribute("Chance", p.preflop.call.chance.ToString());
                preflopcheck.SetAttribute("Enable", p.preflop.check.enable.ToString().ToLower());
                preflopfold.SetAttribute("Enable", p.preflop.fold.enable.ToString().ToLower());
                prefloppostsb.SetAttribute("Enable", p.preflop.postsb.enable.ToString().ToLower());
                prefloppostsb.SetAttribute("Amount", p.preflop.postsb.amount.ToString());
                prefloppostbb.SetAttribute("Enable", p.preflop.postbb.enable.ToString().ToLower());
                prefloppostbb.SetAttribute("Amount", p.preflop.postbb.amount.ToString());

                preflop.AppendChild(preflopallin);
                preflop.AppendChild(preflopraise);
                preflop.AppendChild(preflopbet);
                preflop.AppendChild(preflopcall);
                preflop.AppendChild(preflopcheck);
                preflop.AppendChild(preflopfold);
                preflop.AppendChild(prefloppostsb);
                preflop.AppendChild(prefloppostbb);

                XmlElement postflop = doc.CreateElement("PostFlop");
                XmlElement postflopallin = doc.CreateElement("AllIn");
                XmlElement postflopraise = doc.CreateElement("Raise");
                XmlElement postflopbet = doc.CreateElement("Bet");
                XmlElement postflopcall = doc.CreateElement("Call");
                XmlElement postflopcheck = doc.CreateElement("Check");
                XmlElement postflopfold = doc.CreateElement("Fold");

                postflop.SetAttribute("Enable", p.postflop.enable.ToString().ToLower());
                postflopallin.SetAttribute("Enable", p.postflop.allin.enable.ToString().ToLower());
                postflopallin.SetAttribute("Amount", p.postflop.allin.amount.ToString());
                postflopallin.SetAttribute("Chance", p.postflop.allin.chance.ToString());
                postflopraise.SetAttribute("Enable", p.postflop.raise.enable.ToString().ToLower());
                postflopraise.SetAttribute("Amount", p.postflop.raise.amount.ToString());
                postflopraise.SetAttribute("Chance", p.postflop.raise.chance.ToString());
                postflopbet.SetAttribute("Enable", p.postflop.bet.enable.ToString().ToLower());
                postflopbet.SetAttribute("Amount", p.postflop.bet.amount.ToString());
                postflopbet.SetAttribute("Chance", p.postflop.bet.chance.ToString());
                postflopcall.SetAttribute("Enable", p.postflop.call.enable.ToString().ToLower());
                postflopcall.SetAttribute("Amount", p.postflop.call.amount.ToString());
                postflopcall.SetAttribute("Chance", p.postflop.call.chance.ToString());
                postflopcheck.SetAttribute("Enable", p.postflop.check.enable.ToString().ToLower());
                postflopfold.SetAttribute("Enable", p.postflop.fold.enable.ToString().ToLower());

                postflop.AppendChild(postflopallin);
                postflop.AppendChild(postflopraise);
                postflop.AppendChild(postflopbet);
                postflop.AppendChild(postflopcall);
                postflop.AppendChild(postflopcheck);
                postflop.AppendChild(postflopfold);

                profile.AppendChild(preflop);
                profile.AppendChild(postflop);
                root.AppendChild(profile);

                doc.Save(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::Logic::XML::Writer::SaveProfileConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
        }
        public static void DeleteProfile(String p)
        {
            try
            {
                /* Initialize our empty objects. */
                XmlDocument doc = new XmlDocument();

                /* Load config file into XML parsing libraries. */
                doc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);

                XmlElement parent = (XmlElement)doc.SelectSingleNode("/Ludus");
                XmlElement child = (XmlElement)doc.SelectSingleNode("/Ludus/Profile[@Description='" + p + "']");

                parent.RemoveChild(child);

                doc.Save(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::Logic::XML::Writer::DeletProfile()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
        }
        public static void RenameProfile(String oldp, String newp)
        {
            try
            {
                /* Initialize our empty objects. */
                XmlDocument doc = new XmlDocument();

                /* Load config file into XML parsing libraries. */
                doc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);

                XmlElement profile = (XmlElement)doc.SelectSingleNode("/Ludus/Profile[@Description='" + oldp + "']");

                profile.SetAttribute("Description", newp);

                doc.Save(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::Logic::XML::Writer::RenameProfile()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
        }
        public static void SaveProfile(Shared.Logic.Poker.Messages.Profile p)
        {
            try
            {
                /* Initialize our empty objects. */
                XmlDocument doc = new XmlDocument();

                /* Load config file into XML parsing libraries. */
                doc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);

                XmlElement profile = (XmlElement)doc.SelectSingleNode("/Ludus/Profile[@Description='" + p.description + "']");

                profile.RemoveAll();
                profile.SetAttribute("Description", p.description);

                XmlElement preflop = doc.CreateElement("PreFlop");
                XmlElement preflopallin = doc.CreateElement("AllIn");
                XmlElement preflopraise = doc.CreateElement("Raise");
                XmlElement preflopbet = doc.CreateElement("Bet");
                XmlElement preflopcall = doc.CreateElement("Call");
                XmlElement preflopcheck = doc.CreateElement("Check");
                XmlElement preflopfold = doc.CreateElement("Fold");
                XmlElement prefloppostsb = doc.CreateElement("PostSB");
                XmlElement prefloppostbb = doc.CreateElement("PostBB");

                preflop.SetAttribute("Enable", p.preflop.enable.ToString().ToLower());
                preflopallin.SetAttribute("Enable", p.preflop.allin.enable.ToString().ToLower());
                preflopallin.SetAttribute("Amount", p.preflop.allin.amount.ToString());
                preflopallin.SetAttribute("Chance", p.preflop.allin.chance.ToString());
                preflopraise.SetAttribute("Enable", p.preflop.raise.enable.ToString().ToLower());
                preflopraise.SetAttribute("Amount", p.preflop.raise.amount.ToString());
                preflopraise.SetAttribute("Chance", p.preflop.raise.chance.ToString());
                preflopbet.SetAttribute("Enable", p.preflop.bet.enable.ToString().ToLower());
                preflopbet.SetAttribute("Amount", p.preflop.bet.amount.ToString());
                preflopbet.SetAttribute("Chance", p.preflop.bet.chance.ToString());
                preflopcall.SetAttribute("Enable", p.preflop.call.enable.ToString().ToLower());
                preflopcall.SetAttribute("Amount", p.preflop.call.amount.ToString());
                preflopcall.SetAttribute("Chance", p.preflop.call.chance.ToString());
                preflopcheck.SetAttribute("Enable", p.preflop.check.enable.ToString().ToLower());
                preflopfold.SetAttribute("Enable", p.preflop.fold.enable.ToString().ToLower());
                prefloppostsb.SetAttribute("Enable", p.preflop.postsb.enable.ToString().ToLower());
                prefloppostsb.SetAttribute("Amount", p.preflop.postsb.amount.ToString());
                prefloppostbb.SetAttribute("Enable", p.preflop.postbb.enable.ToString().ToLower());
                prefloppostbb.SetAttribute("Amount", p.preflop.postbb.amount.ToString());

                preflop.AppendChild(preflopallin);
                preflop.AppendChild(preflopraise);
                preflop.AppendChild(preflopbet);
                preflop.AppendChild(preflopcall);
                preflop.AppendChild(preflopcheck);
                preflop.AppendChild(preflopfold);
                preflop.AppendChild(prefloppostsb);
                preflop.AppendChild(prefloppostbb);

                XmlElement postflop = doc.CreateElement("PostFlop");
                XmlElement postflopallin = doc.CreateElement("AllIn");
                XmlElement postflopraise = doc.CreateElement("Raise");
                XmlElement postflopbet = doc.CreateElement("Bet");
                XmlElement postflopcall = doc.CreateElement("Call");
                XmlElement postflopcheck = doc.CreateElement("Check");
                XmlElement postflopfold = doc.CreateElement("Fold");

                postflop.SetAttribute("Enable", p.postflop.enable.ToString().ToLower());
                postflopallin.SetAttribute("Enable", p.postflop.allin.enable.ToString().ToLower());
                postflopallin.SetAttribute("Amount", p.postflop.allin.amount.ToString());
                postflopallin.SetAttribute("Chance", p.postflop.allin.chance.ToString());
                postflopraise.SetAttribute("Enable", p.postflop.raise.enable.ToString().ToLower());
                postflopraise.SetAttribute("Amount", p.postflop.raise.amount.ToString());
                postflopraise.SetAttribute("Chance", p.postflop.raise.chance.ToString());
                postflopbet.SetAttribute("Enable", p.postflop.bet.enable.ToString().ToLower());
                postflopbet.SetAttribute("Amount", p.postflop.bet.amount.ToString());
                postflopbet.SetAttribute("Chance", p.postflop.bet.chance.ToString());
                postflopcall.SetAttribute("Enable", p.postflop.call.enable.ToString().ToLower());
                postflopcall.SetAttribute("Amount", p.postflop.call.amount.ToString());
                postflopcall.SetAttribute("Chance", p.postflop.call.chance.ToString());
                postflopcheck.SetAttribute("Enable", p.postflop.check.enable.ToString().ToLower());
                postflopfold.SetAttribute("Enable", p.postflop.fold.enable.ToString().ToLower());

                postflop.AppendChild(postflopallin);
                postflop.AppendChild(postflopraise);
                postflop.AppendChild(postflopbet);
                postflop.AppendChild(postflopcall);
                postflop.AppendChild(postflopcheck);
                postflop.AppendChild(postflopfold);

                profile.AppendChild(preflop);
                profile.AppendChild(postflop);

                doc.Save(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + Globals.profilesPoker);
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::Logic::XML::Writer::SaveProfile()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
        }
    }
}
