using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Xml;
using System.Xml.XPath;

namespace Shared.XML.Logic
{
    public class Reader
    {
        public static Objects.Service.Log LogConfig()
        {
            Objects.Service.Log l = new Objects.Service.Log();

            try
            {
                l.collectiondaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/Logic/Log/CollectionDaemonize"));
                l.messengerdaemonize = UInt16.Parse(ParseInnerXML(Globals.configs, "/Ludus/Logic/Log/MessengerDaemonize"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Logic::Reader::Log()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return l;
        }
        public static Objects.Service.Collection CollectionConfig()
        {
            Objects.Service.Collection c = new Objects.Service.Collection();

            try
            {
                c.daemonizepollinginterval = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/Logic/Collection/DaemonizePollingInterval"));
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Logic::Reader::CollectionConfig())");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return c;
        }
        public static Objects.Service.Messenger MessengerConfig()
        {
            Objects.Service.Messenger m = new Objects.Service.Messenger();

            try
            {
                m.ip = ParseInnerXML(Globals.configs, "/Ludus/Logic/Messenger/IP");
                m.port = UInt32.Parse(ParseInnerXML(Globals.configs, "/Ludus/Logic/Messenger/Port"));
                m.protocol = ParseInnerXML(Globals.configs, "/Ludus/Logic/Messenger/Protocol");
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Logic::Reader::MessengerConfig()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return m;
        }

        public static ArrayList ProfilesAvailableConfig()
        {
            ArrayList profiles = new ArrayList();

            try
            {
                foreach (String pn in ParseSiblingValues(Globals.profilesPoker, "/Ludus/Profile/@Description"))
                {
                    profiles.Add(pn);
                }
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::Logic::XML::Reader::LayoutsAvailableConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return profiles;
        }
        public static Shared.Logic.Poker.Messages.Profile ProfileConfig(String description)
        {
            Shared.Logic.Poker.Messages.Profile profile = new Shared.Logic.Poker.Messages.Profile(description);

            try
            {
                profile.preflop.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/@Enable"));
                profile.preflop.allin.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/AllIn/@Enable"));
                profile.preflop.allin.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/AllIn/@Chance"));
                profile.preflop.allin.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/AllIn/@Amount"));
                profile.preflop.raise.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Raise/@Enable"));
                profile.preflop.raise.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Raise/@Chance"));
                profile.preflop.raise.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Raise/@Amount"));
                profile.preflop.bet.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Bet/@Enable"));
                profile.preflop.bet.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Bet/@Chance"));
                profile.preflop.bet.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Bet/@Amount"));
                profile.preflop.call.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Call/@Enable"));
                profile.preflop.call.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Call/@Chance"));
                profile.preflop.call.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Call/@Amount"));
                profile.preflop.check.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Check/@Enable"));
                profile.preflop.fold.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/Fold/@Enable"));
                profile.preflop.postbb.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/PostBB/@Enable"));
                profile.preflop.postbb.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/PostBB/@Amount"));
                profile.preflop.postsb.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/PostSB/@Enable"));
                profile.preflop.postsb.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PreFlop/PostSB/@Amount"));

                profile.postflop.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/@Enable"));
                profile.postflop.allin.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/AllIn/@Enable"));
                profile.postflop.allin.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/AllIn/@Chance"));
                profile.postflop.allin.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/AllIn/@Amount"));
                profile.postflop.raise.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Raise/@Enable"));
                profile.postflop.raise.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Raise/@Chance"));
                profile.postflop.raise.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Raise/@Amount"));
                profile.postflop.bet.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Bet/@Enable"));
                profile.postflop.bet.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Bet/@Chance"));
                profile.postflop.bet.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Bet/@Amount"));
                profile.postflop.call.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Call/@Enable"));
                profile.postflop.call.chance = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Call/@Chance"));
                profile.postflop.call.amount = float.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Call/@Amount"));
                profile.postflop.check.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Check/@Enable"));
                profile.postflop.fold.enable = Boolean.Parse(ParseInnerXML(Globals.profilesPoker, "/Ludus/Profile[@Description='" + description + "']/PostFlop/Fold/@Enable"));
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::Logic::XML::Reader::ProfileConfig()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return profile;
        }

        private static String ParseInnerXML(String file, String path)
        {
            String rslt = String.Empty;

            try
            {
                XmlNode node;
                XmlDocument xmldoc = new XmlDocument();
                xmldoc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);

                /* Compile a standard XPath expression. */
                node = xmldoc.SelectSingleNode(path);

                rslt = node.InnerXml;
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Logic::Reader::ParseInnerXML()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return rslt;
        }
        private static ArrayList ParseSiblingValues(String file, String path)
        {
            ArrayList list = new ArrayList();

            try
            {
                /* Compile a standard XPath expression. */
                XPathDocument xpathdoc = new XPathDocument(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);
                XPathNavigator nav = xpathdoc.CreateNavigator();
                XPathExpression expr = nav.Compile(path);
                XPathNodeIterator iterator = nav.Select(expr);

                while (iterator.MoveNext())
                {
                    XPathNavigator navDomain = iterator.Current.Clone();
                    list.Add(navDomain.Value);
                }
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Logic");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Logic::Reader::ParseSiblingValues()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return list;
        }
    }
}
