using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Xml;
using System.Xml.XPath;

namespace Shared.XML.Channels
{
    public class Reader
    {
        private static String ParseInnerXML(String file, String path)
        {
            String rslt = String.Empty;

            try
            {
                XmlNode node;
                XmlDocument xmldoc = new XmlDocument();
                xmldoc.Load(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);

                /* Compile a standard XPath expression. */
                node = xmldoc.SelectSingleNode(path);

                rslt = node.InnerXml;
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Channels::Reader::ParseInnerXML()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Channels");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }

            return rslt;
        }
        private static ArrayList ParseSiblingValues(String file, String path)
        {
            ArrayList list = new ArrayList();

            try
            {
                /* Compile a standard XPath expression. */
                XPathDocument xpathdoc = new XPathDocument(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + @"\" + file);
                XPathNavigator nav = xpathdoc.CreateNavigator();
                XPathExpression expr = nav.Compile(path);
                XPathNodeIterator iterator = nav.Select(expr);

                while (iterator.MoveNext())
                {
                    XPathNavigator navDomain = iterator.Current.Clone();
                    list.Add(navDomain.Value);
                }
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Channels");
                StringBuilder evtEntry = new StringBuilder("Shared::XML::Channels::Reader::ParseSiblingValues()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
            return list;
        }
    }
}
