using System;
using System.Collections;
using System.Diagnostics;
using System.Text;

namespace Shared.SnapShot
{
    [Serializable]
    public class Messages : MarshalByRefObject
    {
        [Serializable]
        public class Debugger
        {
            public Boolean photographdebug;
            public Boolean trampolinedebug;
            public Boolean windowdebug;

            public Debugger(Boolean PhotographDebug, Boolean TrampolineDebug, Boolean ClientDebug)
            {
                photographdebug = PhotographDebug;
                trampolinedebug = TrampolineDebug;
                windowdebug = ClientDebug;
            }
        }
        
        [Serializable]
        public class Process
        {
            public String action;
            public UInt32 pid;
            public String name;

            public Process(String Action, UInt32 Pid)
            {
                action = Action;
                pid = Pid;
                name = String.Empty;
            }
        }

        [Serializable]
        public class Client
        {
            public String action;
            public UInt32 pid;
            public IntPtr hwnd;
            public String type;
            public String caption;

            public Client(String Action, UInt32 Pid, IntPtr Hwnd, String Type, String Caption)
            {
                action = Action;
                pid = Pid;
                hwnd = Hwnd;
                type = Type;
                caption = Caption;
            }
        }

        [Serializable]
        public class Element
        {
            public String action;
            public String reporter;
            public UInt32 pid;
            public IntPtr hwnd;
            public String key;
            public String id;
            public IntPtr chwnd;
            public String xy;
            public String value;

            public Element(String Action, UInt32 Pid, IntPtr Hwnd, String Key)
            {
                action = Action;
                reporter = String.Empty;
                pid = Pid;
                hwnd = Hwnd;
                key = Key;
                id = String.Empty;
                chwnd = IntPtr.Zero;
                xy = String.Empty;
                value = String.Empty;
            }
        }
    }
}
