using System;
using System.Collections;
using System.Text;

namespace Shared.Channels.BroadcastEngine
{
    /// <summary>
    /// Describes a callback called when a message is received.
    /// </summary>
    public interface IBroadcastMessenger
    {
        /// <summary>
        /// Is called by the server when a message is accepted.
        /// </summary>
        /// <param name="message">A message.</param>
        /// <param name="nickname">Nickname of the client who sent the message.</param>
        Object ReceiveMessage(Object message, String nickname);
    }

    /// <summary>
    /// Server chat room factory.
    /// </summary>
    public interface IBroadcastServer
    {
        /// <summary>
        /// Performs log in to the chat room.
        /// </summary>
        /// <param name="nickname">Nickname.</param>
        /// <returns>Chat room interface.</returns>
        IBroadcastIt JoinDialog(String nickname);
    }

    /// <summary>
    /// BroadcastChat provides methods for the chatting.
    /// </summary>
    public interface IBroadcastIt
    {
        /// <summary>
        /// Sends the message to all clients.
        /// </summary>
        /// <param name="message">Message being sent.</param>
        void SendMessage(Object message);
    }
}
