#pragma once
#include "Stdafx.h"
#include "PeReWrite.h"
#include "Collection.h"
#include "Messenger.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::Text;

namespace ServiceSnapShot {
	/// <summary>
	/// Summary for Trampoline
	/// </summary>
	public ref class Trampoline :  public System::ComponentModel::Component
	{
	public:
		Trampoline(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Trampoline(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		// Main program function. 
		static void Daemonize(void)
		{
			System::Text::StringBuilder^ evtEntry = gcnew System::Text::StringBuilder(L"ServiceSnapShot::Trampoline::Daemonize()" + Environment::NewLine);
			System::Diagnostics::EventLog^ evtLog = gcnew System::Diagnostics::EventLog(L"Application", L".", L"Ludus SnapShot");

			DWORD i, dwWait, cbRet, dwErr; 
			BOOL fSuccess; 

			// The initial loop creates several instances of a named pipe along with an event object 
			// for each instance.  An overlapped ConnectNamedPipe operation is started for each instance.
			for (i = 0; i < config->instances; i++) 
			{
				// Create an event object for this instance.
				hEvents[i] = CreateEvent( 
					NULL,    // default security attribute
					TRUE,    // manual-reset event
					TRUE,    // initial state = signaled 
					NULL);   // unnamed event object 

				if (hEvents[i] == NULL) 
				{
					evtEntry->Append(Environment::NewLine + L"CreateEvent() failed. Error:" + GetLastError());
					evtLog->WriteEntry(evtEntry->ToString(), ::Diagnostics::EventLogEntryType::Error, log->trampolinedaemonize);

					return;
				}

				Pipe[i].oOverlap.hEvent = hEvents[i]; 

				Pipe[i].hPipeInst = CreateNamedPipe( 
					SERVICESNAPSHOT_TRAMPOLINE_PATH,					// pipe name 
					PIPE_ACCESS_DUPLEX |								// read/write access 
					FILE_FLAG_OVERLAPPED,								// overlapped mode 
					PIPE_TYPE_MESSAGE |									// message-type pipe 
					PIPE_READMODE_MESSAGE |								// message-read mode 
					PIPE_WAIT,											// blocking mode 
					config->instances,									// number of instances 
					config->buffersize * sizeof(CHAR),					// output buffer size 
					config->buffersize * sizeof(CHAR),					// input buffer size 
					NMPWAIT_USE_DEFAULT_WAIT,							// client time-out 
					NULL);												// default security attributes 

				if (Pipe[i].hPipeInst == INVALID_HANDLE_VALUE) 
				{
					evtEntry->Append(Environment::NewLine + L"CreateNamedPipe() failed. Error:" + GetLastError());
					evtLog->WriteEntry(evtEntry->ToString(), ::Diagnostics::EventLogEntryType::Error, log->trampolinedaemonize);

					return;
				}
		 
				// Call the subroutine to connect to the new client. 
				Pipe[i].fPendingIO = ConnectToNewClient(Pipe[i].hPipeInst, &Pipe[i].oOverlap); 

				Pipe[i].dwState = Pipe[i].fPendingIO ? 
					TRAMPOLINE_CONNECTINGSTATE : // still connecting. 
					TRAMPOLINE_READINGSTATE;     // ready to read. 
			} 
			evtEntry->Append(Environment::NewLine + L"Pipe name is " + config->path);
			evtEntry->Append(Environment::NewLine + L"Overalapped instances are " + System::Convert::ToString(config->instances));
			evtEntry->Append(Environment::NewLine + L"Buffer size is " + System::Convert::ToString(config->buffersize));
			evtEntry->Append(Environment::NewLine + L"Timeout is " + System::Convert::ToString(NMPWAIT_USE_DEFAULT_WAIT));
			evtEntry->Append(Environment::NewLine);
			evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->trampolinedaemonize);

			for(;;)
			{ 
				// Wait for the event object to be signaled, indicating completion of an overlapped 
				// read, write, or connect operation. 
				dwWait = WaitForMultipleObjects( 
					config->instances,    // number of event objects 
					hEvents,      // array of event objects 
					FALSE,        // does not wait for all 
					INFINITE);    // waits indefinitely 

				// dwWait shows which pipe completed the operation. 
				i = dwWait - WAIT_OBJECT_0;  // determines which pipe. 

				if (i < 0 || i > (DWORD)(config->instances - 1)) 
				{
					evtEntry->Append(Environment::NewLine + L"WaitForMultipleObjects() index out of range.");
					evtLog->WriteEntry(evtEntry->ToString(), ::Diagnostics::EventLogEntryType::Error, log->trampolinedaemonize);

					return;
				}
				// Get the result if the operation was pending. 
				if (Pipe[i].fPendingIO) 
				{ 
					fSuccess = GetOverlappedResult(
						Pipe[i].hPipeInst, // handle to pipe 
						&Pipe[i].oOverlap, // OVERLAPPED structure 
						&cbRet,            // bytes transferred 
						FALSE);            // do not wait 

					switch (Pipe[i].dwState) 
					{ 
						// Pending connect operation. 
						case TRAMPOLINE_CONNECTINGSTATE: 
							if (!fSuccess) 
							{
								evtEntry->Append(Environment::NewLine + L"Pipe[" + i + "].dwState CONNECTING_STATE failed." 
									+ "Error:" + GetLastError());
								evtLog->WriteEntry(evtEntry->ToString(), ::Diagnostics::EventLogEntryType::Error, log->trampolinedaemonize);

								return;
							}
							Pipe[i].dwState = TRAMPOLINE_READINGSTATE; 
						break; 

						// Pending read operation. 
						case TRAMPOLINE_READINGSTATE: 
							if (! fSuccess || cbRet == 0) 
							{ 
								DisconnectAndReconnect(i); 
								continue; 
							} 
							Pipe[i].dwState = TRAMPOLINE_WRITINGSTATE; 
						break; 

						// Pending write operation. 
						case TRAMPOLINE_WRITINGSTATE: 
							if (! fSuccess || cbRet != Pipe[i].cbToWrite) 
							{ 
								DisconnectAndReconnect(i); 
								continue; 
							} 
							Pipe[i].dwState = TRAMPOLINE_READINGSTATE; 
						break; 

						default: 
						{
							evtEntry->Append(Environment::NewLine + L"Pipe[" + i + "].dwState is an invalid pipe state.");
							evtLog->WriteEntry(evtEntry->ToString(), ::Diagnostics::EventLogEntryType::Error, log->trampolinedaemonize);

							return;
						}
					}  
				} 
				// The pipe state determines which operation to do next. 
				switch (Pipe[i].dwState) 
				{ 
					// TRAMPOLINE_READINGSTATE: 
					// The pipe instance is connected to the client and is ready to read a request from the client. 
					case TRAMPOLINE_READINGSTATE: 
						fSuccess = ReadFile( 
							Pipe[i].hPipeInst, 
							Pipe[i].chRequest, 
							config->buffersize * sizeof(CHAR), 
							&Pipe[i].cbRead, 
							&Pipe[i].oOverlap); 

						// The read operation completed successfully. 
						if (fSuccess && Pipe[i].cbRead != 0) 
						{ 
							Pipe[i].fPendingIO = FALSE; 
							Pipe[i].dwState = TRAMPOLINE_WRITINGSTATE; 
							continue; 
						} 

						// The read operation is still pending. 
						dwErr = GetLastError(); 
						if (!fSuccess && (dwErr == ERROR_IO_PENDING)) 
						{ 
							Pipe[i].fPendingIO = TRUE; 
							continue; 
						} 

						// An error occurred; disconnect from the client. 
						DisconnectAndReconnect(i); 
					break; 

					// TRAMPOLINE_WRITINGSTATE: 
					// The request was successfully read from the client. Get the reply data and write it to the client. 
					case TRAMPOLINE_WRITINGSTATE: 

						ParseClientRequest(&Pipe[i]); 

						fSuccess = WriteFile( 
							Pipe[i].hPipeInst, 
							Pipe[i].chReply, 
							Pipe[i].cbToWrite, 
							&cbRet, 
							&Pipe[i].oOverlap); 

						// The write operation completed successfully. 
						if (fSuccess && cbRet == Pipe[i].cbToWrite) 
						{ 
							Pipe[i].fPendingIO = FALSE; 
							Pipe[i].dwState = TRAMPOLINE_READINGSTATE; 
							continue; 
						}

						// The write operation is still pending. 
						dwErr = GetLastError(); 
						if (!fSuccess && (dwErr == ERROR_IO_PENDING)) 
						{ 
							Pipe[i].fPendingIO = TRUE; 
							continue; 
						} 

						// An error occurred; disconnect from the client. 
						DisconnectAndReconnect(i); 
					break; 

					default: 
					{
						evtEntry->Append(Environment::NewLine + L"Pipe[" + i + "].dwState is an invalid pipe state.");
						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->trampolinedaemonize);

						return;
					}
				} 
			} 
			evtLog->Close();

			return; 
		}
		// Parses named pipe input & responds accordinagly. Kinda... 
		static void ParseClientRequest(LPPIPEINST pipe)
		{
			CHAR delims[] = "|";
			CHAR pszBuffer[TRAMPOLINE_BUFFERSIZE];
			PCHAR pszMsg = pipe->chRequest;
			PCHAR hToken = NULL;
			PCHAR hNextToken = NULL;
			PCHAR hCmd = NULL;
			INT count = 0;
			BOOL rslt = FALSE;

			pszBuffer[count] = '\0';

			// Copy string to a character array. 
			while(*pszMsg)
			{
				pszBuffer[count++] = *pszMsg++;
			}

			pszBuffer[count] = '\0';
			pszMsg = pszBuffer;
			hCmd = strtok_s(pszBuffer, delims, &hNextToken);

			if(strcmp(hCmd, "REPORT") == 0)
			{
				System::UInt32 pid = System::UInt32::Parse(gcnew System::String(strtok_s(NULL, delims, &hNextToken)));
				System::IntPtr hwnd = System::IntPtr(System::Int32::Parse(gcnew System::String(strtok_s(NULL, delims, &hNextToken))));
				System::IntPtr chwnd = System::IntPtr(System::Int32::Parse(gcnew System::String(strtok_s(NULL, delims, &hNextToken))));
				System::String ^api = gcnew System::String(strtok_s(NULL, delims, &hNextToken));
				System::String ^xy = gcnew System::String(strtok_s(NULL, delims, &hNextToken));
				System::String ^txt = gcnew System::String(strtok_s(NULL, delims, &hNextToken));

				// Clear out any chars that aren't worth printing out.
				Private::SnapShot::Filter::NonPrintableASCII(txt);

				// Send reported info to the client collection.
				ServiceSnapShot::Collection::HeartBeatForTrampoline(pid, hwnd, chwnd, api, xy, txt);

				rslt = TRUE;
			}
			else if(strcmp(hCmd, "INFO") == 0)
			{
				rslt = TRUE;
			}
			else if(strcmp(hCmd, "PEREWRITE_PRELOADASUSER") == 0)
			{
				PCHAR pbTargetExe = strtok_s(NULL, delims, &hNextToken);
				PCHAR pbTargetExeArgs = strtok_s(NULL, delims, &hNextToken);

				rslt = ServiceSnapShot::PeReWrite::PreLoadAsUser(pbTargetExe, pbTargetExeArgs, "username");
			}
			else if(strcmp(hCmd, "PEREWRITE_PRELOAD") == 0)
			{
				PCHAR pbTargetExe = strtok_s(NULL, delims, &hNextToken);
				PCHAR pbTargetExeArgs = strtok_s(NULL, delims, &hNextToken);

				rslt = ServiceSnapShot::PeReWrite::PreLoad(pbTargetExe, pbTargetExeArgs);
			}
			else if(strcmp(hCmd, "EXCEPTION_EXECUTE_HANDLER") == 0)
			{
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Trampoline::ParseClientRequest()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

				evtEntry->Append("EXCEPTION ENCOUNTERED..." + Environment::NewLine + gcnew System::String(pipe->chRequest));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->trampolineparseclientrequest);

				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::FailureAudit, log->trampolineparseclientrequest);
				evtLog->Close();

				rslt = FALSE;
			}

			// Send reply to named pipe client. 
			if(rslt)
			{
				strncpy_s(pipe->chReply, _countof(pipe->chReply), "<SUCCESS>", config->buffersize);
			}
			else
			{
				strncpy_s(pipe->chReply, _countof(pipe->chReply), "<ERROR>", config->buffersize);
			}

			pipe->cbToWrite = (DWORD)(strlen(pipe->chReply) + 1) * sizeof(CHAR);
		}
		// This function is called when an error occurs or when the client closes its handle to the 
		// pipe. Disconnect from this client, then call ConnectNamedPipe to wait for another client to connect. 
		static void DisconnectAndReconnect(DWORD i) 
		{ 
			// Disconnect the pipe instance. 
			if (!DisconnectNamedPipe(Pipe[i].hPipeInst)) 
			{
				// Initialize logging. 
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Trampoline::DisconnectAndReconnect()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

				evtEntry->Append(Environment::NewLine + L"Pipe[" + i + "].hPipeInst failed." + "Error:" + GetLastError());
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->trampolinedisconnectandreconnect);

				evtLog->Close();
			}

			// Call a subroutine to connect to the new client. 
			Pipe[i].fPendingIO = ConnectToNewClient( 
				Pipe[i].hPipeInst, 
				&Pipe[i].oOverlap); 

			Pipe[i].dwState = Pipe[i].fPendingIO ? 
				TRAMPOLINE_CONNECTINGSTATE : // still connecting. 
				TRAMPOLINE_READINGSTATE;     // ready to read. 
		} 
		// This function is called to start an overlapped connect operation. It returns TRUE if an 
		// operation is pending or FALSE if the connection has been completed. 
		static BOOL ConnectToNewClient(HANDLE hPipe, LPOVERLAPPED lpo) 
		{ 
			BOOL fConnected, fPendingIO = FALSE; 

			// Start an overlapped connection for this pipe instance. 
			fConnected = ConnectNamedPipe(hPipe, lpo); 

			// Overlapped ConnectNamedPipe should return zero. 
			if (fConnected) 
			{
				// Initialize logging. 
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Trampoline::ConnectToNewClient()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

				evtEntry->Append(Environment::NewLine + L"ConnectNamedPipe() failed. Error:" + GetLastError());
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->trampolineconnecttonewclient);

				evtLog->Close();

				return 0;
			}

			switch (GetLastError()) 
			{ 
				// The overlapped connection in progress. 
				case ERROR_IO_PENDING: 
					fPendingIO = TRUE; 
					break; 

				// Client is already connected, so signal an event. 
				case ERROR_PIPE_CONNECTED: 
					if (SetEvent(lpo->hEvent)) 
					break; 

				// If an error occurs during the connect operation... 
				default: 
				{
					// Initialize logging. 
					StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Trampoline::ConnectToNewClient()" + Environment::NewLine);
					EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

					evtEntry->Append(Environment::NewLine + L"ConnectNamedPipe() failed. Error:" + GetLastError());
					evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->trampolineconnecttonewclient);

					evtLog->Close();

					return 0;
				}
			} 
			return fPendingIO; 
		};
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Trampoline()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static Shared::XML::SnapShot::Objects::Service::Trampoline^ config = Shared::XML::SnapShot::Reader::TrampolineConfig();
		static Shared::XML::SnapShot::Objects::Service::Log^ log = Shared::XML::SnapShot::Reader::LogConfig();
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
