#pragma once
#include "Stdafx.h"
#include "Messenger.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::Drawing;
using namespace System::IO;
using namespace System::Reflection;
using namespace System::Runtime::InteropServices;
using namespace System::Text;

namespace ServiceSnapShot {

	[DllImport("gdi32.dll", SetLastError = true)]
	extern "C" BOOL BitBlt(System::IntPtr hDCDest, System::Int32 nXDest, System::Int32 nYDest, System::Int32 nWidth, System::Int32 nHeight, System::IntPtr hDCSrc, System::Int32 nXSrc, System::Int32 nYSrc, System::Int32 dwRop);

	[DllImport("gdi32.dll", SetLastError = true)]
	extern "C" HDC CreateCompatibleDC(System::IntPtr hDc);

	[DllImport("gdi32.dll", SetLastError = true)]
	extern "C" HBITMAP CreateCompatibleBitmap(System::IntPtr hDc, System::Int32 nWidth, System::Int32 nHeight);

	[DllImport("gdi32.dll", SetLastError = true)]
	extern "C" BOOL DeleteDC(System::IntPtr hDc);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" HDC GetDC(System::IntPtr hWnd);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" HDC GetWindowDC(System::IntPtr hWnd);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" BOOL GetWindowInfo(System::IntPtr hWnd, WINDOWINFO &pWi);

	[DllImport("gdi32.dll", SetLastError = true)]
	extern "C" BOOL PatBlt(System::IntPtr hDC, System::Int32 nXLeft, System::Int32 nYLeft, System::Int32 nWidth, System::Int32 nHeight, System::Int32 dwRop);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT ReleaseDC(System::IntPtr hWnd, System::IntPtr hDc);

	[DllImport("gdi32.dll", SetLastError = true)]
	extern "C" HGDIOBJ SelectObject(System::IntPtr hDC, System::IntPtr hgdiobj);

	/// <summary>
	/// Summary for Photograph
	/// </summary>
	public ref class Photograph :  public System::ComponentModel::Component
	{
	public:
		Photograph(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Photograph(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		static void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Photograph::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

			try
			{
				evtEntry->Append(Environment::NewLine + "Polling interval is " + config->daemonizepollinginterval);
				evtEntry->Append(Environment::NewLine + "Garbage collection interval is " + config->daemonizegarbagecollectioninterval);
				evtEntry->Append(Environment::NewLine);

				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->photographdaemonize);

				for( ; ; )
				{
					// Pause thread execution for polling interval.
					System::Threading::Thread::Sleep(config->daemonizepollinginterval);

					// Lock the object for thread safe iteration.
					msclr::lock plock(((System::Collections::Hashtable^)Private::SnapShot::Globals::collection)->SyncRoot);
					plock.acquire();

					try
					{
						// Identify stale processes within collection...
						for each(System::Object^ pkey in Private::SnapShot::Globals::collection->Keys)
						{
							Private::SnapShot::Objects::Process^ process = (Private::SnapShot::Objects::Process^)Private::SnapShot::Globals::collection[pkey];

							// Lock the object for thread safe iteration.
							msclr::lock glock(process->clients->SyncRoot);
							glock.acquire();

							for each(System::Object^ gkey in process->clients->Keys)
							{
								Private::SnapShot::Objects::Client^ client = (Private::SnapShot::Objects::Client^)process->clients[gkey];

								for each(System::Object^ lkey in client->layout->Keys)
								{
									Private::SnapShot::Objects::Element^ element = (Private::SnapShot::Objects::Element^)client->layout[lkey];

									if(element->id->Contains("card") || element->id->Contains("dealer"))
									{
										System::Drawing::Bitmap^ limg = gcnew System::Drawing::Bitmap(element->xy->x2, element->xy->y2, System::Drawing::Imaging::PixelFormat::Format1bppIndexed);
										limg = Rectangle(client->hwnd, element->xy->x1, element->xy->y1, element->xy->x2 - element->xy->x1, element->xy->y2 - element->xy->y1);
										System::UInt64 lhash = PixelHashCode(limg);

										if(client->lookup->ContainsKey(lhash))
										{
											((Private::SnapShot::Objects::Element^)client->layout[lkey])->reporter = "PHOTOGRAPH";
											((Private::SnapShot::Objects::Element^)client->layout[lkey])->chwnd = System::IntPtr::Zero;
											((Private::SnapShot::Objects::Element^)client->layout[lkey])->xy = element->xy;
											((Private::SnapShot::Objects::Element^)client->layout[lkey])->value = (System::String^)client->lookup[lhash];
											((Private::SnapShot::Objects::Element^)client->layout[lkey])->timestamp = DateTime::Now;

											if(client->allowmonitor)
											{
												Shared::SnapShot::Messages::Element^ message = gcnew Shared::SnapShot::Messages::Element("HEARTBEAT", process->pid, client->hwnd, lkey->ToString());
												message->reporter = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->reporter;
												message->chwnd = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->chwnd;
												message->id = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->id;
												message->xy = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->xy->ToString();
												message->value = ((Private::SnapShot::Objects::Element^)client->layout[lkey])->value;
												ServiceSnapShot::Messenger::BroadcastIt->SendMessage((System::Object^)message);
											}
										}

										if(Private::SnapShot::Globals::photographdebug.Equals(true))
										{
											if(!System::IO::Directory::Exists(Path::GetDirectoryName(Assembly::GetExecutingAssembly()->Location) + "\\..\\Debug\\" + process->name + "\\" + element->id))
											{
												System::IO::Directory::CreateDirectory(Path::GetDirectoryName(Assembly::GetExecutingAssembly()->Location) + "\\..\\Debug\\" + process->name + "\\" + element->id);
											}
											limg->Save(Path::GetDirectoryName(Assembly::GetExecutingAssembly()->Location) + "\\..\\Debug\\" + process->name + "\\" + element->id + "\\" + PixelHashCode(limg) + ".bmp", System::Drawing::Imaging::ImageFormat::Bmp);
										}
									}
								}
							}

							// Release lock on the object.
							glock.release();
						}
					}
					catch(Exception^ ex)
					{
						// Log the exception.
						evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
//						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->photographdaemonize);
						evtLog->Close();
					}
					finally
					{
						evtLog->Close();
					}

					// Release lock on the object.
					plock.release();
				}
			}
			catch(System::Threading::ThreadInterruptedException^ ex)
			{
				// Log the exception.
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Warning, log->photographdaemonize);
				evtLog->Close();
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->photographdaemonize);
				evtLog->Close();
			}
			finally
			{
				evtLog->Close();
			}
		}
		static System::Drawing::Bitmap^ Rectangle(System::IntPtr hWnd)
		{
			// Get window dimensions.
			WINDOWINFO w;
			GetWindowInfo(hWnd, w);

			return Rectangle(hWnd, w.rcWindow.left, w.rcWindow.top, w.rcWindow.right - w.rcWindow.left, w.rcWindow.bottom - w.rcWindow.top);
		}
		static System::Drawing::Bitmap^ Rectangle(System::IntPtr hWnd, RECT r)
		{
			return Rectangle(hWnd, r.left, r.top, r.right - r.left, r.bottom - r.top);
		}
		static System::Drawing::Bitmap^ Rectangle(System::IntPtr hWnd, System::Int32 x1, System::Int32 y1, System::Int32 x2, System::Int32 y2)
		{
			// http://support.microsoft.com/kb/147810
			try
			{
				// Get device context for the entire window, not just the client area.
				System::IntPtr hDCSrc = System::IntPtr(GetWindowDC(hWnd));

				// Create compatibile context.
				System::IntPtr hDCDest = System::IntPtr(CreateCompatibleDC(hDCSrc));

				// Create reference to bitmap.
				System::IntPtr hBitmap = System::IntPtr(CreateCompatibleBitmap(hDCSrc, x2, y2));

				if (hBitmap.Equals(System::IntPtr::Zero))	
				{
					// Release context.
					ReleaseDC(hWnd, hDCSrc);

					// Delete context;
					DeleteDC(hDCDest);

					// Throw an exception that we catch and log.
					throw gcnew Exception();
				}
				else
				{
					// Select compatible bitmap in compatible context. 
					// Copy window context to compatible context.
					// Select previous bitmap back into compatible context.
					System::IntPtr hTmp = System::IntPtr(SelectObject(hDCDest, hBitmap)); 

					// Transfer pixels from source to destination.
					BitBlt(hDCDest, 0, 0, x2, y2, hDCSrc, x1, y1, SRCCOPY); 
		
					// Create GDI+ bitmap for context.
					System::Drawing::Bitmap^ b = System::Drawing::Image::FromHbitmap(hBitmap); 

					// Release context.
					ReleaseDC(hWnd, hDCSrc);

					// Delete context;
					DeleteDC(hDCDest);

					return b;
				}
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Photograph::Rectangle()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
//				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->photographrectangle);
				evtLog->Close();

				return nullptr;
			}
		}
		static System::Boolean RectangleOutline(System::IntPtr hWnd, System::UInt32 bWidth)
		{
			// Get window dimensions.
			WINDOWINFO w;
			GetWindowInfo(hWnd, w);

			return RectangleOutline(hWnd, w.rcWindow.left, w.rcWindow.top, w.rcWindow.right, w.rcWindow.bottom, bWidth);
		}
		static System::Boolean RectangleOutline(System::IntPtr hWnd, RECT r, System::UInt32 bWidth)
		{
			return RectangleOutline(hWnd, r.left, r.top, r.right, r.bottom, bWidth);
		}
		static System::Boolean RectangleOutline(System::IntPtr hWnd, System::Int32 x1, System::Int32 y1, System::Int32 x2, System::Int32 y2, System::UInt32 bWidth)
		{
			try
			{
				// Allocate device context for bit operations.
				System::IntPtr hDC = System::IntPtr(GetWindowDC(hWnd));

				// Outline top side of control.
				PatBlt(hDC, x1 - bWidth, y1 - bWidth, x2 - x1 + (bWidth * 2), bWidth, DSTINVERT);

				// Outline left side of control.
				PatBlt(hDC, x1 - bWidth, y1, bWidth, y2 - y1, DSTINVERT);

				// Outline bottom side of control.
				PatBlt(hDC, x1 - bWidth, y2, x2 - x1 + (bWidth * 2), bWidth, DSTINVERT);

				// Outline right side of control.
				PatBlt(hDC, x2, y1, bWidth, y2 - y1, DSTINVERT);

				// Release device context.
				ReleaseDC(hWnd, hDC);

				return TRUE;
			}
			catch (Exception^ ex) 
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Photograph::RectangleOutline()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
//				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->photographrectangletofilejpeg);
				evtLog->Close();

				return FALSE;
			}
		}
		static System::UInt64 PixelHashCode(System::Drawing::Bitmap^ b)
		{
			System::UInt64 h = 0;

			try
			{
				for(int y = 0; y < b->Height; y++)
				{
					for(int x = 0; x < b->Width; x++)
					{
						h += b->GetPixel(x, y).ToArgb();
					}
				}

				return h;
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Photograph::PixelHashCode()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
//				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->photographformat1bppindexed);
				evtLog->Close();

				return h;
			}
		}
		static System::Drawing::Bitmap^ Format1BPPIndexed(System::Drawing::Bitmap^ ob)
		{
			// http://social.msdn.microsoft.com/Forums/en-US/Vsexpressvb/thread/e5e994e0-bf0b-4c66-83a4-2b7a6f48919e/
			try
			{
				if (ob->PixelFormat == System::Drawing::Imaging::PixelFormat::Format1bppIndexed)
				{
					return ob;
				}

				System::Drawing::Bitmap^ b = gcnew System::Drawing::Bitmap(ob->Width, ob->Height, System::Drawing::Imaging::PixelFormat::Format1bppIndexed);
				System::Drawing::Imaging::BitmapData^ bd = b->LockBits(System::Drawing::Rectangle(0, 0, b->Width, b->Height), System::Drawing::Imaging::ImageLockMode::ReadWrite, System::Drawing::Imaging::PixelFormat::Format1bppIndexed);

				for(int y = 0; y < ob->Height; y++)
				{
					for(int x = 0; x < ob->Width; x++)
					{
						// I didn't keep record or where I found example code for this function.
						if(ob->GetPixel(x, y).GetBrightness() > 0.625f)
						{
							BYTE* p = (BYTE*) bd->Scan0.ToPointer();
							INT index = y * bd->Stride + (x>>3);
							BYTE mask = (BYTE)(0x80>>(x&0x7));

							p[index] |= mask;
						}
					}
				}

				b->UnlockBits(bd);

				return b;
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Photograph::Format1BPPIndexed()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->photographformat1bppindexed);
				evtLog->Close();

				return nullptr;
			}
		}
		static System::Drawing::Bitmap^ Format8BPPIndexed(System::Drawing::Bitmap^ ob)
		{
			// http://support.microsoft.com/kb/319061
			/*
			if (ob.PixelFormat == System.Drawing.Imaging.PixelFormat.Format8bppIndexed)
			{
				return ob;
			}

			System.Drawing.Bitmap bm = new  System.Drawing.Bitmap(ob.Width, ob.Height, System.Drawing.Imaging.PixelFormat.Format8bppIndexed);
			System.Drawing.Imaging.BitmapData bmd = bm.LockBits(new System.Drawing.Rectangle(0, 0, bm.Width, bm.Height), System.Drawing.Imaging.ImageLockMode.ReadWrite, System.Drawing.Imaging.PixelFormat.Format8bppIndexed);

			IntPtr pixels = bmd.Scan0;

			unsafe 
			{ 
				// Get the pointer to the image bits.
				// This is the unsafe operation.
				byte* pBits;
				if (bmd.Stride > 0)
				{
					pBits = (byte*) pixels.ToPointer();
				}
				else
				{
					// If the Stride is negative, Scan0 points to the last 
					// scanline in the buffer. To normalize the loop, obtain
					// a pointer to the front of the buffer that is located 
					// (Height-1) scanlines previous.
					pBits = (byte*) pixels.ToPointer() + bmd.Stride * (ob.Height - 1);
					uint stride = (uint)Math.Abs(bmd.Stride);
				}

				for (uint row = 0; row < ob.Height; ++row)
				{
					for (uint col = 0; col < ob.Width; ++col)
					{
						// Map palette indexes for a gray scale.
						// If you use some other technique to color convert,
						// put your favorite color reduction algorithm here.
						System.Drawing.Color pixel;    // The source pixel.

						// The destination pixel.
						// The pointer to the color index byte of the
						// destination; this real pointer causes this
						// code to be considered unsafe.
						byte* p8bppPixel = pBits + row * bmd.Stride + col;

						pixel = ob.GetPixel((int)col, (int)row);

						// Use luminance/chrominance conversion to get grayscale.
						// Basically, turn the image into black and white TV.
						// Do not calculate Cr or Cb because you 
						// discard the color anyway.
						// Y = Red * 0.299 + Green * 0.587 + Blue * 0.114

						// This expression is best as integer math for performance,
						// however, because GetPixel listed earlier is the slowest 
						// part of this loop, the expression is left as 
						// floating point for clarity.
						double luminance = (pixel.R * 0.299) + (pixel.G * 0.587) + (pixel.B * 0.114);

						// Gray scale is an intensity map from black to white.
						// Compute the index to the grayscale entry that
						// approximates the luminance, and then round the index.
						// Also, constrain the index choices by the number of
						// colors to do, and then set that pixel's index to the 
						// byte value.
						*p8bppPixel = (byte)(luminance * (256-1) / 255 + 0.5);
					}
				} 
			}			
			bm.UnlockBits(bmd);
			return bm;
			*/
			return ob;
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Photograph()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static Shared::XML::SnapShot::Objects::Service::Photograph^ config = Shared::XML::SnapShot::Reader::PhotographConfig();
		static Shared::XML::SnapShot::Objects::Service::Log^ log = Shared::XML::SnapShot::Reader::LogConfig();
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
