#pragma once
#include "Stdafx.h"
#include "../Trampoline/Detours.h"
#include "PeReWriteNative.h"
#include "Impersonate.h"

#define arrayof(x) (sizeof(x)/sizeof(x[0]))
#define LOG_SERVICESNAPSHOT_POSTLOADPEREWRITE 1032
#define LOG_SERVICESNAPSHOT_POSTLOADPEREWRITEASUSER 1034
#define LOG_SERVICESNAPSHOT_PRELOADPEREWRITE 1030
#define LOG_SERVICESNAPSHOT_PRELOADPEREWRITEASUSER 1031

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;

//http://www.webtropy.com/articles/art11.asp?C++Migration
//http://www.tech-archive.net/Archive/DotNet/microsoft.public.dotnet.framework.compactframework/2006-05/msg00583.html

namespace ServiceSnapShot {
	/// <summary>
	/// Summary for PeReWrite
	/// </summary>
	public ref class PeReWrite :  public System::ComponentModel::Component
	{
	public:
		PeReWrite(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		PeReWrite(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		static BOOL PreLoad(LPTSTR pbTargetExecutable, LPTSTR pbTargetExecutableArgs)
		{
			STARTUPINFO si;
			PROCESS_INFORMATION pi;

			System::Text::StringBuilder^ evtEntry = gcnew System::Text::StringBuilder(L"ServiceSnapShot::PeReWrite::PreLoad()" + Environment::NewLine);
			System::Diagnostics::EventLog^ evtLog = gcnew System::Diagnostics::EventLog(L"Application", L".", L"Ludus SnapShot");

			if (!DoesDllExportOrdinal1(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL)) {
				evtEntry->Append(Environment::NewLine 
					+ L"DoesDllExportOrdinal1(" + gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL) + ") failed. Does not export function with ordinal #1.");

				evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Error, log->rewritedoesdllexportordinal1);

				return FALSE;
			}

			ZeroMemory(&si, sizeof(si));
			ZeroMemory(&pi, sizeof(pi));

			// http://forums.microsoft.com/MSDN/ShowPost.aspx?PostID=2581371&SiteID=1 The executable is started within the environment of the service, thus 
			// in the (invisible) desktop of your service. In order to start the application in an interactive desktop you have one option: Set the 'lpDesktop' member
			// of the 'STARTUPINFO' structure accordingly (go with 'winsta0\default' for the default one).
			si.cb = sizeof(si);
			si.lpDesktop = TEXT("winsta0\\default");

			if(!DetourCreateProcessWithDll(pbTargetExecutable,
											pbTargetExecutableArgs,
											NULL, 
											NULL, 
											TRUE, 
											CREATE_DEFAULT_ERROR_MODE | CREATE_SUSPENDED, 
											NULL, 
											NULL,
											&si, 
											&pi, 
											SERVICESNAPSHOT_FILESYSTEMPATH_HOOKDLL, 
											SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL, 
											NULL)) 
			{
				evtEntry->Append(Environment::NewLine + L"DetourCreateProcessWithDll(" 
					+ gcnew ::String(pbTargetExecutable) + ", "
					+ gcnew ::String(pbTargetExecutableArgs) + ", "
					+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_HOOKDLL) + ", "
					+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL) + ") failed.");

				evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Error, log->preloadrewritegetexitcodeprocess);

				return FALSE;
			}

			ResumeThread(pi.hThread);

			DWORD dwResult = 0;

			if (!GetExitCodeProcess(pi.hProcess, &dwResult)) 
			{
				evtEntry->Append(Environment::NewLine + L"GetExitCodeProcess(" + gcnew ::String(pbTargetExecutable) + ") failed.");
				evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Error, log->preloadrewritegetexitcodeprocess);

				return FALSE;
			}

			evtEntry->Append(Environment::NewLine + L"DetourCreateProcessWithDll(" 
				+ gcnew ::String(pbTargetExecutable) + ", "
				+ gcnew ::String(pbTargetExecutableArgs) + ", "
				+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_HOOKDLL) + ", "
				+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL) + ") succeeded.");

			// Write event to log.
			evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Information, log->preloadrewritegetexitcodeprocess);
			evtLog->Close();

			return TRUE;
		}
		static BOOL PreLoadAsUser(LPCSTR pbTargetExecutable, LPTSTR pbTargetExecutableArgs, LPTSTR pbTargetUser)
		{
			STARTUPINFO si;
			PROCESS_INFORMATION pi;
		//	HANDLE UserToken = GetCurrentConsoleUserSecurityToken();
			HANDLE UserToken = NULL;

			System::Text::StringBuilder^ evtEntry = gcnew System::Text::StringBuilder(L"ServiceSnapShot::PeReWrite::PreLoadAsUser()" + Environment::NewLine);
			System::Diagnostics::EventLog^ evtLog = gcnew System::Diagnostics::EventLog(L"Application", L".", L"Ludus SnapShot");

			if (!DoesDllExportOrdinal1(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL)) {
				evtEntry->Append(Environment::NewLine + L"DoesDllExportOrdinal1(" 
					+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL) + ") failed. Does not export function with ordinal #1.");

				evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Error, log->rewritedoesdllexportordinal1);

				return FALSE;
			}

			ZeroMemory(&si, sizeof(si));
			ZeroMemory(&pi, sizeof(pi));

			// http://forums.microsoft.com/MSDN/ShowPost.aspx?PostID=2581371&SiteID=1 The executable is started within the environment of the service, thus 
			// in the (invisible) desktop of your service. In order to start the application in an interactive desktop you have one option: Set the 'lpDesktop' member
			// of the 'STARTUPINFO' structure accordingly (go with 'winsta0\default' for the default one).
			si.cb = sizeof(si);
			si.lpDesktop = TEXT("winsta0\\default");
		/*
			if(!DetourCreateProcessWithDllAsUser(pbTargetUser,
											pbTargetProcess,
											pbTargetExecutableArgs,
											NULL, 
											NULL, 
											TRUE, 
											CREATE_DEFAULT_ERROR_MODE | CREATE_SUSPENDED, 
											NULL, 
											NULL,
											&si, 
											&pi, 
											SERVICESNAPSHOT_FILESYSTEMPATH_HOOKDLL, 
											SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL, 
											NULL)) 
			{
				evtEntry->Append(Environment::NewLine + L"DetourCreateProcessWithDllAsUser(" 
					+ gcnew ::String(UserToken) + ", "
					+ gcnew ::String(pbTargetExecutable) + ", "
					+ gcnew ::String(pbTargetExecutableArgs) + ", "
					+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_HOOKDLL) + ", "
					+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL) + ") failed.");

				evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Error, Log->preloadrewriteasusergetexitcodeprocess);

				return FALSE;
			}
		*/
			ResumeThread(pi.hThread);

			DWORD dwResult = 0;

			if (!GetExitCodeProcess(pi.hProcess, &dwResult)) {
				evtEntry->Append(Environment::NewLine 
					+ L"GetExitCodeProcess("+ gcnew ::String(pbTargetExecutable) + ") failed.");

				evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Error, log->preloadrewriteasusergetexitcodeprocess);

				return FALSE;
			}

			evtEntry->Append(Environment::NewLine + L"DetourCreateProcessWithDllAsUser(" 
				+ gcnew ::String(pbTargetExecutable) + ", "
				+ gcnew ::String(pbTargetExecutableArgs) + ", "
				+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_HOOKDLL) + ", "
				+ gcnew ::String(SERVICESNAPSHOT_FILESYSTEMPATH_REPORTERDLL) + ") succeeded.");

			/* Write event to log. */
			evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Information, log->preloadrewriteasusergetexitcodeprocess);
			evtLog->Close();

			return TRUE;
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~PeReWrite()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static BOOL DoesDllExportOrdinal1(LPCSTR pszDllPath)
		{
			HMODULE hDll = LoadLibraryEx(pszDllPath, NULL, DONT_RESOLVE_DLL_REFERENCES);

			if (hDll == NULL) {
				StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::PeReWrite::DoesDllExportOrdinal1()" + Environment::NewLine);
				EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

				evtEntry->Append(Environment::NewLine + L"LoadLibraryEx(" + gcnew ::String(pszDllPath) + ") failed. GetLastError(" + ::GetLastError() + ")");
				evtLog->WriteEntry(evtEntry->ToString(), ::EventLogEntryType::Error, log->rewritedoesdllexportordinal1);
				evtLog->Close();

				return FALSE;
			}

			BOOL validFlag = FALSE;

			DetourEnumerateExports(hDll, &validFlag, ExportCallback);
		    
			FreeLibrary(hDll);

			return validFlag;
		}
		static Shared::XML::SnapShot::Objects::Service::Trampoline^ config = Shared::XML::SnapShot::Reader::TrampolineConfig();
		static Shared::XML::SnapShot::Objects::Service::Log^ log = Shared::XML::SnapShot::Reader::LogConfig();
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
