#pragma once
#include "Stdafx.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::IO;
using namespace System::Reflection;
using namespace System::Runtime::Remoting;
using namespace System::Runtime::Remoting::Channels;
using namespace System::Runtime::Remoting::Messaging;
using namespace System::Text;
using namespace System::Threading;

using namespace Shared::Channels;
using namespace Shared::Channels::GenuineTcp;
using namespace Shared::Channels::BroadcastEngine;
using namespace Shared::Channels::DotNetRemotingLayer;

namespace ServiceSnapShot {
	/// <summary>
	/// Summary for Channel
	/// </summary>
	public ref class Messenger :  public System::ComponentModel::Component, public Shared::Channels::BroadcastEngine::IBroadcastMessenger
	{
	public:
		static String^ Nickname = AppDomain::CurrentDomain->FriendlyName;
		static Shared::Channels::BroadcastEngine::IBroadcastIt^ BroadcastIt;
		static Shared::Channels::BroadcastEngine::IBroadcastServer^ iBroadcastServer;
		static System::Object^ IBroadcastItLock = gcnew System::Object();

		Messenger(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Messenger(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Messenger::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

//			Logbook::GenuineLoggingServices::SetUpLoggingToFile("C:\\Ludus\\Release\\Debug-ServiceSnapShot-Messenger", "B2D2");

            // Setup remoting with "Shared.Channels" assembly objects as remote object.
			IDictionary^ props = gcnew Hashtable();
            props["name"] = "gtcpd";
            props["prefix"] = "gtcpd";
            props["priority"] = "100";
            props["port"] = "0";
			GenuineTcpChannel^ channel = gcnew GenuineTcpChannel(props, nullptr, nullptr);
			ChannelServices::RegisterChannel(channel, false);
			WellKnownClientTypeEntry^ remotetype = gcnew WellKnownClientTypeEntry(Shared::Channels::GenuineTcp::GenuineTcpChannel::typeid, "gtcpd://127.0.0.1:48889/Messenger");
			RemotingConfiguration::RegisterWellKnownClientType(remotetype);

            // Bind client's receiver.
			RemotingServices::Marshal(this, "Messenger");

            try
			{
                // Subscribe to the chat event after it's locked.
				msclr::lock mlock(IBroadcastItLock);
				mlock.acquire();

				iBroadcastServer = (Shared::Channels::BroadcastEngine::IBroadcastServer^)Activator::GetObject(Shared::Channels::BroadcastEngine::IBroadcastIt::typeid, "gtcpd://127.0.0.1:48889/Server");
				BroadcastIt = iBroadcastServer->JoinDialog(Nickname);

				mlock.release();

				evtEntry->Append(Environment::NewLine + "Client has been started.");
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit);
			}
			catch(Exception^ ex)
			{
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error);
			}
			finally
			{
				evtLog->Close();
			}
		}
		/// <summary>
		/// Message receiver.
		/// It receives messages async and writes them separately from the main thread.
		/// </summary>
		/// <param name="message">The message.</param>
		virtual System::Object^ ReceiveMessage(System::Object^ message, String^ nickname)
		{
			try
			{
				if (message->GetType()->Equals(Shared::Console::Messages::Client::typeid))
                {
					Shared::Console::Messages::Client ^msg = (Shared::Console::Messages::Client^)message;

                    if (msg->action->Equals("CLIENT"))
                    {
						Private::SnapShot::Objects::Process^ process = (Private::SnapShot::Objects::Process^)Private::SnapShot::Globals::collection[msg->pid.ToString()];

						if (process->clients->ContainsKey(msg->hwnd.ToString()))
                        {
							((Private::SnapShot::Objects::Client^)process->clients[msg->hwnd.ToString()])->allowmonitor = msg->allowmonitor;
                        }
                    }
                }
				else if (message->GetType()->Equals(Shared::SnapShot::Messages::Debugger::typeid))
                {
					Shared::SnapShot::Messages::Debugger^ msg = (Shared::SnapShot::Messages::Debugger^)message;

					if(msg->photographdebug.Equals(true))
					{
						Private::SnapShot::Globals::photographdebug = true;
					}
					else if(msg->trampolinedebug.Equals(true))
					{
						Private::SnapShot::Globals::trampolinedebug = true;
					}
					else if(msg->windowdebug.Equals(true))
					{
						Private::SnapShot::Globals::windowdebug = true;
					}

					if(msg->photographdebug.Equals(false))
					{
						Private::SnapShot::Globals::photographdebug = false;
					}
					else if(msg->trampolinedebug.Equals(false))
					{
						Private::SnapShot::Globals::trampolinedebug = false;
					}
					else if(msg->windowdebug.Equals(false))
					{
						Private::SnapShot::Globals::windowdebug = false;
					}
                }
			}
            catch (Exception^ ex)
            {
				StringBuilder^ evtEntry = gcnew StringBuilder("ServiceSnapShot::Messenger::ReceiveMessage()" + Environment::NewLine);
                EventLog^ evtLog = gcnew EventLog("Application", ".", "Ludus SnapShot");
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
                evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error);
				evtLog->Close();
            }
			return nullptr;
		}
		/// <summary>
		/// This is to insure that when created as a Singleton, the first instance never dies,
		/// regardless of the expired time.
		/// </summary>
		/// <returns></returns>
		virtual System::Object^ InitializeLifetimeService() override
		{
			return nullptr;
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Messenger()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
