#pragma once
#include "Stdafx.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::IO;
using namespace System::Reflection;
using namespace System::Text;
using namespace System::Threading;

namespace ServiceSnapShot {
	/// <summary>
	/// Summary for Debugger
	/// </summary>
	public ref class Debugger :  public System::ComponentModel::Component
	{
	public:
		Debugger(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Debugger(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		static void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceSnapShot::Debugger::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus SnapShot");

			try
			{
				evtEntry->Append(Environment::NewLine + "Polling interval is " + config->daemonizepollinginterval);
				evtEntry->Append(Environment::NewLine);
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->debuggerdaemonize);

				for( ; ; )
				{
					try
					{
						// Pause thread execution for polling interval.
						System::Threading::Thread::Sleep(config->daemonizepollinginterval);

						// Lock the object for thread safe iteration.
						msclr::lock qlock(Private::SnapShot::Globals::diagnostic->SyncRoot);
						qlock.acquire();

						for(int i = 1; i < Private::SnapShot::Globals::diagnostic->Count; i++)
						{
							Private::SnapShot::Objects::Debugger ^debug = (Private::SnapShot::Objects::Debugger^)Private::SnapShot::Globals::diagnostic->Dequeue();

							StreamWriter ^file = File::AppendText(Path::GetDirectoryName(Assembly::GetExecutingAssembly()->Location) + "\\..\\Debug\\" + AppDomain::CurrentDomain->FriendlyName + "-" + debug->pid + "-" + debug->hwnd + ".txt");
							file->WriteLine("[" + debug->timestamp + "] " + debug->reporter + " " + debug->chwnd + " " + debug->api + " " + debug->key + " " + debug->xy + " \"" + debug->value + "\"");
							file->Close();
						}

						// Release lock on the object.
						qlock.release();
					}
					catch(System::Threading::ThreadInterruptedException^ ex)
					{
						// Log the exception.
						evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Warning, log->debuggerdaemonize);
					}
					catch(Exception ^ex)
					{
						// Log the exception.
						evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->debuggerdaemonize);
					}
				}
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->debuggerdaemonize);
			}
			finally
			{
				evtLog->Close();
			}
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Debugger()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static Shared::XML::SnapShot::Objects::Service::Debugger^ config = Shared::XML::SnapShot::Reader::DebuggerConfig();
		static Shared::XML::SnapShot::Objects::Service::Log^ log = Shared::XML::SnapShot::Reader::LogConfig();
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
