#pragma once
#include "Stdafx.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::IO;
using namespace System::Reflection;
using namespace System::Runtime::Remoting;
using namespace System::Runtime::Remoting::Channels;
using namespace System::Runtime::Remoting::Messaging;
using namespace System::Text;
using namespace System::Text::RegularExpressions;
using namespace System::Threading;

using namespace Shared::Channels;
using namespace Shared::Channels::GenuineTcp;
using namespace Shared::Channels::BroadcastEngine;
using namespace Shared::Channels::DotNetRemotingLayer;

namespace ServiceLogic {
	/// <summary>
	/// Summary for Messenger
	/// </summary>
	public ref class Messenger :  public System::ComponentModel::Component, public Shared::Channels::BroadcastEngine::IBroadcastMessenger
	{
	public:
		static String^ Nickname = AppDomain::CurrentDomain->FriendlyName;
		static Shared::Channels::BroadcastEngine::IBroadcastIt^ BroadcastIt;
		static Shared::Channels::BroadcastEngine::IBroadcastServer^ iBroadcastServer;
		static System::Object^ IBroadcastItLock = gcnew System::Object();

		Messenger(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Messenger(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceLogic::Messenger::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus Logic");

            // Setup remoting with "Shared.Channels" assembly objects as remote object.
			IDictionary^ props = gcnew Hashtable();
            props["name"] = "gtcpd";
            props["prefix"] = "gtcpd";
            props["priority"] = "100";
            props["port"] = "0";
			GenuineTcpChannel^ channel = gcnew GenuineTcpChannel(props, nullptr, nullptr);
			ChannelServices::RegisterChannel(channel, false);
			WellKnownClientTypeEntry^ remotetype = gcnew WellKnownClientTypeEntry(Shared::Channels::GenuineTcp::GenuineTcpChannel::typeid, "gtcpd://127.0.0.1:48889/Messenger");
			RemotingConfiguration::RegisterWellKnownClientType(remotetype);

            // Bind client's receiver.
			RemotingServices::Marshal(this, "Messenger");

            try
			{
                // Subscribe to the chat event after it's locked.
				msclr::lock mlock(IBroadcastItLock);
				mlock.acquire();

				iBroadcastServer = (Shared::Channels::BroadcastEngine::IBroadcastServer^)Activator::GetObject(Shared::Channels::BroadcastEngine::IBroadcastIt::typeid, "gtcpd://127.0.0.1:48889/Server");
				BroadcastIt = iBroadcastServer->JoinDialog(Nickname);

				mlock.release();

				evtEntry->Append(Environment::NewLine + "Client has been started.");
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit);
			}
			catch(Exception^ ex)
			{
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error);
			}
			finally
			{
				evtLog->Close();
			}
		}
		/// <summary>
		/// Message receiver.
		/// It receives messages async and writes them separately from the main thread.
		/// </summary>
		/// <param name="message">The message.</param>
		virtual System::Object^ ReceiveMessage(System::Object^ message, String^ nickname)
		{
            EventLog^ evtLog = gcnew EventLog("Application", ".", "Ludus Logic");
			StringBuilder^ evtEntry = gcnew StringBuilder("ServiceLogic::Messenger::ReceiveMessage()" + Environment::NewLine);

			try
            {
				if (message->GetType()->Equals(Shared::SnapShot::Messages::Element::typeid))
                {
					Shared::SnapShot::Messages::Element^ msg = (Shared::SnapShot::Messages::Element^)message;
					if (msg->action->Equals("HEARTBEAT"))
					{
						if ((Regex::IsMatch(msg->id, "card[0-9]*", RegexOptions::IgnoreCase | RegexOptions::Compiled) && msg->reporter->Equals("PHOTOGRAPH"))
							|| Regex::IsMatch(msg->id, "player[0-9]*name", RegexOptions::IgnoreCase | RegexOptions::Compiled))
						{
							Private::Logic::Objects::Process ^process = (Private::Logic::Objects::Process^)Private::Logic::Globals::collection[msg->pid.ToString()];
							Private::Logic::Objects::Client ^client = (Private::Logic::Objects::Client^)process->clients[msg->hwnd.ToString()];

							if (msg->value->Equals(System::String::Empty))
							{
								client->layout->Remove(msg->key->ToString());
							}
							else if (client->layout->ContainsKey(msg->key->ToString()))
							{
								((Private::Logic::Objects::Element^)client->layout[msg->key->ToString()])->value = msg->value;
							}
							else
							{
								Private::Logic::Objects::Element ^element = gcnew Private::Logic::Objects::Element(msg->key->ToString(), msg->id, msg->value);
								client->layout->Add(msg->key->ToString(), element);
							}
						}
						else if (Regex::IsMatch(msg->id, "tablebutton[0-9]*", RegexOptions::IgnoreCase | RegexOptions::Compiled))
						{
							Private::Logic::Objects::Process^ process = (Private::Logic::Objects::Process^)Private::Logic::Globals::collection[msg->pid.ToString()];
							Private::Logic::Objects::Client^ client = (Private::Logic::Objects::Client^)process->clients[msg->hwnd.ToString()];

							Regex ^value = gcnew Regex("post bb|post sb|fold|check|call|bet|raise|all-in", RegexOptions::IgnoreCase | RegexOptions::Compiled);
							Regex ^amount = gcnew Regex("[0-9]+.[0-9]+|[0-9]+", RegexOptions::IgnoreCase | RegexOptions::Compiled);

							if (msg->value->Equals(System::String::Empty))
							{
								client->layout->Remove(msg->key->ToString());
							}
							else if (client->layout->ContainsKey(msg->key->ToString()))
							{
								Match ^mplay = value->Match(msg->value);
								if(mplay->Success)
								{
									((Private::Logic::Objects::Element^)client->layout[msg->key->ToString()])->id = msg->id;
									((Private::Logic::Objects::Element^)client->layout[msg->key->ToString()])->value = mplay->ToString();

									Match ^mamount = amount->Match(msg->value);
									if(mamount->Success)
									{
										((Private::Logic::Objects::Element^)client->layout[msg->key->ToString()])->amount = Convert::ToDouble(mamount->ToString());
									}
									else
									{
										((Private::Logic::Objects::Element^)client->layout[msg->key->ToString()])->amount = 0;
									}
								}
							}
							else
							{
								Private::Logic::Objects::Element ^element = gcnew Private::Logic::Objects::Element(msg->key, msg->id, msg->value);

								Match ^mplay = value->Match(msg->value);
								if(mplay->Success)
								{
									element->chwnd = msg->chwnd;
									element->value = mplay->ToString();

									Match ^mamount = amount->Match(msg->value);
									if(mamount->Success)
									{
										element->amount = Convert::ToDouble(mamount->ToString());
										client->layout->Add(msg->key->ToString(), element);
									}
									else
									{
										element->amount = 0.0;
										client->layout->Add(msg->key->ToString(), element);
									}
								}
							}
						}
					}
                }
				else if (message->GetType()->Equals(Shared::SnapShot::Messages::Client::typeid))
                {
					Shared::SnapShot::Messages::Client^ msg = (Shared::SnapShot::Messages::Client^)message;
                    if (msg->action->Equals("HEARTBEAT"))
                    {
						Private::Logic::Objects::Process^ process = (Private::Logic::Objects::Process^)Private::Logic::Globals::collection[msg->pid.ToString()];
						if (msg->caption->Equals(System::String::Empty))
                        {
                            process->clients->Remove(msg->hwnd.ToString());
                        }
						else if (process->clients->ContainsKey(msg->hwnd.ToString()))
                        {
							((Private::Logic::Objects::Client^)process->clients[msg->hwnd.ToString()])->caption = msg->caption;
                        }
                        else
                        {
							Private::Logic::Objects::Client^ client = gcnew Private::Logic::Objects::Client(msg->hwnd, msg->caption);
                            process->clients->Add(msg->hwnd.ToString(), client);
                        }
                    }
                }
				else if (message->GetType()->Equals(Shared::SnapShot::Messages::Process::typeid))
                {
					Shared::SnapShot::Messages::Process^ msg = (Shared::SnapShot::Messages::Process^)message;
                    if (msg->action->Equals("HEARTBEAT"))
                    {
						if (msg->name->Equals(System::String::Empty))
                        {
							Private::Logic::Globals::collection->Remove(msg->pid.ToString());
                        }
						else if (Private::Logic::Globals::collection->ContainsKey(msg->pid.ToString()))
                        {
							((Private::Logic::Objects::Process^)Private::Logic::Globals::collection[msg->pid.ToString()])->name = msg->name;
                        }
                        else
                        {
							Private::Logic::Objects::Process ^process = gcnew Private::Logic::Objects::Process(msg->pid, msg->name);
							Private::Logic::Globals::collection->Add(msg->pid.ToString(), process);
                        }
                    }
                }
				else if (message->GetType()->Equals(Shared::Console::Messages::Client::typeid))
                {
					Shared::Console::Messages::Client ^msg = (Shared::Console::Messages::Client^)message;
                    if (msg->action->Equals("CLIENT"))
                    {
						Private::Logic::Objects::Process^ process = (Private::Logic::Objects::Process^)Private::Logic::Globals::collection[msg->pid.ToString()];
						if (process->clients->ContainsKey(msg->hwnd.ToString()))
                        {
							((Private::Logic::Objects::Client^)process->clients[msg->hwnd.ToString()])->allowmonitor = msg->allowmonitor;
							((Private::Logic::Objects::Client^)process->clients[msg->hwnd.ToString()])->allowplay = msg->allowplay;
							((Private::Logic::Objects::Client^)process->clients[msg->hwnd.ToString()])->profile = msg->profile;
                        }
                    }
                }
				else if (message->GetType()->Equals(Shared::Console::Messages::Profile::typeid))
                {
					Shared::Console::Messages::Profile ^msg = (Shared::Console::Messages::Profile^)message;

					if (msg->action->Equals("SAVE"))
					{
						Shared::Logic::Poker::Messages::Profile ^profile = Shared::XML::Logic::Reader::ProfileConfig(msg->cprofile);
						Private::Logic::Globals::logic->Remove(msg->cprofile->GetHashCode());
						Private::Logic::Globals::logic->Add(msg->cprofile->GetHashCode(), profile);
					}
					else if (msg->action->Equals("ADD"))
					{
						Shared::Logic::Poker::Messages::Profile ^profile = Shared::XML::Logic::Reader::ProfileConfig(msg->cprofile);
						Private::Logic::Globals::logic->Add(msg->cprofile->GetHashCode(), profile);
					}
					else if (msg->action->Equals("DELETE"))
					{
						Private::Logic::Globals::logic->Remove(msg->cprofile->GetHashCode());

						msclr::lock plock(Private::Logic::Globals::collection->SyncRoot);
						plock.acquire();

						for each(System::Object ^pkey in Private::Logic::Globals::collection->Keys)
						{
							Private::Logic::Objects::Process ^process = (Private::Logic::Objects::Process^)Private::Logic::Globals::collection[pkey];

							msclr::lock glock(process->clients->SyncRoot);
							glock.acquire();

							for each(System::Object ^gkey in process->clients->Keys)
							{
								if(((Private::Logic::Objects::Client^)process->clients[gkey])->profile = msg->cprofile)
								{
									((Private::Logic::Objects::Client^)process->clients[gkey])->profile = nullptr;
								}
							}
							glock.release();
						}
						plock.release();
					}
					else if (msg->action->Equals("RENAME"))
					{
						Shared::Logic::Poker::Messages::Profile ^profile = Shared::XML::Logic::Reader::ProfileConfig(msg->nprofile);
						Private::Logic::Globals::logic->Remove(msg->cprofile->GetHashCode());
						Private::Logic::Globals::logic->Add(msg->cprofile->GetHashCode(), profile);

						msclr::lock plock(Private::Logic::Globals::collection->SyncRoot);
						plock.acquire();

						for each(System::Object ^pkey in Private::Logic::Globals::collection->Keys)
						{
							Private::Logic::Objects::Process ^process = (Private::Logic::Objects::Process^)Private::Logic::Globals::collection[pkey];

							msclr::lock glock(process->clients->SyncRoot);
							glock.acquire();

							for each(System::Object ^gkey in process->clients->Keys)
							{
								if(((Private::Logic::Objects::Client^)process->clients[gkey])->profile = msg->cprofile)
								{
									((Private::Logic::Objects::Client^)process->clients[gkey])->profile = msg->nprofile;
								}
							}
							glock.release();
						}
						plock.release();
					}
                }
            }
            catch (Exception^ ex)
            {
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
                evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error);
            }
			finally
			{
				evtLog->Close();
			}
			return nullptr;
		}
		/// <summary>
		/// This is to insure that when created as a Singleton, the first instance never dies,
		/// regardless of the expired time.
		/// </summary>
		/// <returns></returns>
		virtual System::Object^ InitializeLifetimeService() override
		{
			return nullptr;
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Messenger()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
