#pragma once
#include "Stdafx.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::IO;
using namespace System::Reflection;
using namespace System::Runtime::Remoting;
using namespace System::Runtime::Remoting::Channels;
using namespace System::Runtime::Remoting::Messaging;
using namespace System::Text;
using namespace System::Threading;

using namespace Shared::Channels;
using namespace Shared::Channels::GenuineTcp;
using namespace Shared::Channels::BroadcastEngine;
using namespace Shared::Channels::DotNetRemotingLayer;

namespace ServiceDelegate {
	/// <summary>
	/// Summary for Messenger
	/// </summary>
	public ref class Messenger :  public System::ComponentModel::Component, public Shared::Channels::BroadcastEngine::IBroadcastMessenger
	{
	public:
		static String^ Nickname = AppDomain::CurrentDomain->FriendlyName;
		static Shared::Channels::BroadcastEngine::IBroadcastIt^ BroadcastIt;
		static Shared::Channels::BroadcastEngine::IBroadcastServer^ iBroadcastServer;
		static System::Object^ IBroadcastItLock = gcnew System::Object();

		Messenger(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Messenger(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"Service::Delegate::Messenger::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus Delegate");

//			Logbook::GenuineLoggingServices::SetUpLoggingToFile("C:\\Ludus\\Release\\Debug.Service.Delegate.Messenger", "B2D2");

			// Setup remoting with "Shared.Channels" assembly objects as remote object.
			IDictionary^ props = gcnew Hashtable();
            props["name"] = "gtcpd";
            props["prefix"] = "gtcpd";
            props["priority"] = "100";
            props["port"] = "0";
			GenuineTcpChannel^ channel = gcnew GenuineTcpChannel(props, nullptr, nullptr);
			ChannelServices::RegisterChannel(channel, false);
			WellKnownClientTypeEntry^ remotetype = gcnew WellKnownClientTypeEntry(Shared::Channels::GenuineTcp::GenuineTcpChannel::typeid, "gtcpd://127.0.0.1:48889/Messenger");
			RemotingConfiguration::RegisterWellKnownClientType(remotetype);

            // Bind client's receiver.
			RemotingServices::Marshal(this, "Messenger");

            try
			{
                // Subscribe to the chat event after it's locked.
				msclr::lock mlock(IBroadcastItLock);
				mlock.acquire();

				iBroadcastServer = (Shared::Channels::BroadcastEngine::IBroadcastServer^)Activator::GetObject(Shared::Channels::BroadcastEngine::IBroadcastIt::typeid, "gtcpd://127.0.0.1:48889/Server");
				BroadcastIt = iBroadcastServer->JoinDialog(Nickname);

				mlock.release();

				evtEntry->Append(Environment::NewLine + "Client has been started.");
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit);
			}
			catch(Exception^ ex)
			{
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error);
			}
			finally
			{
				evtLog->Close();
			}
		}
		/// <summary>
		/// Message receiver.
		/// It receives messages async and writes them separately from the main thread.
		/// </summary>
		/// <param name="message">The message.</param>
		virtual System::Object^ ReceiveMessage(System::Object^ message, String^ nickname)
		{
            EventLog^ evtLog = gcnew EventLog("Application", ".", "Ludus Delegate");
			StringBuilder^ evtEntry = gcnew StringBuilder("Service::Delegate::Messenger::ReceiveMessage()" + Environment::NewLine);

			try
            {
				if (message->GetType()->Equals(Shared::SnapShot::Messages::Element::typeid))
                {
					Shared::SnapShot::Messages::Element^ msg = (Shared::SnapShot::Messages::Element^)message;

					if (msg->action->Equals("HEARTBEAT"))
					{
						Private::Delegate::Objects::Process ^process = (Private::Delegate::Objects::Process^)Private::Delegate::Globals::collection[msg->pid.ToString()];
						Private::Delegate::Objects::Client ^client = (Private::Delegate::Objects::Client^)process->clients[msg->hwnd.ToString()];

						if (msg->value->Equals(System::String::Empty))
						{
							client->layout->Remove(msg->key->ToString());
						}
						else if (client->layout->ContainsKey(msg->key->ToString()))
						{
							((Private::Delegate::Objects::Element^)client->layout[msg->key->ToString()])->chwnd = msg->chwnd;
							((Private::Delegate::Objects::Element^)client->layout[msg->key->ToString()])->id = msg->id;
							((Private::Delegate::Objects::Element^)client->layout[msg->key->ToString()])->xy = gcnew Private::Delegate::Objects::XY(msg->xy);
							((Private::Delegate::Objects::Element^)client->layout[msg->key->ToString()])->value = msg->value;
						}
						else
						{
							Private::Delegate::Objects::Element ^element = gcnew Private::Delegate::Objects::Element(msg->key);
							element->chwnd = msg->chwnd;
							element->id = msg->id;
							element->xy = gcnew Private::Delegate::Objects::XY(msg->xy);
							element->value = msg->value;
							client->layout->Add(msg->key->ToString(), element);
						}
					}
				}
				else if (message->GetType()->Equals(Shared::SnapShot::Messages::Client::typeid))
                {
					Shared::SnapShot::Messages::Client^ msg = (Shared::SnapShot::Messages::Client^)message;

                    if (msg->action->Equals("HEARTBEAT"))
                    {
						Private::Delegate::Objects::Process^ process = (Private::Delegate::Objects::Process^)Private::Delegate::Globals::collection[msg->pid.ToString()];

						if (msg->caption->Equals(System::String::Empty))
                        {
                            process->clients->Remove(msg->hwnd.ToString());
                        }
						else if (process->clients->ContainsKey(msg->hwnd.ToString()))
                        {
							((Private::Delegate::Objects::Client^)process->clients[msg->hwnd.ToString()])->caption = msg->caption;
                        }
                        else
                        {
							Private::Delegate::Objects::Client^ client = gcnew Private::Delegate::Objects::Client(msg->hwnd, msg->caption);
                            process->clients->Add(msg->hwnd.ToString(), client);
                        }
                    }
                }
				else if (message->GetType()->Equals(Shared::SnapShot::Messages::Process::typeid))
                {
					Shared::SnapShot::Messages::Process^ msg = (Shared::SnapShot::Messages::Process^)message;

                    if (msg->action->Equals("HEARTBEAT"))
                    {
						if (msg->name->Equals(System::String::Empty))
                        {
							Private::Delegate::Globals::collection->Remove(msg->pid.ToString());
                        }
						else if (Private::Delegate::Globals::collection->ContainsKey(msg->pid.ToString()))
                        {
							((Private::Delegate::Objects::Process^)Private::Delegate::Globals::collection[msg->pid.ToString()])->name = msg->name;
                        }
                        else
                        {
							Private::Delegate::Objects::Process ^process = gcnew Private::Delegate::Objects::Process(msg->pid, msg->name);
							Private::Delegate::Globals::collection->Add(msg->pid.ToString(), process);
                        }
                    }
                }
				else if (message->GetType()->Equals(Shared::Logic::Messages::Element::typeid))
                {
					Shared::Logic::Messages::Element ^msg = (Shared::Logic::Messages::Element^)message;

                    if (msg->action->Equals("RECOMMEND") || msg->action->Equals("EXECUTE"))
                    {
						Private::Delegate::Objects::Process^ process = (Private::Delegate::Objects::Process^)Private::Delegate::Globals::collection[msg->pid.ToString()];

						if (process->clients->ContainsKey(msg->hwnd.ToString()))
                        {
							Private::Delegate::Objects::Client ^client = (Private::Delegate::Objects::Client^)process->clients[msg->hwnd.ToString()];
							client->decision = (Private::Delegate::Objects::Element^)client->layout[msg->key];
						}
                    }
					else
					{
						Private::Delegate::Objects::Process^ process = (Private::Delegate::Objects::Process^)Private::Delegate::Globals::collection[msg->pid.ToString()];

						if (process->clients->ContainsKey(msg->hwnd.ToString()))
                        {
							//Private::Delegate::Audio::Play::PlaySound("C:\\Ludus\\Audio\\Notify.wav", 0, 0);
                        }
					}
                }
				else if (message->GetType()->Equals(Shared::Console::Messages::Client::typeid))
                {
					Shared::Console::Messages::Client ^msg = (Shared::Console::Messages::Client^)message;

                    if (msg->action->Equals("CLIENT"))
                    {
						Private::Delegate::Objects::Process^ process = (Private::Delegate::Objects::Process^)Private::Delegate::Globals::collection[msg->pid.ToString()];

						if (process->clients->ContainsKey(msg->hwnd.ToString()))
                        {
							((Private::Delegate::Objects::Client^)process->clients[msg->hwnd.ToString()])->allowmonitor = msg->allowmonitor;
							((Private::Delegate::Objects::Client^)process->clients[msg->hwnd.ToString()])->allowplay = msg->allowplay;
                        }
                    }
                }
            }
            catch (Exception^ ex)
            {
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
//                evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error);
            }
			finally
			{
				evtLog->Close();
			}
			return nullptr;
		}
		/// <summary>
		/// This is to insure that when created as a Singleton, the first instance never dies,
		/// regardless of the expired time.
		/// </summary>
		/// <returns></returns>
		virtual System::Object^ InitializeLifetimeService() override
		{
			return nullptr;
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Messenger()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
