#pragma once
#include "Stdafx.h"
#include "Messenger.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;
using namespace System::Runtime::InteropServices;

namespace ServiceDelegate {

	// "ChildWindowFromPoint" Specifies how nFlags is used. Must be one of the following values.
	// CWP_ALL Do not skip any child windows.
	// CWP_SKIPINVISIBLE Skip invisible child windows.
	// CWP_SKIPDISABLED Skip disabled child windows.
	// CWP_SKIPTRANSPARENT Skip transparent child windows.
	[DllImport("user32.dll", SetLastError = true)]
	extern "C" HWND ChildWindowFromPoint(System::IntPtr pHwnd, POINT point, UINT uFlags);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT SendMessage(System::IntPtr hWnd, INT msg, INT wParam, System::IntPtr lParam);

	[DllImport("user32.dll", SetLastError = true)]
	extern "C" HWND WindowFromPoint(POINT point);

	// "ShowWindow" Specifies how the nCmdShow is used. It must be one of the following values:
	// SW_HIDE   Hides this window and passes activation to another window.
	// SW_MINIMIZE   Minimizes the window and activates the top-level window in the system's list.
	// SW_RESTORE   Activates and displays the window. If the window is minimized or maximized, Windows restores it to its original size and position.
	// SW_SHOW   Activates the window and displays it in its current size and position.
	// SW_SHOWMAXIMIZED   Activates the window and displays it as a maximized window.
	// SW_SHOWMINIMIZED   Activates the window and displays it as an icon.
	// SW_SHOWMINNOACTIVE   Displays the window as an icon. The window that is currently active remains active.
	// SW_SHOWNA   Displays the window in its current state. The window that is currently active remains active.
	// SW_SHOWNOACTIVATE   Displays the window in its most recent size and position. The window that is currently active remains active.
	// SW_SHOWNORMAL   Activates and displays the window. If the window is minimized or maximized, Windows restores it to its original size and position.
	[DllImport("user32.dll", SetLastError = true)]
	extern "C" INT ShowWindow(System::IntPtr hWnd, INT nCmdShow);

	/// <summary>
	/// Summary for Collection
	/// </summary>
	public ref class Collection :  public System::ComponentModel::Component
	{
	public:
		Collection(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Collection(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		static void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"Service::Delegate::Collection::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus Delegate");

			try
			{
				evtEntry->Append(Environment::NewLine + "Polling interval is " + config->daemonizepollinginterval);
				evtEntry->Append(Environment::NewLine);
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->collectiondaemonize);

				for( ; ; )
				{
					try
					{
						// http://www.programmersheaven.com/mb/windows/287799/287919/re-how-to-force-window-to-repaint/?S=B20000
						// InvalidateRect(hWnd, NULL, TRUE); (only work within process space of foreign process?)
						// UpdateWindow(hWnd); (only work within process space of foreign process?)
						// WM_PAINT -> message queue
						// SendMessage http://msdn.microsoft.com/en-us/library/ms644950(VS.85).aspx
						// SendNotifyMessage http://msdn.microsoft.com/en-us/library/ms644953(VS.85).aspx
						// PostMessage http://msdn.microsoft.com/en-us/library/ms644944(VS.85).aspx

						// Service based icon/dialog http://www.codeproject.com/KB/system/iconservice.aspx
						// http://msdn.microsoft.com/en-us/library/ms645434(VS.85).aspx
						// http://www.gidforums.com/t-9218.html

						// Pause thread execution for polling interval.
						System::Threading::Thread::Sleep(config->daemonizepollinginterval);
						evtEntry = gcnew StringBuilder();

						// Lock the object for thread safe iteration.
						msclr::lock plock(Private::Delegate::Globals::collection->SyncRoot);
						plock.acquire();

						for each(System::Object ^pkey in Private::Delegate::Globals::collection->Keys)
						{
							// Retrieve client object with layout we're going to examine.
							Private::Delegate::Objects::Process ^process = (Private::Delegate::Objects::Process^)Private::Delegate::Globals::collection[pkey];

							// Lock the object for thread safe iteration.
							msclr::lock glock(process->clients->SyncRoot);
							glock.acquire();

							for each(System::Object ^gkey in process->clients->Keys)
							{
								Private::Delegate::Objects::Client ^client = (Private::Delegate::Objects::Client^)process->clients[gkey];

								if(client->decision != nullptr)
								{
									Shared::Delegate::Messages::Element ^dmsg = gcnew Shared::Delegate::Messages::Element("EXECUTE", process->pid, client->hwnd, client->decision->key);
									dmsg->id = client->decision->id;
									dmsg->chwnd = client->decision->chwnd;
									dmsg->xy = client->decision->xy->ToString();
									dmsg->value = client->decision->value;

									if(client->allowplay)
									{
										Private::Delegate::Mouse::Click::Single(client->hwnd, client->decision->xy);
										ServiceDelegate::Messenger::BroadcastIt->SendMessage((System::Object^)dmsg);
									}
									else if(client->allowmonitor)
									{
										ServiceDelegate::Messenger::BroadcastIt->SendMessage((System::Object^)dmsg);
									}
								}

								client->decision = nullptr;

								Shared::Delegate::Messages::Client ^cmsg = gcnew Shared::Delegate::Messages::Client("HEARTBEAT", process->pid, client->hwnd);
								cmsg->allowmonitor = client->allowmonitor;
								cmsg->allowplay = client->allowplay;
								ServiceDelegate::Messenger::BroadcastIt->SendMessage((System::Object^)cmsg);
							}
							// Release lock on the object.
							glock.release();
						}
						// Release lock on the object.
						plock.release();
					}
					catch(System::Threading::ThreadInterruptedException^ ex)
					{
						// Log the exception.
						evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Warning, log->collectiondaemonize);
					}
					catch(Exception ^ex)
					{
						// Log the exception.
						evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectiondaemonize);
					}
				}
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectiondaemonize);
			}
			finally
			{
				evtLog->Close();
			}
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Collection()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static Shared::XML::Delegate::Objects::Service::Collection^ config = Shared::XML::Delegate::Reader::CollectionConfig();
		static Shared::XML::Delegate::Objects::Service::Log^ log = Shared::XML::Delegate::Reader::LogConfig();
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
