using System;
using System.Collections;
using System.Diagnostics;
using System.Text;

namespace Private.SnapShot
{
    public class Objects
    {
        public class Debugger
        {
            public String reporter;
            public String pid;
            public String hwnd;
            public String chwnd;
            public String api;
            public String key;
            public String xy;
            public String value;
            public String timestamp;

            public Debugger(String Reporter, String Pid, String Hwnd, String Key)
            {
                reporter = Reporter;
                pid = Pid;
                hwnd = Hwnd;
                chwnd = String.Empty;
                api = "N/A";
                key = Key;
                xy = String.Empty;
                value = String.Empty;
                timestamp = String.Empty;
            }
        }

        public class Process
        {
            public UInt32 pid;
            public String name;
            public Hashtable clients;
            public DateTime timestamp;

            public Process(UInt32 Pid, String Name)
            {
                pid = Pid;
                name = Name;
                clients = new Hashtable();
                timestamp = DateTime.Now;
            }
        }

        public class Client
        {
            public IntPtr hwnd;
            public String caption;
            public String type;
            public Hashtable layout;
            public Hashtable lookup;
            public XY xy;
            public Boolean allowmonitor;
            public Boolean allowresize;
            public DateTime timestamp;

            public Client(IntPtr Hwnd, String Caption)
            {
                hwnd = Hwnd;
                caption = Caption;
                type = String.Empty;
                layout = new Hashtable();
                lookup = new Hashtable();
                xy = new XY();
                allowmonitor = false;
                allowresize = false;
                timestamp = DateTime.Now;
            }
        }

        public class Element
        {
            public String reporter;
            public IntPtr chwnd;
            public String id;
            public XY xy;
            public String value;
            public DateTime timestamp;

            public Element(XY XY)
            {
                reporter = String.Empty;
                chwnd = IntPtr.Zero;
                id = String.Empty;
                xy = XY;
                value = String.Empty;
                timestamp = DateTime.Now;
            }
            public Element(XY XY, String Id)
            {
                reporter = String.Empty;
                chwnd = IntPtr.Zero;
                id = Id;
                xy = XY;
                value = String.Empty;
                timestamp = DateTime.Now;
            }
        }

        public class XY
        {
            public UInt32 x1;
            public UInt32 y1;
            public UInt32 x2;
            public UInt32 y2;

            public XY()
            {
                x1 = UInt32.MinValue;
                y1 = UInt32.MinValue;
                x2 = UInt32.MinValue;
                y2 = UInt32.MinValue;
            }

            public XY(UInt32 X1, UInt32 Y1, UInt32 X2, UInt32 Y2)
            {
                x1 = X1;
                y1 = Y1;
                x2 = X2;
                y2 = Y2;
            }

            public XY(String RawXY)
            {
                Char[] delims = { ':' };

                try
                {
                    String[] xy = RawXY.Split(delims);

                    x1 = UInt32.Parse(xy[0]);
                    y1 = UInt32.Parse(xy[1]);
                    x2 = UInt32.Parse(xy[2]);
                    y2 = UInt32.Parse(xy[3]);
                }
                catch (Exception ex)
                {
                    EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                    StringBuilder evtEntry = new StringBuilder("Private::SnapShot::Objects::XY().");
                    evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                    evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                    evtLog.Close();
                }
            }
            public override String ToString()
            {
                return (x1 + ":" + y1 + ":" + x2 + ":" + y2);
            }
        }
    }
}
