using System;
using System.Collections;
using System.Diagnostics;
using System.Text;

namespace Private.Logic.Poker.Probability
{
    public static class PreFlop
    {
        public static void Go(ref Private.Logic.Poker.Objects.State state)
        {
            try
            {
                state.action = "PREFLOP";
                String tablecards = String.Empty;
                String playercards = String.Empty;
                double[] player = new double[9];
                double[] opponent = new double[9];
                ulong pocketmask = 0UL;
                bool montecarlo = true;

                foreach (Object s in state.tablecards.Keys)
                {
                    tablecards += ((Private.Logic.Objects.Element)state.tablecards[s]).value + " ";
                }
                foreach (Object s in state.playercards.Keys)
                {
                    playercards += ((Private.Logic.Objects.Element)state.playercards[s]).value + " ";
                }

                Hand.HandWinOdds(Hand.ParseHand(playercards), Hand.ParseHand(tablecards), out player, out opponent, state.playersactive, 2.0);

                for (int i = 0; i < 9; i++)
                {
/*
                    switch ((Hand.HandTypes)i)
                    {
                        case Hand.HandTypes.HighCard:
                            PlayerHighCard.Text = FormatPercent(player[i], montecarlo);
                            OpponentHighCard.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.TwoOfAKind:
                            PlayerPair.Text = FormatPercent(player[i], montecarlo);
                            OpponentPair.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.TwoPair:
                            PlayerTwoPair.Text = FormatPercent(player[i], montecarlo);
                            OpponentTwoPair.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.ThreeOfAKind:
                            Player3ofaKind.Text = FormatPercent(player[i], montecarlo);
                            Opponent3ofaKind.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.Straight:
                            PlayerStraight.Text = FormatPercent(player[i], montecarlo);
                            OpponentStraight.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.Flush:
                            PlayerFlush.Text = FormatPercent(player[i], montecarlo);
                            OpponentFlush.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.FullHouse:
                            PlayerFullhouse.Text = FormatPercent(player[i], montecarlo);
                            OpponentFullhouse.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.FourOfAKind:
                            Player4ofaKind.Text = FormatPercent(player[i], montecarlo);
                            Opponent4ofaKind.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                        case Hand.HandTypes.StraightFlush:
                            PlayerStraightFlush.Text = FormatPercent(player[i], montecarlo);
                            OpponentStraightFlush.Text = FormatPercent(opponent[i], montecarlo);
                            break;
                    }
*/
                    state.playerchances += player[i] * 100.0;
                    state.enemychances += opponent[i] * 100.0;
                }
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Private::Logic::Poker::Probability::PreFlop::Go()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Probability");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
        }
    }
}
