using System;
using System.Collections.Generic;
using System.Text;

namespace Private.Logic.Poker
{
    public static class Convert
    {
        public static Shared.Logic.Poker.Messages.State ObjectStateToMessageState(ref Private.Logic.Poker.Objects.State s)
        {
            Shared.Logic.Poker.Messages.State state = new Shared.Logic.Poker.Messages.State(s.action, s.pid, s.hwnd);

            foreach (Object key in s.tablebuttons.Keys)
            {
                Private.Logic.Objects.Element e = (Private.Logic.Objects.Element)s.tablebuttons[key];
                if (!e.value.Equals(String.Empty))
                {
                    if (e.amount.Equals(0))
                    {
                        state.tablebuttons.Add(e.value);
                    }
                    else
                    {
                        state.tablebuttons.Add(e.value + " " + e.amount);
                    }
                }
            }
            foreach (Object key in s.tablecards.Keys)
            {
                Private.Logic.Objects.Element e = (Private.Logic.Objects.Element)s.tablecards[key];
                if (!e.value.Equals(String.Empty))
                {
                    state.tablecards.Add(e.value);
                }
            }
            foreach (Object key in s.playercards.Keys)
            {
                Private.Logic.Objects.Element e = (Private.Logic.Objects.Element)s.playercards[key];
                if (!e.value.Equals(String.Empty))
                {
                    state.playercards.Add(e.value);
                }
            }

            state.playersactive = s.playersactive;
            state.playerchances = s.playerchances;

            return state;
        }
    }
}
