using System;
using System.Collections;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;

namespace Private.Delegate
{
    public class Objects
    {
        public class Debugger
        {
            public String pid;
            public String hwnd;
            public String timestamp;

            public Debugger(String Pid, String Hwnd)
            {
                pid = Pid;
                hwnd = Hwnd;
                timestamp = String.Empty;
            }
        }

        public class Process
        {
            public UInt32 pid;
            public String name;
            public Hashtable clients;

            public Process(UInt32 Pid, String Name)
            {
                pid = Pid;
                name = Name;
                clients = new Hashtable();
            }
        }

        public class Client
        {
            public IntPtr hwnd;
            public String caption;
            public Hashtable layout;
            public Boolean allowmonitor;
            public Boolean allowplay;
            public Element decision;

            public Client(IntPtr Hwnd, String Caption)
            {
                hwnd = Hwnd;
                caption = Caption;
                layout = new Hashtable();
                allowmonitor = false;
                allowplay = false;
                decision = new Element();
            }
        }

        public class Element
        {
            public String key;
            public IntPtr chwnd;
            public String id;
            public XY xy;
            public String value;

            public Element()
            {
                key = String.Empty;
                chwnd = IntPtr.Zero;
                id = String.Empty;
                xy = new XY();
                value = String.Empty;
            }

            public Element(String Key)
            {
                key = Key;
                chwnd = IntPtr.Zero;
                id = String.Empty;
                xy = new XY();
                value = String.Empty;
            }
        }

        public class XY
        {
            public UInt32 x1;
            public UInt32 y1;
            public UInt32 x2;
            public UInt32 y2;

            public XY()
            {
                x1 = UInt32.MinValue;
                y1 = UInt32.MinValue;
                x2 = UInt32.MinValue;
                y2 = UInt32.MinValue;
            }

            public XY(UInt32 X1, UInt32 Y1, UInt32 X2, UInt32 Y2)
            {
                x1 = X1;
                y1 = Y1;
                x2 = X2;
                y2 = Y2;
            }

            public XY(String RawXY)
            {
                Char[] delims = { ':' };

                try
                {
                    String[] xy = RawXY.Split(delims);

                    x1 = UInt32.Parse(xy[0]);
                    y1 = UInt32.Parse(xy[1]);
                    x2 = UInt32.Parse(xy[2]);
                    y2 = UInt32.Parse(xy[3]);
                }
                catch (Exception ex)
                {
                    EventLog evtLog = new EventLog("Application", ".", "Ludus Delegate");
                    StringBuilder evtEntry = new StringBuilder("Private::Delegate::Objects::XY().");
                    evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                    evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                    evtLog.Close();
                }
            }
            public override String ToString()
            {
                return (x1 + ":" + y1 + ":" + x2 + ":" + y2);
            }
        }
    }
}
