class SecuredController < ApplicationController
	before_filter :require_login
	require 'digest/sha1'
	
	auto_complete_for :user, :name
	
	def require_login
		if @session[:auth] then return end
		if @params[:uname] and @params[:passwd] then 
			if a = User.find(:first, :conditions => ["name = ? AND passwd = ?",@params[:uname], Digest::SHA1.hexdigest(@params[:passwd])])
				@session[:auth] = a.id
				@session[:level] = a.level
				return true
			end
		end
		
		render :partial => "login", :layout=>"default"
		return false
	end
	
	def logout
		@session[:auth] = false
		@session[:level] = false
		redirect_to "/main"
	end
	
	def index
		@name = User.find(@session[:auth]).name
		render :inline=><<-EOF, :layout=>"defaultSecured"
			<div style="position: absolute;">
				<div style="position: relative; top :40px; left: 110px; width: 400px; text-align:center; font-size:24pt;">
					Welcome <%= @name %>!
				</div>
			</div>
			<%= link_to (image_tag "studentPageSlice_r1_c1.jpg", :size=>"600x"), {:action=>"quizes"} %>
			<%= link_to (image_tag "studentPageSlice_r2_c1.jpg", :size=>"600x"), {:action=>"viewMessages"} %>
			<%= link_to (image_tag "studentPageSlice_r3_c1.jpg", :size=>"600x"), {:action=>"newMessage"} %>
		EOF
	end
	def listUsers
		redirect_to({:action=>"index"}) unless @session[:level]<0
		render :inline=><<-EOF, :layout=>"defaultSecured"
			User Listing:<br>
			<table>
				<tr>
					<td>id</td><td>name</td><td></td>
				</tr>
				<% User.find(:all).each do |t| %>
					<tr>
						<td><%= t.id %></td>
						<td><%= t.name %></td>
						<td><%= link_to "delete", {:action=>"deleteUser", :id=>t.id} %>
							<%= link_to "edit", {:action=>"editUser", :id=>t.id} %>
						</td>
					</tr>
				<% end %>
			</table>
			<%= link_to "create new user...", {:action=>"newUser"} %>
		EOF
	end
	def newUser 
		redirect_to({:action=>"index"}) unless @session[:level]<0
		render :inline=><<-EOF, :layout=>"defaultSecured"
			Create New User:<br>
			<% form_for :newUser, nil, :url=>{:action=>"createNewUser"} do |f| %>
				Name: <%= f.text_field :name %><br>
				Mailing Address: <%= f.text_field :mailing_address %><br>
				Physical Address: <%= f.text_field :physical_address %><br>
				Driving Directions: <%= f.text_field :driving_directions %><br>
				Password: <%= f.password_field :passwd %><br>
				Confirm Password: <%= f.password_field :passwd2 %><br>
				Phone Number: <%= f.text_field :phone %><br>
				Level: <%= f.text_field :level %><br>
				<%= submit_tag "create" %>
			<% end %>
			<%= link_to "back...", {:action=>"listUsers"} %>
		EOF
	end
	def createNewUser
		redirect_to({:action=>"index"}) unless @session[:level]<0 && @params[:newUser]
		redirect_to "/secured/listUsers" unless @params[:newUser][:passwd]==@params[:newUser][:passwd2]
		@params[:newUser][:passwd] = Digest::SHA1.hexdigest(@params[:newUser][:passwd2])
		@params[:newUser].delete("passwd2")
		User.create(@params[:newUser])
		redirect_to({:action=>"listUsers"})
	end
	def editUser 
		redirect_to({:action=>"index"}) unless @session[:level]<0
		@usr = User.find(@params[:id])
		render :inline=><<-EOF, :layout=>"defaultSecured"
			Create New User:<br>
			<% form_for :theUser, nil, :url=>{:action=>"updateUser", :id=>@params[:id]} do |f| %>
				Name: <%= f.text_field :name, :value=>@usr.name %><br>
				Mailing Address: <%= f.text_field :mailing_address, :value=>@usr.mailing_address %><br>
				Physical Address: <%= f.text_field :physical_address, :value=>@usr.physical_address %><br>
				Driving Directions: <%= f.text_field :driving_directions, :value=>@usr.driving_directions %><br>
				Phone Number: <%= f.text_field :phone, :value=>@usr.phone %><br>
				Level: <%= f.text_field :level, :value=>@usr.level %><br>
				<%= submit_tag "update" %>
			<% end %>
			<%= link_to "back...", {:action=>"listUsers"} %>
		EOF
	end
	def updateUser
		redirect_to({:action=>"index"}) unless @session[:level]<0 && @params[:theUser]
		User.update(@params[:id], @params[:theUser])
		redirect_to({:action=>"listUsers"})
	end
	def deleteUser
		redirect_to({:action=>"index"}) unless @session[:level]<0
		User.delete(@params[:id])
		redirect_to({:action=>"listUsers"})
	end
	
	def viewMessages
		@messages = Message.find_by_sql(<<-EOF)
			SELECT 
				messages.id,
				messages.sender_id,
				messages.recipient_id,
				messages.read,
				messages.active,
				messages.subject,
				messages.body,
				users.name as name
			FROM messages, users
			WHERE recipient_id='#{@session[:auth].to_s}'
				AND messages.active='1'
				AND messages.sender_id=users.id
		EOF
		#@messages = Message.find(:all, :conditions=>["recipient_id = ?",@session[:auth]])
		render :inline=><<-EOF, :layout=>"defaultSecured"
			<% if @messages.length==0 then %>
				No Messages
			<% else %>
				<table width="100%">
					<tr>
						<td	width="20%"><strong>From:</strong></td>
						<td><strong>Message:</strong></td>
						<td width="10%"></td>
					</tr>
					<% @messages.each do |t| %>
						<tr>
							<td>
								<%= t.name %>
							</td>
							<td>
								<% if t.read==0 then %>
									<strong>
								<% end %>
								<%= link_to t.subject, {:action=>"viewMessage", :id=>t.id} %>
								<% if t.read==0 then %>
									</strong>
								<% end %>
							</td>
							<td>
								<%= link_to "Delete...", {:action=>"deleteMessage", :id=>t.id} %>
							</td>
						</tr>
					<% end %>
				</table>
			<% end %>
		EOF
	end
	
	def viewMessage 
		@message = Message.find(@params[:id])
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @message.recipient_id==@session[:auth]
		Message.update(@params[:id],{:read=>1})
		render :inline=><<-EOF, :layout=>"defaultSecured"
			<table>
					<tr>
						<td width="50">From:</td>
						<td><%= fromPer=User.find(@message.sender_id).name %></td>
					</tr>
					<tr>
						<td>Subject:</td><td><%= @message.subject %></td>
					</tr>
					<tr>
						<td valign="top">Body:</td><td><%= @message.body %></td>
					</tr>
				</table>
				<%= link_to "Reply...", {:action=>"newMessage", :to=>fromPer} %>
				<%= link_to "Delete...", {:action=>"deleteMessage", :id=>@params[:id]} %>
		EOF
	end
	
	def deleteMessage
		@message = Message.find(@params[:id])
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @message.recipient_id==@session[:auth]
		Message.update(@params[:id],{:active=>0,:read=>1})
		redirect_to "/secured/viewMessages"
	end
	
	def newMessage
		render :inline=><<-EOF, :layout=>"defaultSecured"
			Send New Message:
			<% form_for :message, nil, :url=>{:action=>"sendNewMessage"} do |f| %>
				<table>
					<tr>
						<td width="50">To:</td>
						<td><%= text_field_with_auto_complete :user, :name, {:value=>@params[:to]} %></td>
					</tr>
					<tr>
						<td>Subject:</td><td><%= f.text_field :subject %></td>
					</tr>
					<tr>
						<td valign="top">Body:</td><td><%= f.text_area :body %></td>
					</tr>
				</table>
				<%= submit_tag "send" %>
			<% end %>
		EOF
	end
	
	def sendNewMessage
		redirect_to "/secured" unless @params[:message]
		@params[:message][:recipient_id]=User.find(:first,:conditions=>["name = ?",@params[:user][:name]]).id
		@params[:message][:sender_id]=@session[:auth]
		@params[:message][:read]=0
		@params[:message][:active]=1
		Message.create(@params[:message])
		
		redirect_to "/secured"
	end
	
	def newNews 
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		
		return render :inline=><<-eof, :layout=>"defaultSecured"
			Create New News:<br>
			<% form_for :news, nil, :url=>{:action=>"createNewNews"} do |f| %>
				Start Date: <%= f.text_field :postDate, :value=>Date::today.to_s %><br>
				End Date: <%= f.text_field :expireDate, :value=>(Date::today+7).to_s %><br>
				Header: <%= f.text_field :header %><br>
				Summary: <%= f.text_field :summary %><br>
				Full Body: <br><%= f.text_area :full_body %><br>
				<%= submit_tag "Create" %>
			<% end %>
		eof
	end
	def createNewNews
		redirect_to "/secured" unless @params[:news]
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		
		News.create(@params[:news])
		redirect_to "/secured"
	end

  def quizes
		@qzs = Quiz.find(:all, :conditions=>["level<=? or 0>?",@session[:level],@session[:level]])
		return render :inline=><<-eof, :layout=>"defaultSecured"
			Quizes:
			<table style="width: 100%; padding: 5px; margin: 5px; border: 1px solid black;">
				<tr>
					<td>Name</td><td>Level</td>
				</tr>
				<% @qzs.each do |t| %>
					<tr>
						<td><%= link_to t.name, {:action=>"takeQuiz", :id=>t.id} %></td><td><%= t.level %></td>
					</tr>
				<% end %>
			</table>
		eof
	end

	def listQuizes
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		
		@qzs = Quiz.find(:all)
		return render :inline=><<-eof, :layout=>"defaultSecured"
			Quizes:
			<table style="width: 100%; padding: 5px; margin: 5px; border: 1px solid black;">
				<tr>
					<td>Name</td><td>Level</td><td></td>
				</tr>
				<% @qzs.each do |t| %>
					<tr>
						<td><%= link_to t.name, {:action=>"viewQuiz", :id=>t.id} %></td><td><%= t.level %></td>
						<td><%= link_to "x", {:action=>"deleteQuiz", :id=>t.id} %>
					</tr>
				<% end %>
			</table>
			<%= link_to "create new quiz...", {:action=>"newQuiz"} %>
		eof
	end
	def newQuiz
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0

		return render :inline=><<-eof, :layout=>"defaultSecured"
			Create New Quiz:<br>
			<% form_for :quiz, nil, :url=>{:action=>"createNewQuiz"} do |f| %>
				Name: <%= f.text_field :name %><br>
				Level: <%= f.text_field :level %><br>
				<%= submit_tag "Create" %>
			<% end %>
			
			<%= link_to "back...", {:action=>"listQuizes"} %>
		eof
	end
	def createNewQuiz
		redirect_to "/secured/newQuiz" unless @params[:quiz]
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		
		Quiz.create(@params[:quiz])
		redirect_to "/secured/listQuizes"
	end
	def viewQuiz
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		
		@qz = Quiz.find(@params[:id])
		@questions = QuizQuestion.find(:all, :conditions=>["quiz_id=?",@params[:id]])
		@scores = QuizScore.find_by_sql("select quiz_scores.id as id,name,score from quiz_scores,users where users.id=quiz_scores.user_id and quiz_scores.quiz_id=#{@qz.id};")
		
		return render :inline=><<-eof, :layout=>"defaultSecured"
			View Quiz:<br><br>
			Name: <%= @qz.name %><br>
			Level: <%= @qz.level %><br>
			Questions: <%= @questions.size %><br><br>
			
			Questions: <br>
			<table style="width: 100%; padding: 5px; margin: 5px; border: 1px solid black;">
				<tr>
					<td>Question</td><td>Answer 1</td><td>Answer 2</td><td>Answer 3</td><td>Answer 4</td><td>Correct Answer</td><td></td>
				</tr>
				<% @questions.each do |t| %>
					<tr>
						<td><%= t.question_body %></td>
						<td><%= t.answer_1 %></td>
						<td><%= t.answer_2 %></td>
						<td><%= t.answer_3 %></td>
						<td><%= t.answer_4 %></td>
						<td><%= t.answer %></td>
						<td><%= link_to "x", {:action=>"deleteQuizQuestion", :id=>t.id, :home_id=>@qz.id} %></td>
					</tr>
				<% end %>
			</table><br>
			<%= link_to "create new question...", {:action=>"newQuizQuestion", :home_id=>@params[:id]} %>
			
			<br><br><br>
			Scores: <br>
			<table style="width: 100%; padding: 5px; margin: 5px; border: 1px solid black;">
				<tr>
				  <td>Student Name</td><td>Student Score</td><td></td>
				</tr>
				<% @scores.each do |t| %>
					<tr>
						<td><%= t.name %></td>
						<td><%= t.score %></td>
						<td><%= link_to "x", {:action=>"deleteQuizScore", :id=>t.id, :home_id=>@qz.id} %></td>
					</tr>
				<% end %>
			</table><br>
		eof
	end
	def deleteQuiz
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		return redirect_to "/secured/listQuizes" unless @params[:id]
		
		QuizQuestion.delete_all(["quiz_id=?",@params[:id]])
		Quiz.delete(@params[:id])
		redirect_to "/secured/listQuizes"
	end
	def newQuizQuestion
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
	
		return render :inline=><<-eof, :layout=>"defaultSecured"
			Create New Quiz Question:<br>
			<% form_for :quizQuestion, nil, :url=>{:action=>"createNewQuizQuestion", :home_id=>@params[:home_id]} do |f| %>
				Question: <%= f.text_field :question_body %><br>
				Answer 1: <%= f.text_field :answer_1 %><br>
				Answer 2: <%= f.text_field :answer_2 %><br>
				Answer 3: <%= f.text_field :answer_3 %><br>
				Answer 4: <%= f.text_field :answer_4 %><br>
				Correct Answer(1,2,3 or 4): <%= f.text_field :answer %><br>
				<%= f.hidden_field :quiz_id, :value=>@params[:home_id] %>
				<%= submit_tag "Create" %>
			<% end %>
			
			<%= link_to "back...", {:action=>"viewQuiz", :id=>@params[:home_id]} %>
		eof
	end
	def createNewQuizQuestion
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		return redirect_to "/secured" unless @params[:quizQuestion]
		
		QuizQuestion.create(@params[:quizQuestion])
		redirect_to "/secured/viewQuiz/"+@params[:home_id]
	end
	def deleteQuizQuestion
		return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		return redirect_to "/secured" unless @params[:id]
	
		QuizQuestion.delete(@params[:id])
		redirect_to "/secured/viewQuiz/"+@params[:home_id]
	end
	
	def takeQuiz
    redirect_to "/secured" unless @params[:id]
    @qz = Quiz.find(@params[:id])
    return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @qz.level<=@session[:level] or @session[:level]<0

		@questions = QuizQuestion.find(:all, :conditions=>["quiz_id=?",@params[:id]])
    
    if @done = QuizScore.find(:first, :conditions=>["user_id=? and quiz_id=?",@session[:auth],@params[:id]]) then
      return render :inline=><<-eof, :layout=>"defaultSecured" 
        You have already taken the Quiz (<%= @qz.name%>). You got a <%= @done.score %>/<%= @questions.size %>
      eof
    end
    
		return render :inline=><<-eof, :layout=>"defaultSecured"
		  <% @i = 1 %>
		  		  <span style="font-size: 14pt; font-weight: bold;"><%= @qz.name %></span>
		  <% form_for :questions, nil, :url=>{:action=>"processQuiz", :id=>@params[:id]} do |f| %>
  		  <table>
  		    <% @questions.each do |t| %>
  		      <tr>
  		        <td colspan="4" style="font-weight: bold;"><br>Question <%= @i %></td>
  		      </tr>
  		      <tr>
  		        <td colspan="4"><%= t.question_body %></td>
  		      </tr>
  		      <tr>
  		        <td><input name="question<%= @i.to_s %>" value="1" type="radio"><%= t.answer_1 %></td>
  		        <td><input name="question<%= @i.to_s %>" value="2" type="radio"><%= t.answer_2 %></td>
		        </tr>
            <tr>
  		        <td><input name="question<%= @i.to_s %>" value="3" type="radio"><%= t.answer_3 %></td>
  		        <td><input name="question<%= @i.to_s %>" value="4" type="radio"><%= t.answer_4 %></td>
  		      </tr>
      		  <% @i += 1 %>
  	      <% end %>
  		  </table>
  		  <%= submit_tag "submit" %>
		  <% end %>
		eof
  end
  def processQuiz
    redirect_to "/secured" unless @params[:id]
    @qz = Quiz.find(@params[:id])
    return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @qz.level<=@session[:level] or @session[:level]<0
     
		@questions = QuizQuestion.find(:all, :conditions=>["quiz_id=?",@params[:id]])

    return render :inline=><<-eof, :layout=>"defaultSecured"
		  <% @i = 1 %>
		  <% @score = 0 %>
		  <span style="font-size: 14pt; font-weight: bold;"><%= @qz.name %></span>
		  <table>
		    <% @questions.each do |t| %>
		      <% if t.answer==@params["question"+@i.to_s].to_i then @score += 1 end %>
		      <tr>
		        <td colspan="4" style="font-weight: bold;"><br>Question <%= @i %></td>
		      </tr>
		      <tr>
		        <td colspan="4"><%= t.question_body %></td>
		      </tr>
		      <tr>
		        <td 
  		        <%= if t.answer==1 then 
  		          if @params["question"+@i.to_s]=="1" then 
  		            "style= 'background-color: green;'" 
  		          else
  		            "style= 'border: 1px solid green'"
  		          end 
		          else 
  		          if @params["question"+@i.to_s]=="1" then
  		            "style= 'background-color: red;'" 
		            end
  		        end %>><%= t.answer_1 %></td>
		        <td 
    		        <%= if t.answer==2 then 
    		          if @params["question"+@i.to_s]=="2" then 
    		            "style= 'background-color: green;'" 
    		          else
    		            "style= 'border: 1px solid green;'"
    		          end
    		        else 
    		          if @params["question"+@i.to_s]=="2" then
    		            "style= 'background-color: red;'" 
  		            end
    		        end %>><%= t.answer_2 %></td>
          </tr>
          <tr>
		        <td 
  		        <%= if t.answer==3 then 
  		          if @params["question"+@i.to_s]=="3" then 
  		            "style= 'background-color: green;'" 
  		          else
  		            "style= 'border: 1px solid green;'"  		        
  		          end 
  		        else 
  		          if @params["question"+@i.to_s]=="3" then
  		            "style= 'background-color: red;'" 
		            end
  		        end %>><%= t.answer_3 %></td>
		        <td 
    		        <%= if t.answer==4 then 
    		          if @params["question"+@i.to_s]=="4" then 
    		            "style= 'background-color: green;'" 
    		          else
    		            "style= 'border: 1px solid green;'"
    		          end 
    		        else 
    		          if @params["question"+@i.to_s]=="4" then
    		            "style= 'background-color: red;'" 
  		            end
    		        end %>><%= t.answer_4 %><%= @params[:"question#{@i.to_s}"] %></td>
		      </tr>
    		  <% @i += 1 %>
	      <% end %>
		  </table><br>
		  <div style="font-size: 14pt; padding: 3px; margin: 3px; border: 1px solid black; background-color: #449988; color: black;">
		    Score: <%= @score %> / <%= @questions.size %>
		  </div>
		  <% QuizScore.create({:quiz_id=>@params[:id],:user_id=>@session[:auth],:score=>@score}) %>
		eof
  end
  def deleteQuizScore
    return render :inline=>"you sneakly little rascal", :layout=>"defaultSecured" unless @session[:level]<0
		return redirect_to "/secured" unless @params[:id]
		
		QuizScore.delete(@params[:id])
		redirect_to "/secured/viewQuiz/"+@params[:home_id]
  end
end