using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Summary description for ForageDAL
/// </summary>
public class ForageDAL
{
    public static DataSet forageData = new DataSet();
    public static int oldStandID = -5;

    public static DataSet GetAllForage(int Location_ID, int Stand_ID)
    {
        if (oldStandID == Stand_ID)
            return forageData;

        if (forageData.Tables.Count > 0)
            if (forageData.Tables[0].Rows.Count > 0)
                forageData.Tables[0].Rows.Clear();

        // The using statement puts a scope on the connection so the object is cleaned up by GC quickly
        using (SqlConnection sqlConn = new SqlConnection(ConfigurationManager.ConnectionStrings["MooseDB"].ConnectionString))
        {
            //SqlDataAdapter adapter = new SqlDataAdapter("SELECT * FROM PLANT ORDER BY FORAGE ASC", sqlConn);
            SqlDataAdapter adapter = new SqlDataAdapter("SELECT WP_ID as ID, Forage, WA, WB,WC, WD, DDMA, DDMB, DPA, DPB, NDFA, NDFB, MTB FROM WHOLEPLANT, PLANT WHERE S_ID =" + Stand_ID +" and WHOLEPLANT.P_ID = PLANT.ID ORDER BY FORAGE ASC", sqlConn);
            adapter.Fill(forageData);

            oldStandID = Stand_ID;

            return forageData;
        }

        
    }
    public static DataSet GetAllLocations()
    {
        DataSet locationData = new DataSet();
        using (SqlConnection sqlConn = new SqlConnection(ConfigurationManager.ConnectionStrings["MooseDB"].ConnectionString))
        {
            SqlDataAdapter adapter = new SqlDataAdapter("SELECT * FROM LOCATION ORDER BY LOCATION ASC", sqlConn);
            adapter.Fill(locationData);
            return locationData;
        }
    }
    public static DataSet GetAllStands(int L_ID)
    {
        DataSet standData = new DataSet();
        using (SqlConnection sqlConn = new SqlConnection(ConfigurationManager.ConnectionStrings["MooseDB"].ConnectionString))
        {
            SqlDataAdapter adapter = new SqlDataAdapter("SELECT * FROM STAND WHERE L_ID =" + L_ID + "ORDER BY STAND ASC", sqlConn);
            adapter.Fill(standData);
            return standData;
        }

    }
    public static DataSet GetStemDensities(int WholePlant_ID)
    {
        DataSet stemData = new DataSet();
        using (SqlConnection sqlConn = new SqlConnection(ConfigurationManager.ConnectionStrings["MooseDB"].ConnectionString))
        {
            SqlDataAdapter adapter = new SqlDataAdapter("SELECT STEMDENSITY.* FROM STEMDENSITY, WHOLEPLANT WHERE WP_ID =" + WholePlant_ID +
                                                        "AND WHOLEPLANT.SD_ID = STEMDENSITY.SD_ID", sqlConn);
            adapter.Fill(stemData);
            return stemData;
        }
    }

    public static void UpdateForage(Plant updatedPlant/*string ID, string Forage, float WA, float WB, float WC, float WD, float DDMA, float DDMB, float DPA, float DPB, float NDFA, float NDFB*/)
    {
        foreach (DataRow row in forageData.Tables[0].Rows)
        {
            if (row["ID"].ToString() == updatedPlant.ID)
            {
                row["WA"] = Math.Round(updatedPlant.WA,4);
                row["WB"] = Math.Round(updatedPlant.WB,4);
                row["WC"] = Math.Round(updatedPlant.WC,4);
                row["WD"] = Math.Round(updatedPlant.WD,4);
                row["DDMA"] = Math.Round(updatedPlant.DDMA,4);
                row["DDMB"] = Math.Round(updatedPlant.DDMB,4);
                row["DPA"] = Math.Round(updatedPlant.DPA,4);
                row["DPB"] = Math.Round(updatedPlant.DPB,4);
                row["NDFA"] = Math.Round(updatedPlant.NDFA,4);
                row["NDFB"] = Math.Round(updatedPlant.NDFB,4);
                row["MTB"] = Math.Round(updatedPlant.MTB, 2);
            }
        }
    }
}
