/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import finance.Account;
import finance.AccountEntry;
import finance.Amount;
import finance.BalanceType;
import finance.Journal;
import finance.JournalEntry;
import gui.ActionHandler;
import gui.Constants;
import gui.Main;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class JournalEntryDialog
extends JDialog {
    private static final JournalEntryDialog instance = new JournalEntryDialog();
    private static final int ACCOUNT_COL = 0;
    private static final int AMOUNT_COL = 1;
    private static final int COLUMN_COUNT = 2;
    private JTextField textDate = new JTextField();
    private JTextField textDescription = new JTextField();
    private JComboBox comboBox = new JComboBox();
    private LinkedList<AccountEntry> debits = new LinkedList();
    private LinkedList<AccountEntry> credits = new LinkedList();
    private Date validDate = null;
    private String validDescription = null;
    private LinkedList<AccountEntry> validEntries = new LinkedList();
    private boolean cancelled = true;

    private JournalEntryDialog() {
        super((Frame)Main.instance, true);
        this.setSize(600, 300);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)new JLabel("Date"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.textDate, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel("Description"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.textDescription, gridBagConstraints);
        this.add((Component)new JLabel("Debits"), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        JTable jTable = new JTable(new JournalEntryTableModel(this.debits, BalanceType.DEBIT));
        jTable.setSelectionMode(0);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getColumnModel().getColumn(0).setCellRenderer(new CellRenderer(BalanceType.DEBIT));
        jTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.comboBox));
        jTable.getColumnModel().getColumn(1).setCellRenderer(new CellRenderer(BalanceType.DEBIT));
        jTable.getColumnModel().getColumn(1).setCellEditor(new AmountCellEditor());
        jTable.getColumnModel().getColumn(1).setResizable(false);
        this.setColumnWidths(jTable);
        this.add((Component)new JScrollPane(jTable), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new JLabel("Credits"), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jTable = new JTable(new JournalEntryTableModel(this.credits, BalanceType.CREDIT));
        jTable.setSelectionMode(0);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getColumnModel().getColumn(0).setCellRenderer(new CellRenderer(BalanceType.CREDIT));
        jTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.comboBox));
        jTable.getColumnModel().getColumn(1).setCellRenderer(new CellRenderer(BalanceType.CREDIT));
        jTable.getColumnModel().getColumn(1).setCellEditor(new AmountCellEditor());
        jTable.getColumnModel().getColumn(1).setResizable(false);
        this.setColumnWidths(jTable);
        this.add((Component)new JScrollPane(jTable), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionHandler(this, "button_OK_Handler"));
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionHandler(this, "button_Cancel_Handler"));
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel, gridBagConstraints);
    }

    private void setColumnWidths(JTable jTable) {
        String string = "$90,000.00";
        int n = 0;
        TableColumn tableColumn = null;
        try {
            Graphics2D graphics2D = this.getGraphicsConfiguration().createCompatibleImage(1, 1).createGraphics();
            n = (int)jTable.getFont().getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
        }
        catch (Exception exception) {
            return;
        }
        n = (int)((double)n * 1.3);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setMinWidth(n);
        tableColumn.setMaxWidth(n);
    }

    private void reset() {
        this.textDate.setText("");
        this.textDescription.setText("");
        this.debits.clear();
        this.credits.clear();
        this.comboBox.removeAllItems();
        for (String string : Main.getDB().getAccountNames()) {
            this.comboBox.addItem(string);
        }
        this.validDate = null;
        this.validDescription = null;
        this.validEntries.clear();
        this.cancelled = true;
    }

    public static void showAdd(Journal journal) {
        instance.mShowAdd(journal);
    }

    public static void showEdit(Journal journal, JournalEntry journalEntry) {
        instance.mShowEdit(journal, journalEntry);
    }

    private void mShowAdd(Journal journal) {
        this.reset();
        this.setTitle("Add Journal Entry");
        this.textDate.setText(Constants.dateLong.format(new Date()));
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        JournalEntry journalEntry = this.constructEntry(journal, null);
        if (journalEntry != null) {
            journal.addOrUpdate(journalEntry);
        }
    }

    private void mShowEdit(Journal journal, JournalEntry journalEntry) {
        this.reset();
        this.setTitle("Edit Journal Entry");
        for (AccountEntry accountEntry : journalEntry.getAmounts()) {
            if (accountEntry.getAmount().getType() == BalanceType.DEBIT) {
                this.debits.add(AccountEntry.copy(accountEntry));
                continue;
            }
            this.credits.add(AccountEntry.copy(accountEntry));
        }
        this.textDate.setText(Constants.dateLong.format(journalEntry.getDate()));
        this.textDescription.setText(journalEntry.getDescription());
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        if ((journalEntry = this.constructEntry(journal, journalEntry)) != null) {
            journal.addOrUpdate(journalEntry);
        }
    }

    private JournalEntry constructEntry(Journal journal, JournalEntry journalEntry) {
        journalEntry = journalEntry == null ? journal.newEntry(this.validDate, this.validDescription) : journal.newEntry(journalEntry, this.validDate, this.validDescription);
        for (AccountEntry accountEntry : this.validEntries) {
            journalEntry.add(accountEntry);
        }
        return journalEntry;
    }

    private boolean validateData() {
        String string;
        block9: {
            string = null;
            try {
                this.validDate = Constants.dateShort.parse(this.textDate.getText().trim());
                this.validDate = Constants.dateLong.parse(this.textDate.getText().trim());
            }
            catch (ParseException parseException) {
                if (this.validDate != null) break block9;
                string = this.appendLine(string, "Invalid date/time format.");
            }
        }
        Amount amount = Amount.ZERO;
        LinkedList<AccountEntry> linkedList = new LinkedList<AccountEntry>();
        LinkedList<Account> linkedList2 = new LinkedList<Account>();
        LinkedList<Account> linkedList3 = new LinkedList<Account>();
        linkedList.addAll(this.debits);
        linkedList.addAll(this.credits);
        for (AccountEntry accountEntry : linkedList) {
            if (Amount.ZERO.getValue().compareTo(accountEntry.getAmount().getValue()) == 0) continue;
            amount = amount.add(accountEntry.getAmount());
            if (!linkedList2.contains(accountEntry.getAccount())) {
                linkedList2.add(accountEntry.getAccount());
                this.validEntries.add(accountEntry);
                continue;
            }
            if (linkedList3.contains(accountEntry.getAccount())) continue;
            linkedList3.add(accountEntry.getAccount());
            string = this.appendLine(string, "Account \"" + accountEntry.getAccountName() + "\" occurs more than once.");
        }
        if (this.validEntries.size() == 0) {
            string = this.appendLine(string, "No valid entries.");
        } else if (Amount.ZERO.getValue().compareTo(amount.getValue()) != 0) {
            string = this.appendLine(string, "Debits must equal credits.");
        }
        this.validDescription = this.textDescription.getText();
        if (this.validDescription == null) {
            this.validDescription = "";
        }
        if (string == null) {
            return true;
        }
        this.validDate = null;
        this.validDescription = null;
        this.validEntries.clear();
        this.errorMessage(string);
        return false;
    }

    private String appendLine(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        return string + "\n" + string2;
    }

    private void errorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Validation Error", 0);
    }

    public void button_OK_Handler(ActionEvent actionEvent) {
        if (!this.validateData()) {
            return;
        }
        this.cancelled = false;
        this.setVisible(false);
    }

    public void button_Cancel_Handler(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private static class AmountCellEditor
    extends DefaultCellEditor {
        JTextField editor = (JTextField)this.getComponent();

        AmountCellEditor() {
            super(new JTextField());
            this.editor.setHorizontalAlignment(4);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null && object instanceof AccountEntry) {
                String string = String.format("%.2f", ((AccountEntry)object).getAmount().getValue());
                return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private static class CellRenderer
    extends JLabel
    implements TableCellRenderer {
        protected static Border selectedBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, SystemColor.textHighlight);
        protected static Border unselectedBorder = BorderFactory.createEmptyBorder(1, 0, 1, 0);
        protected BalanceType type = null;

        public CellRenderer(BalanceType balanceType) {
            this.setOpaque(true);
            this.type = balanceType;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBorder(selectedBorder);
            } else {
                this.setBorder(unselectedBorder);
            }
            this.setBackground(n % 2 == 0 ? Constants.bgRowEven : Constants.bgRowOdd);
            this.setFont(jTable.getFont());
            if (object == null) {
                this.setText("");
            } else if (n2 == 0) {
                this.setHorizontalAlignment(2);
                this.setText(object.toString());
            } else if (object instanceof AccountEntry) {
                AccountEntry accountEntry = (AccountEntry)object;
                this.setHorizontalAlignment(4);
                this.setText(String.format("%.2f", accountEntry.getAmount().getValue()));
                this.setBackground(accountEntry.getBalanceType() == this.type ? Constants.bgBalanceNormal : Constants.bgBalanceAbnormal);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JournalEntryTableModel
    extends AbstractTableModel {
        LinkedList<AccountEntry> entries = null;
        BalanceType type = null;

        JournalEntryTableModel(LinkedList<AccountEntry> linkedList, BalanceType balanceType) {
            this.entries = linkedList;
            this.type = balanceType;
        }

        @Override
        public int getRowCount() {
            return this.entries.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.entries.size()) {
                if (n2 == 0) {
                    return this.entries.get(n).getAccountName();
                }
                return this.entries.get(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Account account = null;
            account = n2 == 0 ? Main.getDB().getAccountByName((String)object) : Main.getDB().getAccountByName((String)this.getValueAt(n, 0));
            if (account == null) {
                return;
            }
            Amount amount = null;
            if (n2 == 1) {
                try {
                    amount = new Amount((String)object, this.type);
                }
                catch (Exception exception) {}
            } else {
                try {
                    amount = ((AccountEntry)this.getValueAt(n, 1)).getAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (amount == null) {
                amount = new Amount("0", this.type);
            }
            AccountEntry accountEntry = new AccountEntry(account, amount);
            if (n == this.entries.size()) {
                this.entries.add(accountEntry);
            } else {
                this.entries.set(n, accountEntry);
            }
            if (n2 == 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Account";
                }
                case 1: {
                    return "Amount";
                }
            }
            return super.getColumnName(n);
        }
    }
}

