/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import finance.Account;
import finance.AccountType;
import finance.Amount;
import finance.BalanceType;
import gui.ActionHandler;
import gui.Constants;
import gui.Main;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class AccountDialog
extends JDialog {
    private static final AccountDialog instance = new AccountDialog();
    private JTextField textName = new JTextField();
    private JTextField textNumber = new JTextField();
    private JTextField textDate = new JTextField();
    private JTextField textBalance = new JTextField();
    private JTextArea textComments = new JTextArea();
    private JComboBox comboType = new JComboBox();
    private String validName = null;
    private String validNumber = null;
    private AccountType validType = null;
    private Date validDate = null;
    private Amount validBalance = null;
    private String validComments = null;
    private Account editAccount = null;
    private boolean cancelled = true;

    public static void showAdd() {
        instance.mShowAdd(Main.getDB().getAccountType("Asset"));
    }

    public static void showAdd(AccountType accountType) {
        instance.mShowAdd(accountType);
    }

    public static void showEdit(Account account) {
        instance.mShowEdit(account);
    }

    private AccountDialog() {
        super((Frame)Main.instance, true);
        this.setSize(600, 300);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)new JLabel("Number:"), gridBagConstraints);
        gridBagConstraints.weightx = 2.0;
        this.add((Component)this.textNumber, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)new JLabel("Type:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.comboType, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)new JLabel("Name:"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.textName, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel("Reference Date:"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.textDate, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel("Reference Balance:"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.textBalance.setHorizontalAlignment(4);
        this.add((Component)this.textBalance, gridBagConstraints);
        this.add((Component)new JLabel("Comments:"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.textComments), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionHandler(this, "button_OK_Handler"));
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionHandler(this, "button_Cancel_Handler"));
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel, gridBagConstraints);
    }

    private void reset() {
        this.textName.setText("");
        this.textNumber.setText("");
        this.textDate.setText("");
        this.textBalance.setText("");
        this.textComments.setText("");
        this.comboType.removeAllItems();
        for (AccountType accountType : Main.getDB().getAccountTypes()) {
            this.comboType.addItem(accountType.getName());
        }
        this.validName = null;
        this.validNumber = null;
        this.validType = null;
        this.validDate = null;
        this.validBalance = null;
        this.validComments = null;
        this.editAccount = null;
        this.cancelled = true;
    }

    private void mShowAdd(AccountType accountType) {
        this.reset();
        this.setTitle("Add Account");
        this.textDate.setText(Constants.dateLong.format(new Date()));
        this.textBalance.setText("0.00");
        for (int i = 0; i < this.comboType.getItemCount(); ++i) {
            if (!this.comboType.getItemAt(i).equals(accountType.getName())) continue;
            this.comboType.setSelectedIndex(i);
            break;
        }
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        Account account = new Account(this.validName, this.validNumber, this.validType, this.validDate, this.validBalance, this.validComments);
        Main.getDB().addAccount(account);
    }

    private void mShowEdit(Account account) {
        this.reset();
        this.setTitle("Edit Account");
        this.editAccount = account;
        this.textNumber.setText(account.getNumber());
        for (int i = 0; i < this.comboType.getItemCount(); ++i) {
            if (!this.comboType.getItemAt(i).equals(account.getType().getName())) continue;
            this.comboType.setSelectedIndex(i);
            break;
        }
        this.textName.setText(account.getName());
        this.textDate.setText(Constants.dateLong.format(account.getReferenceDate()));
        String string = String.format("%.2f", account.getReferenceBalance().getValue());
        if (account.getBalance().getType() != account.getType().getNormalBalance()) {
            string = "-" + string;
        }
        this.textBalance.setText(string);
        this.textComments.setText(account.getComments());
        this.setVisible(true);
        if (this.cancelled) {
            return;
        }
        account.update(this.validName, this.validNumber, this.validType, this.validDate, this.validBalance, this.validComments);
        Main.getDB().addAccount(account);
    }

    private boolean validateData() {
        String string;
        block12: {
            Account account = null;
            string = null;
            this.validName = this.textName.getText().trim();
            account = Main.getDB().getAccountByName(this.validName);
            if (account != null && account != this.editAccount) {
                string = this.appendLine(string, "Account name already in use.");
            } else if ("".equals(this.validName)) {
                string = this.appendLine(string, "Account name must be specified.");
            }
            this.validNumber = this.textNumber.getText().trim();
            account = Main.getDB().getAccountByNumber(this.validNumber);
            if (account != null && account != this.editAccount) {
                string = this.appendLine(string, "Account number already in use.");
            }
            this.validType = Main.getDB().getAccountType((String)this.comboType.getSelectedItem());
            if (this.validType == null) {
                string = this.appendLine(string, "Invalid account type.");
            }
            try {
                this.validDate = Constants.dateShort.parse(this.textDate.getText().trim());
                this.validDate = Constants.dateLong.parse(this.textDate.getText().trim());
            }
            catch (ParseException parseException) {
                if (this.validDate != null) break block12;
                string = this.appendLine(string, "Invalid date/time format.");
            }
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(this.textBalance.getText());
            bigDecimal = bigDecimal.setScale(2);
            BalanceType balanceType = this.validType.getNormalBalance();
            if (bigDecimal.signum() == -1) {
                bigDecimal = bigDecimal.negate();
                balanceType = balanceType == BalanceType.DEBIT ? BalanceType.CREDIT : BalanceType.DEBIT;
            }
            this.validBalance = new Amount(bigDecimal, balanceType);
        }
        catch (Exception exception) {
            string = this.appendLine(string, "Invalid amount format.");
        }
        this.validComments = this.textComments.getText();
        if (this.validComments == null) {
            this.validComments = "";
        }
        if (string == null) {
            return true;
        }
        this.validName = null;
        this.validNumber = null;
        this.validType = null;
        this.validDate = null;
        this.validBalance = null;
        this.validComments = null;
        this.errorMessage(string);
        return false;
    }

    private String appendLine(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        return string + "\n" + string2;
    }

    private void errorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Validation Error", 0);
    }

    public void button_OK_Handler(ActionEvent actionEvent) {
        if (!this.validateData()) {
            return;
        }
        this.cancelled = false;
        this.setVisible(false);
    }

    public void button_Cancel_Handler(ActionEvent actionEvent) {
        this.setVisible(false);
    }
}

