/*
 * Decompiled with CFR 0.152.
 */
package gui;

import finance.Account;
import finance.FinancialDatabase;
import finance.Journal;
import finance.Ledger;
import gui.AccountComponent;
import gui.ActionHandler;
import gui.BasicFileFilter;
import gui.JournalComponent;
import gui.LedgerComponent;
import gui.dialog.AboutDialog;
import gui.dialog.HelpDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import utility.Status;

public final class Main
extends JFrame {
    public static final Main instance;
    private final File propertiesFile = new File(this.propertiesFilePath());
    private final Properties properties = new Properties();
    private final MenuHandler menuHandler = new MenuHandler();
    private final JFileChooser fileChooser = new JFileChooser();
    private JPanel panelTopLeft = new JPanel(new FlowLayout(0));
    private JPanel panelTopRight = new JPanel(new FlowLayout(2));
    private JPanel panelCenter = new JPanel(new GridLayout(1, 1));
    private JLabel labelMain = new JLabel("", 2);
    private Map<Object, JComponent> componentMap = new Hashtable<Object, JComponent>();
    private FinancialDatabase DB = null;

    public static void main(String[] stringArray) {
        File file;
        String string = Main.instance.properties.getProperty("file.last");
        if (string != null && (file = new File(string)).exists()) {
            instance.openDatabase(file);
        }
        SwingUtilities.invokeLater(new Visiblizer());
    }

    public static FinancialDatabase getDB() {
        return Main.instance.DB;
    }

    private Main() {
        super("Double Entry Accounting Program - Personal Edition");
        this.setDefaultCloseOperation(2);
        this.setSize(500, 400);
        this.setIconImage(new ImageIcon(Main.class.getResource("icon.png")).getImage());
        this.constructMenu();
        this.constructFrame();
        this.constructFileChooser();
        this.loadProperties();
    }

    private void constructMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenu.setMnemonic(78);
        jMenuItem.addActionListener(new ActionHandler(this.menuHandler, "menuFile_New_Handler"));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Open");
        jMenu.setMnemonic(79);
        jMenuItem2.addActionListener(new ActionHandler(this.menuHandler, "menuFile_Open_Handler"));
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Save As");
        jMenu.setMnemonic(65);
        jMenuItem3.addActionListener(new ActionHandler(this.menuHandler, "menuFile_SaveAs_Handler"));
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Exit");
        jMenu.setMnemonic(88);
        jMenuItem4.addActionListener(new ActionHandler(this.menuHandler, "menuFile_Exit_Handler"));
        jMenu.add(jMenuItem4);
        JMenu jMenu2 = new JMenu("View");
        jMenu.setMnemonic(86);
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem5 = new JMenuItem("General Ledger");
        jMenu.setMnemonic(76);
        jMenuItem5.addActionListener(new ActionHandler(this.menuHandler, "menuView_Ledger_Handler"));
        jMenu2.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("General Journal");
        jMenu.setMnemonic(74);
        jMenuItem6.addActionListener(new ActionHandler(this.menuHandler, "menuView_Journal_Handler"));
        jMenu2.add(jMenuItem6);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic(72);
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem7 = new JMenuItem("Index");
        jMenu.setMnemonic(73);
        jMenuItem7.addActionListener(new ActionHandler(this.menuHandler, "menuHelp_Index_Handler"));
        jMenu3.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Contents");
        jMenu.setMnemonic(67);
        jMenuItem8.addActionListener(new ActionHandler(this.menuHandler, "menuHelp_Contents_Handler"));
        jMenu3.add(jMenuItem8);
        jMenu3.addSeparator();
        JMenuItem jMenuItem9 = new JMenuItem("About");
        jMenu.setMnemonic(65);
        jMenuItem9.addActionListener(new ActionHandler(this.menuHandler, "menuHelp_About_Handler"));
        jMenu3.add(jMenuItem9);
    }

    private void constructFrame() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panelTopLeft, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.panelTopRight, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.panelCenter, gridBagConstraints);
        this.labelMain.setFont(this.labelMain.getFont().deriveFont(this.labelMain.getFont().getSize2D() + 2.0f));
        this.panelTopLeft.add(this.labelMain);
    }

    private void constructFileChooser() {
        this.fileChooser.addChoosableFileFilter(new BasicFileFilter("Financial Database Files", ".fdb"));
    }

    private void openDatabase(File file) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.DB = new FinancialDatabase(file);
        this.DB.loadFile();
        try {
            this.properties.setProperty("file.last", file.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = this.properties.getProperty("account_types");
        if (string != null) {
            this.DB.parseAccountTypes(string);
        }
        this.componentMap.clear();
        this.displayLedger(this.DB.getLedger());
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void displayLedger(Ledger ledger) {
        if (ledger == null) {
            return;
        }
        JComponent jComponent = this.componentMap.get(ledger);
        if (jComponent == null) {
            jComponent = new LedgerComponent(ledger);
            this.componentMap.put(ledger, jComponent);
        }
        this.displayNothing();
        this.panelCenter.add(jComponent);
        this.labelMain.setText("Ledger:  General Ledger");
        this.repaint();
    }

    public void displayJournal(Journal journal) {
        if (journal == null) {
            return;
        }
        JComponent jComponent = this.componentMap.get(journal);
        if (jComponent == null) {
            jComponent = new JournalComponent(journal);
            this.componentMap.put(journal, jComponent);
        }
        this.displayNothing();
        this.panelCenter.add(jComponent);
        this.labelMain.setText("Journal:  " + journal.getName());
        this.repaint();
    }

    public void displayAccount(Account account) {
        if (account == null) {
            return;
        }
        JComponent jComponent = this.componentMap.get(account);
        if (jComponent == null) {
            jComponent = new AccountComponent(account);
            this.componentMap.put(account, jComponent);
        }
        this.displayNothing();
        this.panelCenter.add(jComponent);
        this.labelMain.setText("Account:  " + account.getName());
        this.repaint();
    }

    private void displayNothing() {
        this.panelCenter.removeAll();
        this.labelMain.setText("");
    }

    private void errorMessage(String string, String string2) {
        if (string2 == null) {
            string2 = "Error";
        }
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    private void loadProperties() {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(this.propertiesFile));
            this.properties.load(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveProperties() {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(this.propertiesFile));
            this.properties.store(outputStream, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String propertiesFilePath() {
        File file = new File(System.getProperty("user.home"), ".deap");
        if (!file.exists()) {
            file.mkdir();
        }
        file = new File(file, "properties.txt");
        try {
            return file.getCanonicalPath();
        }
        catch (Exception exception) {
            return System.getProperty("user.home") + File.separator + ".deap" + File.separator + "properties";
        }
    }

    public void dispose() {
        super.dispose();
        this.saveProperties();
    }

    static {
        JFrame.setDefaultLookAndFeelDecorated(true);
        instance = new Main();
    }

    private class MenuHandler {
        MenuHandler() {
        }

        public void menuFile_New_Handler(ActionEvent actionEvent) {
            Main.this.fileChooser.setDialogTitle("Create");
            if (Main.this.fileChooser.showDialog(Main.this, "Create") != 0) {
                return;
            }
            File file = Main.this.fileChooser.getSelectedFile();
            if (file.exists()) {
                Main.this.errorMessage("File already exists.", "File Error");
                return;
            }
            if (!file.getPath().endsWith(".fdb")) {
                file = new File(file.getPath() + ".fdb");
            }
            if (file.exists()) {
                Main.this.errorMessage("File already exists.", "File Error");
                return;
            }
            if (FinancialDatabase.createNew(file) != Status.OK) {
                return;
            }
            Main.this.openDatabase(file);
        }

        public void menuFile_Open_Handler(ActionEvent actionEvent) {
            if (Main.this.fileChooser.showOpenDialog(Main.this) != 0) {
                return;
            }
            File file = Main.this.fileChooser.getSelectedFile();
            Main.this.openDatabase(file);
        }

        public void menuFile_SaveAs_Handler(ActionEvent actionEvent) {
            if (Main.this.fileChooser.showSaveDialog(Main.this) != 0) {
                return;
            }
            File file = Main.this.fileChooser.getSelectedFile();
            if (file.exists()) {
                Main.this.errorMessage("File already exists.", "File Error");
                return;
            }
            if (!file.getPath().endsWith(".fdb")) {
                file = new File(file.getPath() + ".fdb");
            }
            if (file.exists()) {
                Main.this.errorMessage("File already exists.", "File Error");
                return;
            }
            if (Main.this.DB.saveFileAs(file) != Status.OK) {
                Main.this.errorMessage("Error saving file.", "File Error");
                return;
            }
            try {
                Main.this.properties.setProperty("file.last", file.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void menuFile_Exit_Handler(ActionEvent actionEvent) {
            Main.this.setVisible(false);
            Main.this.dispose();
        }

        public void menuView_Ledger_Handler(ActionEvent actionEvent) {
            Main.this.displayLedger(Main.this.DB.getLedger());
        }

        public void menuView_Journal_Handler(ActionEvent actionEvent) {
            Main.this.displayJournal(Main.this.DB.getJournal());
        }

        public void menuHelp_Index_Handler(ActionEvent actionEvent) {
            HelpDialog.showIndex();
        }

        public void menuHelp_Contents_Handler(ActionEvent actionEvent) {
            HelpDialog.showContents();
        }

        public void menuHelp_About_Handler(ActionEvent actionEvent) {
            AboutDialog.showDialog();
        }
    }

    private static class Visiblizer
    implements Runnable {
        Visiblizer() {
        }

        public void run() {
            instance.setVisible(true);
        }
    }
}

