/*
 * Decompiled with CFR 0.152.
 */
package gui;

import finance.AccountEntry;
import finance.BalanceType;
import finance.Journal;
import finance.JournalEntry;
import gui.ActionHandler;
import gui.Constants;
import gui.Main;
import gui.dialog.JournalEntryDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JournalComponent
extends JPanel {
    JTable table = null;
    TableModel model = null;
    Journal journal = null;
    private JButton buttonAdd = new JButton("Add Entry");
    private JButton buttonEdit = new JButton("Edit Entry");
    private JButton buttonDelete = new JButton("Delete Entry");
    private ButtonHandler buttonHandler = new ButtonHandler();

    public JournalComponent(Journal journal) {
        this.journal = journal;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.model = journal.getDataModel();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addMouseListener(new DblClickHandler(this));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new CellRenderer());
            tableColumn.setResizable(false);
        }
        this.setColumnWidths();
        this.setRowHeights();
        this.add((Component)new JScrollPane(this.table), gridBagConstraints);
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        this.buttonAdd.addActionListener(new ActionHandler(this.buttonHandler, "button_AddEntry_Handler"));
        this.buttonAdd.setMnemonic(65);
        this.add((Component)this.buttonAdd, gridBagConstraints);
        this.buttonEdit.addActionListener(new ActionHandler(this.buttonHandler, "button_EditEntry_Handler"));
        this.buttonEdit.setMnemonic(69);
        this.buttonEdit.setEnabled(false);
        this.add((Component)this.buttonEdit, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.buttonDelete.addActionListener(new ActionHandler(this.buttonHandler, "button_DeleteEntry_Handler"));
        this.buttonDelete.setMnemonic(68);
        this.buttonDelete.setEnabled(false);
        this.add((Component)this.buttonDelete, gridBagConstraints);
    }

    private void setColumnWidths() {
        Date date = null;
        String string = "26 Nov 2005";
        try {
            date = Constants.dateShort.parse("26 Nov 2005");
            string = Constants.dateShort.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "$90,000.00";
        int n = 0;
        int n2 = 0;
        TableColumn tableColumn = null;
        try {
            Graphics2D graphics2D = Main.instance.getGraphicsConfiguration().createCompatibleImage(1, 1).createGraphics();
            n = (int)this.table.getFont().getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
            n2 = (int)this.table.getFont().getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth();
        }
        catch (Exception exception) {
            return;
        }
        n = (int)((double)n * 1.3);
        n2 = (int)((double)n2 * 1.3);
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(n);
        tableColumn.setMaxWidth(n);
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    private void setRowHeights() {
        CellRenderer cellRenderer = new CellRenderer();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            cellRenderer.getTableCellRendererComponent(this.table, this.model.getValueAt(i, 0), false, false, i, 0);
        }
    }

    private class ButtonHandler {
        private ButtonHandler() {
        }

        public void button_AddEntry_Handler(ActionEvent actionEvent) {
            JournalEntryDialog.showAdd(JournalComponent.this.journal);
        }

        public void button_EditEntry_Handler(ActionEvent actionEvent) {
            int n = JournalComponent.this.table.getSelectedRow();
            if (n == -1) {
                return;
            }
            Object object = JournalComponent.this.model.getValueAt(n, 0);
            if (object instanceof JournalEntry) {
                JournalEntryDialog.showEdit(JournalComponent.this.journal, (JournalEntry)object);
            }
        }

        public void button_DeleteEntry_Handler(ActionEvent actionEvent) {
            Object object;
            int n = JournalComponent.this.table.getSelectedRow();
            String string = "Are you sure you want to delete the selected entry?";
            if (n == -1) {
                return;
            }
            if (JOptionPane.showConfirmDialog(Main.instance, string, "Confirm Delete", 0, 3) == 0 && (object = JournalComponent.this.model.getValueAt(n, 0)) instanceof JournalEntry) {
                JournalComponent.this.journal.remove((JournalEntry)object);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (listSelectionEvent.getSource() instanceof ListSelectionModel) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    JournalComponent.this.buttonEdit.setEnabled(false);
                    JournalComponent.this.buttonDelete.setEnabled(false);
                } else {
                    JournalComponent.this.buttonEdit.setEnabled(true);
                    JournalComponent.this.buttonDelete.setEnabled(true);
                }
            }
        }
    }

    private static class DblClickHandler
    extends MouseAdapter {
        JournalComponent container;

        DblClickHandler(JournalComponent journalComponent) {
            this.container = journalComponent;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                return;
            }
            this.container.buttonHandler.button_EditEntry_Handler(null);
        }
    }

    private static class CellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static Border innerBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)UIManager.getDefaults().get("Table.gridColor"));
        private static Border selectedBorder = BorderFactory.createMatteBorder(2, 0, 1, 0, SystemColor.textHighlight);
        private static Border panelBorder = BorderFactory.createMatteBorder(2, 0, 1, 0, SystemColor.controlHighlight);
        private GridBagConstraints constraints = new GridBagConstraints();
        private JPanel panel = new JPanel();

        public CellRenderer() {
            this.setOpaque(true);
            this.setLayout(new GridBagLayout());
            this.setBorder(panelBorder);
            this.panel.setOpaque(false);
            this.panel.setLayout(new GridBagLayout());
            this.constraints.gridwidth = 0;
            this.constraints.anchor = 18;
            this.constraints.fill = 1;
            this.constraints.weightx = 1.0;
            this.add((Component)this.panel, this.constraints);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = 4;
            super.setBackground(n % 2 == 0 ? Constants.bgRowEven : Constants.bgRowOdd);
            if (bl) {
                this.setBorder(selectedBorder);
            } else {
                this.setBorder(panelBorder);
            }
            this.setFont(jTable.getFont());
            this.panel.removeAll();
            if (object != null && object instanceof JournalEntry) {
                JournalEntry journalEntry = (JournalEntry)object;
                boolean bl3 = false;
                JLabel jLabel = null;
                for (AccountEntry accountEntry : journalEntry.getAmounts()) {
                    jLabel = this.getLabel(n2, journalEntry, accountEntry);
                    if (n2 == 0 && !bl3) {
                        jLabel.setText(Constants.dateShort.format(journalEntry.getDate()));
                        bl3 = true;
                    }
                    this.panel.add((Component)jLabel, this.constraints);
                    n3 += jLabel.getPreferredSize().height;
                }
                jLabel = this.getLabel(n2, journalEntry, null);
                this.panel.add((Component)jLabel, this.constraints);
                if (jTable.getRowHeight(n) != (n3 += jLabel.getPreferredSize().height)) {
                    jTable.setRowHeight(n, n3);
                }
            }
            return this;
        }

        protected JLabel getLabel(int n, JournalEntry journalEntry, AccountEntry accountEntry) {
            JLabel jLabel = null;
            String string = "";
            switch (n) {
                case 0: {
                    jLabel = new JLabel(" ");
                    break;
                }
                case 1: {
                    if (accountEntry != null) {
                        if (!accountEntry.getDebit().equals("")) {
                            jLabel = new JLabel(" " + accountEntry.getAccountName());
                            break;
                        }
                        if (accountEntry.getCredit().equals("")) break;
                        jLabel = new JLabel("      " + accountEntry.getAccountName());
                        break;
                    }
                    jLabel = new JLabel("   " + journalEntry.getDescription());
                    break;
                }
                case 2: {
                    if (accountEntry != null && !(string = accountEntry.getDebit()).equals("")) {
                        jLabel = new JLabel(string);
                        jLabel.setBackground(accountEntry.getBalanceType() == BalanceType.DEBIT ? Constants.bgBalanceNormal : Constants.bgBalanceAbnormal);
                        jLabel.setOpaque(true);
                        break;
                    }
                    jLabel = new JLabel(" ");
                    break;
                }
                case 3: {
                    if (accountEntry != null && !(string = accountEntry.getCredit()).equals("")) {
                        jLabel = new JLabel(string);
                        jLabel.setBackground(accountEntry.getBalanceType() == BalanceType.CREDIT ? Constants.bgBalanceNormal : Constants.bgBalanceAbnormal);
                        jLabel.setOpaque(true);
                        break;
                    }
                    jLabel = new JLabel(" ");
                    break;
                }
                default: {
                    jLabel = new JLabel(" ");
                }
            }
            if (n == 1 && accountEntry == null) {
                jLabel.setFont(this.getFont().deriveFont(2));
            } else {
                jLabel.setFont(this.getFont());
            }
            if (n == 0 || n == 1) {
                jLabel.setHorizontalAlignment(2);
            } else {
                jLabel.setHorizontalAlignment(4);
            }
            jLabel.setBorder(innerBorder);
            return jLabel;
        }
    }
}

