/*
 * Decompiled with CFR 0.152.
 */
package finance;

import finance.AccountEntry;
import finance.FinancialDatabase;
import finance.JournalEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Journal {
    int id;
    String name;
    TreeSet<JournalEntry> entriesByDate = new TreeSet<JournalEntry>(JournalEntry.COMP_DATE);
    TreeSet<JournalEntry> entriesByID = new TreeSet<JournalEntry>(JournalEntry.COMP_ID);
    long newEntryID = 0L;
    FinancialDatabase DB = null;
    DataModel dataModel = null;

    Journal(FinancialDatabase financialDatabase, int n, String string) {
        this.DB = financialDatabase;
        this.id = n;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public JournalEntry newEntry(Date date, String string) {
        return new JournalEntry(this, this.newEntryID, date, string);
    }

    public JournalEntry newEntry(JournalEntry journalEntry, Date date, String string) {
        return new JournalEntry(this, journalEntry.getID(), date, string);
    }

    public Collection<JournalEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entriesByDate);
    }

    public void addOrUpdate(JournalEntry journalEntry) {
        if (journalEntry == null) {
            System.err.println("Unexpected null entry updating journal.");
            return;
        }
        if (journalEntry.getID() >= this.newEntryID) {
            this.newEntryID = journalEntry.getID() + 1L;
        }
        if (this.entriesByID.contains(journalEntry)) {
            this.update(journalEntry);
        } else {
            this.add(journalEntry);
        }
        this.DB.recordEntry(journalEntry);
    }

    private void add(JournalEntry journalEntry) {
        this.entriesByDate.add(journalEntry);
        this.entriesByID.add(journalEntry);
        journalEntry.isNew = false;
        for (AccountEntry accountEntry : journalEntry.getAmounts()) {
            accountEntry.account.add(accountEntry);
        }
        this.fireAddEvent(this.getIndex(journalEntry));
    }

    private void update(JournalEntry journalEntry) {
        JournalEntry journalEntry2 = null;
        SortedSet<JournalEntry> sortedSet = this.entriesByID.tailSet(journalEntry);
        journalEntry2 = sortedSet.first();
        if (journalEntry2.getID() != journalEntry.getID()) {
            System.err.println("Entry not found updating entry. Expected " + journalEntry.getID() + "  Found " + journalEntry2.getID());
            return;
        }
        this.remove(journalEntry2, false);
        this.add(journalEntry);
    }

    public void remove(JournalEntry journalEntry) {
        this.remove(journalEntry, true);
    }

    void remove(long l) {
        JournalEntry journalEntry = new JournalEntry(this, l, null, null);
        SortedSet<JournalEntry> sortedSet = this.entriesByID.tailSet(journalEntry);
        if ((journalEntry = sortedSet.first()).getID() != l) {
            return;
        }
        this.remove(journalEntry, false);
    }

    private void remove(JournalEntry journalEntry, boolean bl) {
        int n = this.getIndex(journalEntry);
        this.entriesByDate.remove(journalEntry);
        this.entriesByID.remove(journalEntry);
        for (AccountEntry accountEntry : journalEntry.getAmounts()) {
            accountEntry.account.remove(accountEntry);
        }
        this.fireRemoveEvent(n);
        if (bl) {
            this.DB.recordDeletion(journalEntry);
        }
    }

    private int getIndex(JournalEntry journalEntry) {
        SortedSet<JournalEntry> sortedSet = this.entriesByDate.headSet(journalEntry);
        return sortedSet.size();
    }

    public TableModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new DataModel(this);
        }
        return this.dataModel;
    }

    private void fireAddEvent(int n) {
        if (this.dataModel == null) {
            return;
        }
        this.dataModel.updateList();
        this.dataModel.fireTableRowsInserted(n, n);
    }

    private void fireRemoveEvent(int n) {
        if (this.dataModel == null) {
            return;
        }
        this.dataModel.updateList();
        this.dataModel.fireTableRowsDeleted(n, n);
    }

    public static class DataModel
    extends AbstractTableModel {
        public static final int DATE_COL = 0;
        public static final int DESC_COL = 1;
        public static final int DEBIT_COL = 2;
        public static final int CREDIT_COL = 3;
        public static final int COLUMN_COUNT = 4;
        private Journal journal = null;
        private ArrayList<JournalEntry> list = null;

        private DataModel(Journal journal) {
            this.journal = journal;
            this.updateList();
        }

        private void updateList() {
            this.list = new ArrayList<JournalEntry>(this.journal.entriesByDate);
        }

        public int getRowCount() {
            return this.list.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 >= 0 && n2 < 4 && n >= 0 && n < this.getRowCount()) {
                return this.list.get(n);
            }
            return null;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Date";
                }
                case 1: {
                    return "Account Titles and Description";
                }
                case 2: {
                    return "Debit";
                }
                case 3: {
                    return "Credit";
                }
            }
            return super.getColumnName(n);
        }
    }
}

