/*
 * Decompiled with CFR 0.152.
 */
package finance;

import finance.Amount;
import finance.BalanceType;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccountType {
    private static final List<AccountType> list;
    private static int newID;
    private String name;
    private BalanceType normalBalance;
    private int id;

    public static byte[] convertToBytes(AccountType accountType) {
        int n = 5;
        byte[] byArray = accountType.name.getBytes();
        byte[] byArray2 = new byte[4];
        ByteBuffer.wrap(byArray2).putInt(accountType.id);
        byte[] byArray3 = new byte[n += byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, 4);
        if (accountType.normalBalance == BalanceType.DEBIT) {
            byArray3[n - 1] = 1;
        } else if (accountType.normalBalance == BalanceType.CREDIT) {
            byArray3[n - 1] = 2;
        }
        return byArray3;
    }

    public static AccountType convertFromBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - 5];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        int n = ByteBuffer.wrap(byArray, byArray2.length, 4).getInt();
        if (newID <= n) {
            newID = n + 1;
        }
        BalanceType balanceType = null;
        if (byArray[byArray.length - 1] == 1) {
            balanceType = BalanceType.DEBIT;
        } else if (byArray[byArray.length - 1] == 2) {
            balanceType = BalanceType.CREDIT;
        }
        return new AccountType(new String(byArray2), balanceType, n);
    }

    public static List<AccountType> getList() {
        return list;
    }

    private AccountType(String string, BalanceType balanceType, int n) {
        this.name = string;
        this.normalBalance = balanceType;
        this.id = n;
    }

    AccountType(String string, BalanceType balanceType) {
        this(string, balanceType, newID++);
    }

    public String getName() {
        return this.name;
    }

    public BalanceType getNormalBalance() {
        return this.normalBalance;
    }

    public Amount getZero() {
        return this.normalBalance == BalanceType.DEBIT ? Amount.ZERO_DEBIT : Amount.ZERO_CREDIT;
    }

    public int getID() {
        return this.id;
    }

    static {
        newID = 0;
        LinkedList<AccountType> linkedList = new LinkedList<AccountType>();
        linkedList.add(new AccountType("Asset", BalanceType.DEBIT, newID++));
        linkedList.add(new AccountType("Liability", BalanceType.CREDIT, newID++));
        linkedList.add(new AccountType("Expense", BalanceType.DEBIT, newID++));
        linkedList.add(new AccountType("Revenue", BalanceType.CREDIT, newID++));
        list = Collections.unmodifiableList(linkedList);
    }
}

