<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserInfo.ascx.cs" Inherits="UserInfo" %>
<table cellspacing="0" border="0" width="200px" class="UserInfoContent">
    <tr>
        <td class="UserInfoHead" style="font-size: 16pt; width: 185px; font-family: 'Tw Cen MT Condensed', Sans-Serif; height: 21px; background-color: #cc9c78">
        UserInfo</td>
    </tr>
    <asp:LoginView ID="LoginView1" runat="server">
        <AnonymousTemplate>
            <tr>
                <td>
                    <span class="UserInfoText">You are not logged in.</span>
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&raquo;
                        <asp:LoginStatus ID="LogingStatus1" runat='server' CssClass="UserInfoLink" />
                    &nbsp;&laquo;
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&raquo;
                    <asp:HyperLink runat="server" ID="registerLink"
                    NavigateUrl="~/Register.aspx" Text="Register"
                    ToolTip="Go to the registration page"
                    CssClass="UserInfoLink" />
                    &nbsp;&laquo;
                </td>
            </tr>
        </AnonymousTemplate>
        <RoleGroups>
            <asp:RoleGroup Roles="Customers">
                <ContentTemplate>
                    <tr>
                        <td>
                            <asp:LoginName ID="LoginName1" runat="server"
                             FormatString="You are logged in as <b>{0}</b>."
                             CssClass="UserInfoText" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;&raquo;
                            <asp:LoginStatus ID="LoginStatus1" runat="server"
                                CssClass="UserInofLink" />
                                &nbsp;&laquo;
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;&raquo;
                            <asp:HyperLink runat="server" ID="detailsLink"
                                NavigateUrl="~/CustomerDetails.aspx"
                                Text="Edit Details"
                                ToolTip="Edit your personal details"
                                CssClass="UserInfoLink" />
                                &nbsp;&laquo;
                        </td>
                    </tr>
                </ContentTemplate>
            </asp:RoleGroup>
            <asp:RoleGroup Roles="Administrators">
                <ContentTemplate>
                    <tr>
                        <td>
                            <asp:LoginName ID="LoginName2" runat="server" FormatString="You are logged in as <b>{0}</b>." CssClass="UserInfoText" />
                         </td>   
                    </tr>
                    <tr>
                        <td>
                            &nbsp;&raquo;
                                <asp:LoginStatus ID="LoginStatus2" runat="server" CssClass="UserInfoLink" />
                                &nbsp;&laquo;
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;&raquo;
                            <a class="UserInfoLink" href="MenuItemAdmin.aspx">MenuItem Admin</a>
                            &nbsp;&laquo;
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;&raquo;
                            <a class="UserInfoLink" href="ShoppingCartAdmin.aspx">Shopping Cart Admin</a>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;&raquo;
                            <a class="UserInfoLink" href="OrdersAdmin.aspx">Orders Admin</a>
                        </td>
                    </tr>
                </ContentTemplate>
            </asp:RoleGroup>
        </RoleGroups>
    </asp:LoginView>
</table>
