using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserControls_MenuItemsAdmin : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //load the grid only the first time the page is loaded
        if (!Page.IsPostBack)
        {
            BindGrid();
            //get directoryiD from query string
            string directoryId = Request.QueryString["DirectoryID"];
            //get directory's name
            DirectoryDetails dd = MenuAccess.GetDirectoryDetail(directoryId);
            string directoryName = dd.Name;
            //set the controls' properties
            statusLabel.ForeColor = System.Drawing.Color.Red;
            locationLabel.Text = "Displaying MenuItems for Directory<b>" + directoryName + "</b>";
        }
    }

    //populate the gridview with data
    private void BindGrid()
    {
        string directoryId = Request.QueryString["DirectoryID"];
        grid.DataSource = MenuAccess.GetMenuItemsInDirectory(directoryId);

        grid.DataBind();
    }

    //Enter row into edit mode
    protected void grid_RowEditing(object sender, GridViewEditEventArgs e)
    {
        //set the row for which to enable edit mode
        grid.EditIndex = e.NewEditIndex;
        //set status message
        statusLabel.Text = "Editing Row # " + e.NewEditIndex.ToString();

        BindGrid();
    }
    protected void grid_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        //cancel edit mode
        grid.EditIndex = -1;
        //set status message
        statusLabel.Text = "Editing canceled";
        //Reload the grid
        BindGrid();
    }
    protected void grid_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        string id = grid.DataKeys[e.RowIndex].Value.ToString();
        string name = ((TextBox)grid.Rows[e.RowIndex].Cells[0].Controls[0]).Text;
        string description = ((TextBox)grid.Rows[e.RowIndex].FindControl("descriptionTextBox")).Text;
        bool success = MenuAccess.UpdateMenuItems(id, name, description);
        grid.EditIndex = -1;
        statusLabel.Text = success ? "Update successful" : "Update failed";

        BindGrid();

    }
    protected void grid_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = grid.DataKeys[e.RowIndex].Value.ToString();
        bool success = MenuAccess.DeleteMenuItems(id);
        grid.EditIndex = -1;
        statusLabel.Text = success ? "Delete Successful" : "Delete Failed";

        BindGrid();
    }

    protected void goBackLink_Click(object sender, EventArgs e)
    {
        Response.Redirect(Request.ApplicationPath + "/MenuItemAdmin.aspx");
    }

    protected void createMenuItems_Click(object sender, EventArgs e)
    {
        string directoryId = Request.QueryString["DirectoryID"];
        bool success = MenuAccess.CreateMenuItems(directoryId, newName.Text, newDescription.Text);

        statusLabel.Text = success ? "Insert Successful" : "Insert Failed";
        BindGrid();
    }
    
}
