using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserControls_FoodDetailsAdmin : System.Web.UI.UserControl
{
    private string currentFoodId, currentMenuItemsId, currentDirectoryId;

    protected void Page_Load(object sender, EventArgs e)
    {
        currentDirectoryId = Request.QueryString["DirectoryID"];
        currentMenuItemsId = Request.QueryString["MenuItemsID"];
        currentFoodId = Request.QueryString["FoodID"];

        Utilities.TieButton(this.Page, menuItemsListRemove, removeButton);
        Utilities.TieButton(this.Page, MenuItemsListAssign, assignButton);
        Utilities.TieButton(this.Page, menuItemsListMove, moveButton);

        if (!IsPostBack)
        {
            PopulateControls();
        }
    }

    private void PopulateControls()
    {
        //set the 'go back to foods' link
        goBackLink.NavigateUrl = Request.ApplicationPath + String.Format("/MenuItemAdmin.aspx?DirectoryID={0}&MenuItemsID={1}", currentDirectoryId, currentMenuItemsId);

        //get food details and menu items details from database
        FoodDetalis foodDetails = MenuAccess.GetFoodDetails(currentFoodId);
        MenuItemsDetails menuItemsDetails = MenuAccess.GetMenuItemsDetails(currentMenuItemsId);

        //set up labels and image
        foodNameLabel.Text = foodDetails.Name;
        moveLabel.Text = "Move Food from MenuItem <b>" + menuItemsDetails.Name + "<b/> to this menu Items: ";
        image1.ImageUrl = Request.ApplicationPath + "/FoodImages/" + foodDetails.Image1FileName;

        //clear form
        menuItemsLabel.Text = "";
        MenuItemsListAssign.Items.Clear();
        menuItemsListMove.Items.Clear();
        menuItemsListRemove.Items.Clear();

        //Fill menuitemslabel and menuitemslistremove with data
        string menuItemsId, menuItemsName;
        DataTable foodMenuItems = MenuAccess.GetMenuItemsWithFood(currentFoodId);

        for (int i = 0; i < foodMenuItems.Rows.Count; i++)
        {
            menuItemsId = foodMenuItems.Rows[i]["MenuItemsId"].ToString();
            menuItemsName = foodMenuItems.Rows[i]["Name"].ToString();

            menuItemsLabel.Text += (menuItemsLabel.Text == "" ? "" : ". ") + "<a href=\"" + Request.ApplicationPath + "/MenuItemAdmin.aspx" + "?DirectoryID=" + MenuAccess.GetMenuItemsDetails(currentMenuItemsId).DirectoryId + "&MenuItemsID=" + menuItemsId + "\">" + menuItemsName + "</a>";
            menuItemsListRemove.Items.Add(new ListItem(menuItemsName, menuItemsId));
        }

        if (foodMenuItems.Rows.Count > 1)
        {
            deleteButton.Visible = false;
            removeButton.Enabled = true;
        }
        else
        {
            deleteButton.Visible = true;
            removeButton.Enabled = false;
        }

        foodMenuItems = MenuAccess.GetMenuItemsWithoutFood(currentFoodId);

        for (int i = 0; i < foodMenuItems.Rows.Count; i++)
        {
            menuItemsId = foodMenuItems.Rows[i]["MenuItemsID"].ToString();
            menuItemsName = foodMenuItems.Rows[i]["Name"].ToString();

            MenuItemsListAssign.Items.Add(new ListItem(menuItemsName, menuItemsId));
            menuItemsListMove.Items.Add(new ListItem(menuItemsName, menuItemsId));
        }

    }
    protected void deleteButton_Click(object sender, EventArgs e)
    {
        //delete a food from the menu items
        MenuAccess.DeleteFood(currentFoodId);

        //Need to go back to the menu items page
        Response.Redirect(Request.ApplicationPath + "/MenuItemAdmin.aspx" + "?DirectoryID=" + currentDirectoryId + "&MenuItemsID=" + currentMenuItemsId);
    }

    protected void removeButton_Click(object sender, EventArgs e)
    {
        //Check if a menu items was selected
        if (menuItemsListRemove.SelectedIndex != -1)
        {
            //get the menu items id that was selected in the dropdownlist
            string menuItemsId = menuItemsListRemove.SelectedItem.Value;
            //remove the food from the menuitems
            bool success = MenuAccess.RemoveFoodFromMenuItems(currentFoodId, menuItemsId);

            //Display status message
            statusLabel.Text = success ? "Food Item removed successfully" : "Food Item removal failed";

            //refresh the page
            PopulateControls();
        }
        else
            statusLabel.Text = "You need to select a Menu Items";
    }

    //assign the food to a new menu items
    protected void assignButton_Click(object sender, EventArgs e)
    {
        //check if a menu items was selected
        if (MenuItemsListAssign.SelectedIndex != -1)
        {
            //get the menuitems ID that was selected in the dropdownlist
            string menuitemsId = MenuItemsListAssign.SelectedItem.Value;

            //assign the food to the menu items
            bool success = MenuAccess.AssignFoodToMenuItems(currentFoodId, menuitemsId);

            //display status message
            statusLabel.Text = success ? "Food assigned successfull" : "Food assignation failed";

            //refresh the page
            PopulateControls();
        }
        else
            statusLabel.Text = "You need to select a menu items";
    }


    protected void moveButton_Click(object sender, EventArgs e)
    {
        //check if a menu items was selected
        if (menuItemsListMove.SelectedIndex != -1)
        {
            string newMenuItemsId = menuItemsListMove.SelectedItem.Value;

            bool success = MenuAccess.MoveFoodToMenuItems(currentFoodId, currentMenuItemsId, newMenuItemsId);

            if (!success)
                statusLabel.Text = "Couldn't move the Food to the specified menu item";
            else
                Response.Redirect(Request.ApplicationPath + "/MenuItemAdmin.aspx" + "?DirectoryID=" + currentDirectoryId + "&MeunItemsID=" + newMenuItemsId + "&FoodID=" + currentFoodId);

        }
        else
            statusLabel.Text = "You need to select a Menu Items";
    }


    protected void uploadButton_Click(object sender, EventArgs e)
    {
        if (image1FileUpload.HasFile)
        {
            try
            {
                string fileName = image1FileUpload.FileName;
                string location = Server.MapPath("./FoodImages/") + fileName;

                image1FileUpload.SaveAs(location);

                FoodDetalis fd = MenuAccess.GetFoodDetails(currentFoodId);
                MenuAccess.UpdateFood(currentFoodId, fd.Name, fd.Description, fd.Price.ToString(), fd.Image1FileName);

                Response.Redirect(Request.ApplicationPath + "/MenuItemAdmin.aspx" + "&MenuItemsID=" + currentMenuItemsId + "&FoodID=" + currentFoodId);
            }
            catch
            {
                statusLabel.Text = "Uploading image 1 failed";
            }
        }
    }
}
