<%@ Control Language="C#" AutoEventWireup="true" CodeFile="FoodAdmin.ascx.cs" Inherits="UserControls_FoodAdmin" %>
<asp:Label ID="statusLabel" runat="server" CssClass="AdminPageText" Text="Food Loaded" style="font-family: Arial, Sans-Serif; background-color: #ff9900"></asp:Label><br />
<br />
<asp:Label ID="locationLabel" runat="server" CssClass="AdminPageText" Text="Displaying Food for Menu Items" style="font-family: Arial, Sans-Serif; background-color: #ff9900"></asp:Label>
<br />
<asp:LinkButton ID="goBackLink" runat="server">go back to Menu Items</asp:LinkButton>
<br />
<br />
<br />
<asp:GridView ID="grid" runat="server" AutoGenerateColumns="False" DataKeyNames="FoodID"
    Width="100%" OnRowCancelingEdit="grid_RowCancelingEdit" OnRowEditing="grid_RowEditing" OnRowUpdating="grid_RowUpdating">
    <Columns>
      <asp:ImageField DataImageUrlField="Image1FileName" DataImageUrlFormatString="../FoodImages/{0}"
            HeaderText="Food Image" ReadOnly="True">
      </asp:ImageField>
      <asp:TemplateField HeaderText="Food Name" SortExpression="Name">
      <ItemTemplate>
        <asp:Label ID="Label5" runat="server" Text='<%# Bind("Name") %>'></asp:Label>
      </ItemTemplate>
      <EditItemTemplate>
        <asp:TextBox ID="nameTextBox" runat="server" Width="97%" CssClass="GridEditingRow" Text='<%# Bind("Name") %>'></asp:TextBox>
      </EditItemTemplate>
    </asp:TemplateField>
    <asp:TemplateField HeaderText="Food Description" SortExpression="Description">
      <ItemTemplate>
        <asp:Label ID="Label1" runat="server" Text='<%# Bind("Description") %>'></asp:Label>
      </ItemTemplate>
      <EditItemTemplate>
        <asp:TextBox ID="descriptionTextBox" runat="server" Text='<%# Bind("Description") %>'
          Height="100px" Width="97%" CssClass="GridEditingRow" TextMode="MultiLine" />
      </EditItemTemplate>
    </asp:TemplateField>
    <asp:TemplateField HeaderText="Price" SortExpression="Price">
      <ItemTemplate>
        <asp:Label ID="Label2" runat="server" Text='<%# String.Format("{0:0.00}", Eval("Price")) %>'></asp:Label>
      </ItemTemplate>
      <EditItemTemplate>
        <asp:TextBox ID="priceTextBox" runat="server" Width="45px" Text='<%# String.Format("{0:0.00}", Eval("Price")) %>'></asp:TextBox>
      </EditItemTemplate>
    </asp:TemplateField>
    <asp:TemplateField HeaderText="Image1 File" SortExpression="Image1FileName">
      <ItemTemplate>
        <asp:Label ID="Label3" runat="server" Text='<%# Bind("Image1FileName") %>'></asp:Label>
      </ItemTemplate>
      <EditItemTemplate>
        <asp:TextBox ID="image1TextBox" Width="80px" runat="server" Text='<%# Bind("Image1FileName") %>'></asp:TextBox>
      </EditItemTemplate>
    </asp:TemplateField>
    </Columns>
</asp:GridView>
<br />


<span class="AdminPageText">Create a new Food and assign it to this Menu Item</span>
<table class="AdminPageText" cellspacing="0">
<tr>
    <td valign="top" style="width: 100px; font-family: Arial, Sans-Serif; background-color: #ff6600">Name:</td>
    <td>
        <asp:TextBox CssClass="AdminPageText" ID="newName" runat="server" Width="400px" />
    </td>
</tr>
<tr>
    <td valign="top" style="width: 100px; font-family: Arial, Sans-Serif; background-color: #ff6600">Description:</td>
    <td>
        <asp:TextBox CssClass="AdminPageText" ID="newDescription" runat="server" Width="400px" Height="70px" TextMode="multiLine" />
    </td>
</tr>
<tr>
    <td valign="top" style="width: 100px; font-family: Arial, Sans-Serif; background-color: #ff6600"> Price:</td>
    <td>
        <asp:TextBox CssClass="AdminPageText" ID="newPrice" runat="server" Width="400px">0.00</asp:TextBox>
    </td>
</tr>
<tr>
    <td valign="top" style="width: 100px; font-family: Arial, Sans-Serif; background-color: #ff6600">Image1 File:</td>
    <td>
        <asp:TextBox CssClass="AdminPageText" ID="newImage1FileName" runat="server" Width="400px">Generic.jpg</asp:TextBox>
    </td>
</tr>
</table>
<asp:Button ID="createFood" CssClass="AdminButtonText" runat="server" Text="Create Food" style="background-color: #ffad33" Width="100px" />
