using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
//using System.Web.UI.HtmlControls.HtmlGenericControl;


public partial class ShoppingCart : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
            PopulateControls();
    }

    private void PopulateControls()
    {
        this.Title = LaScalaConfiguration.SiteName + " :Shopping Cart";

        DataTable dt = ShoppingCartAccess.GetItems();

        if (dt.Rows.Count == 0)
        {
            titleLabel.Text = "Your Shopping cart is Empty! ";
            grid.Visible = false;
            updateButton.Enabled = false;
            checkoutButton.Enabled = false;
            totalAmountLabel.Text = string.Format("{0:c}", 0);
        }
        else
        {
            grid.DataSource = dt;
            grid.DataBind();

            titleLabel.Text = "These are the foods in your shopping cart: ";
            grid.Visible = true;
            updateButton.Enabled = true;
            checkoutButton.Enabled = true;
            decimal amount = ShoppingCartAccess.GetTotalAmount();
            totalAmountLabel.Text = String.Format("{0:c}", amount);
        }
    }

    protected void updateButton_Click(object sender, EventArgs e)
    {
        int rowsCount = grid.Rows.Count;

        GridViewRow gridRow;

        TextBox quantityTextBox;

        string foodId;
        int quantity;

        bool success = true;

        for (int i = 0; i < rowsCount; i++)
        {
            gridRow = grid.Rows[i];
            foodId = grid.DataKeys[i].Value.ToString();
            quantityTextBox = (TextBox)gridRow.FindControl("editQuantity");

            if (Int32.TryParse(quantityTextBox.Text, out quantity))
            {
                success = success && ShoppingCartAccess.UpdateItem(foodId, quantity);
            }
            else
            {
                success = false;
            }

            statusLabel.Text = success ? "<br/>Your Shopping cart was successfully updated!,br/>" : "<br/>Some quantity updates failed! Please verify your cart!<br/>";
        }
        PopulateControls();
    }
    protected void continueShoppingButton_Click(object sender, EventArgs e)
    {
        object page;
        if ((page = Session["LastVisitedMenuItemPage"]) != null)
            Response.Redirect(page.ToString());
        else
            Response.Redirect(Request.ApplicationPath);
    }
    protected void grid_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {

        int rowIndex = e.RowIndex;

        string foodId = grid.DataKeys[rowIndex].Value.ToString();

        bool success = ShoppingCartAccess.RemoveItem(foodId);

        statusLabel.Text = success ? "<br/> Food Sucessfully removed! <br/>" : "<br />There was an error removing the food!<br/>";

        PopulateControls();
    }

    protected void checkoutButton_Click(object sender, EventArgs e)
    {
        // Store the total amount because the cart 
        // is emptied when creating the order
        //     decimal amount = ShoppingCartAccess.GetTotalAmount();
        // Create the order and store the order ID
        //   string orderId = ShoppingCartAccess.CreateOrder();
        // Obtain the site name from the configuration settings
        // string siteName = LaScalaConfiguration.SiteName;

        string redirect = "Checkout.aspx";
        Response.Redirect("Checkout.aspx");
    }
}
