using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using CommerceLib;

public partial class Checkout : System.Web.UI.Page
{
    /*
        protected override void OnInit(EventArgs e)
        {
            (Master as LaScala).EnforceSSL = true;
            base.OnInit(e);
        }
        */
    protected void Page_Load(object sender, EventArgs e)
    {
        // Set the title of the page
        this.Title = LaScalaConfiguration.SiteName +
                      " : Checkout";

        if (!IsPostBack)
            PopulateControls();
    }

    // fill controls with data
    private void PopulateControls()
    {
        // get the items in the shopping cart
        DataTable dt = ShoppingCartAccess.GetItems();
        // populate the list with the shopping cart contents
        grid.DataSource = dt;
        grid.DataBind();
        // setup controls
        titleLabel.Text = "These are the foods in your shopping cart:";
        grid.Visible = true;
        // display the total amount
        decimal amount = ShoppingCartAccess.GetTotalAmount();
        totalAmountLabel.Text = String.Format("{0:c}", amount);

        // check customer details
        bool addressOK = true;

        if (Profile.Address == "")
        {
            addressOK = false;
        }
        // report / hide place order button
        if (!addressOK)
        {
            InfoLabel.Text =
                  "You must provide a valid address before placing your "
                  + "order.";
        }
        else
        {
            InfoLabel.Text = "Please confirm that the above details are "
              + "correct before proceeding.";
        }
        placeOrderButton.Visible = addressOK;
    }

    protected void placeOrderButton_Click(object sender, EventArgs e)
    {
        // Store the total amount because the cart 
        // is emptied when creating the order
    //    decimal amount = ShoppingCartAccess.GetTotalAmount();
        // Create the order and store the order ID
        string orderId = ShoppingCartAccess.CreateCommerceLibOrder();

        OrderProcessor processor = new OrderProcessor(orderId);
        processor.Process();



        Response.Redirect("OrderPlaced.aspx");
    }
}
