using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Net.Mail;

/// <summary>
/// Class contains miscellanous functionality
/// </summary>
public static class Utilities
{
    static Utilities()
    {
        //
        // TODO: Add constructor logic here
        //
    }

    //Generic method for sending emails
    public static void SendMail(string from, string to, string subject, string body)
    {
        //Configure mail client
        SmtpClient mailClient = new SmtpClient(LaScalaConfiguration.MailServer);

        //Create the mail message
        MailMessage mailMessage = new MailMessage(from, to, subject, body);

        //For SMTP servers that require authentication
        //Make sure to change these back to my own add
        //mailMessage.Fields.Add("http://Schemas.microsoft.com/cdo/configuration/smtpauthenticate", 1);
        // mailMessage.Fields.Add("http://Schemas.microsoft.com/cdo/configuration/sendusername", "SmtpHostUserName");
        // mailMessage.Fields.Add("http://Schemas.microsoft.com/cdo/configuration/sendpassword", "SmtpHostPassword");


        //send mail
        mailClient.Send(mailMessage);
    }

    //Send error log mail
    public static void LogError(Exception ex)
    {
        //get the current date and time
        string dateTime = DateTime.Now.ToLongDateString() + ", at " +
                            DateTime.Now.ToShortTimeString();

        //stores the error message
        string errorMessage = "Exception generated on" + dateTime;

        //obtain the page that generated the error
        System.Web.HttpContext context = System.Web.HttpContext.Current;
        errorMessage += "\n\n Page location: " + context.Request.RawUrl;

        //build the error message
        errorMessage += "\n\n Message: " + ex.Message;
        errorMessage += "\n\n Source: " + ex.Source;
        errorMessage += "\n\n Method: " + ex.TargetSite;
        errorMessage += "\n\n Stack Trace: \n\n" + ex.StackTrace;

        //send error email in case the option is activated in Web.Config
        if (LaScalaConfiguration.EnableErrorLogEmail)
        {
            //make sure to change the mail add
            string from = "yong_choe@hotmail.com";
            string to = LaScalaConfiguration.ErrorLogEmail;
            //string subject = LaScalaConfiguration.SiteName + "error report";
            string subject = "Error ";
            string body = errorMessage;
            SendMail(from, to, subject, body);
        }

    }

    // Generic method for sending emails
    //  public static void SendMail(string from, string to, string subject, string body)
    //  {
    // Configure mail client (may need additional
    // code for authenticated SMTP servers)
    //      SmtpClient mailClient = new SmtpClient(LaScalaConfiguration.MailServer);
    // Create the mail message
    //      MailMessage mailMessage = new MailMessage(from, to, subject, body);
    // Send mail
    //       mailClient.Send(mailMessage);
    //   }

    // Send error log mail
    public static void SendErrorLogEmail(Exception ex)
    {
        string from = "La Scala Error Report";
        string to = LaScalaConfiguration.ErrorLogEmail;
        string subject = "La Scala Error Generated at " + DateTime.Now.ToShortDateString();
        string body = ex.Message + "\n\n" + "Stack trace:\n" + ex.StackTrace.ToString();
        SendMail(from, to, subject, body);
    }

    public static void TieButton(Page page, Control TextBoxToTie, Control ButtonToTie)
    {
        string jsString = "";

        if (ButtonToTie is LinkButton)
        {
            jsString = "if((event.which && event.which == 13) || (event.keyCode && event.keyCode == 13)){"
                        + page.ClientScript.GetPostBackEventReference(ButtonToTie, "").Replace(":", "$") + ";return false;}else return true;";
        }
        else if (ButtonToTie is ImageButton)
        {
            jsString = "if((event.which && event.which == 13) || (event.keyCode && event.keyCode == 13)){"
                        + page.ClientScript.GetPostBackEventReference(ButtonToTie, "").Replace(":", "$") + ";return false;}else return true;";
        }
        else
        {
            jsString = "if((event.which && event.which == 13) || (event.keyCode && event.keyCode == 13)){document." + "forms[0].elements['" +
                ButtonToTie.UniqueID.Replace(":", "_") + "'].click();return false;} else return true;";

        }

        if (TextBoxToTie is HtmlControl)
        {
            ((HtmlControl)TextBoxToTie).Attributes.Add("onkeydown", jsString);
        }
        else if (TextBoxToTie is WebControl)
        {
            ((WebControl)TextBoxToTie).Attributes.Add("onkeydown", jsString);
        }
    }
}

