using System;
using System.Data;
using System.Data.Common;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Supports Shopping cart functionality
/// </summary>
public class ShoppingCartAccess
{
    public ShoppingCartAccess()
    {
    }

    //Returns the shopping cart ID for the current user
    private static string shoppingCartID
    {
        get
        {
            //get the current httpContext
            HttpContext context = HttpContext.Current;
            //try to get the cart ID from the user session object
            string cartId = "";
            object cartIdSession = context.Session["LaScala_CartID"];
            if (cartIdSession != null)
                cartId = cartIdSession.ToString();
            //if the ID exists in the current session...
            if (cartId != "")
                //return value
                return cartId;
            else
            //if the cart ID isn't in the session
            {
                //check if the cart ID exists as a cookie
                if (context.Request.Cookies["LaScala_CartID"] != null)
                {
                    //if the cart exists as a cookie, use the cookie to get its value
                    cartId = context.Request.Cookies["LaScala_CartID"].Value;
                    //save the id to the session, to avoid reading the cookie next time
                    context.Session["LaScala_CartID"] = cartId;

                    return cartId;
                }
                else //generate new ID
                {
                    cartId = Guid.NewGuid().ToString();

                    //create the cookie object and set its value
                    HttpCookie cookie = new HttpCookie("LaScala_CartID", cartId.ToString());
                    //set teh cookie's expiration date
                    int howManyDays = LaScalaConfiguration.CartPersistDays;
                    DateTime currentDate = DateTime.Now;
                    TimeSpan timeSpan = new TimeSpan(howManyDays, 0, 0, 0);
                    DateTime expirationDate = currentDate.Add(timeSpan);
                    cookie.Expires = expirationDate;

                    //set the cookie on the client's browser
                    context.Response.Cookies.Add(cookie);
                    //save the ID to the session 
                    context.Session["LaScala_CartID"] = cartId;
                    //return the cartID
                    return cartId.ToString();
                }
            }
        }
    }

    //Add a new shopping cart item
    public static bool AddItem(string foodId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "ShoppingCartAddItem";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CartID";
        param.Value = shoppingCartID;
        param.DbType = DbType.String;
        param.Size = 36;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        try
        {
            return (GenericDataAccess.ExecuteNonQuery(comm) != -1);
        }
        catch
        {
            return false;
        }
    }

    //Update the quantity of a shopping cart item
    public static bool UpdateItem(string foodId, int quantity)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "ShoppingCartUpdateItem";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CartID";
        param.Value = shoppingCartID;
        param.DbType = DbType.String;
        param.Size = 36;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@Quantity";
        param.Value = quantity;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        try
        {
            return (GenericDataAccess.ExecuteNonQuery(comm) != -1);
        }
        catch
        {
            return false;
        }
    }

    //Remove a shopping cart item
    public static bool RemoveItem(string foodId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "ShoppingCartRemoveItem";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CartID";
        param.Value = shoppingCartID;
        param.DbType = DbType.String;
        param.Size = 36;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        try
        {
            return (GenericDataAccess.ExecuteNonQuery(comm) != -1);
        }
        catch
        {
            return false;
        }
    }

    //Retrieve shopping cart items
    public static DataTable GetItems()
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "ShoppingCartGetItems";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CartID";
        param.Value = shoppingCartID;
        param.DbType = DbType.String;
        param.Size = 36;
        comm.Parameters.Add(param);

        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);
        return table;
    }

    public static decimal GetTotalAmount()
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "ShoppingCartGetTotalAmount";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CartID";
        param.Value = shoppingCartID;
        param.DbType = DbType.String;
        param.Size = 36;
        comm.Parameters.Add(param);

        return Decimal.Parse(GenericDataAccess.ExecuteScalar(comm));
    }

    public static int CountOldCarts(byte days)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();

        comm.CommandText = "ShoppingCartCountOldCarts";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@Days";
        param.Value = days;
        param.DbType = DbType.Byte;
        comm.Parameters.Add(param);

        try
        {
            return Byte.Parse(GenericDataAccess.ExecuteScalar(comm));
        }
        catch
        {
            return -1;
        }
    }

    //delete old shopping carts
    public static bool DeleteOldCarts(byte days)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();

        comm.CommandText = "ShoppingCartDeleteOldCarts";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@Days";
        param.Value = days;
        param.DbType = DbType.Byte;
        comm.Parameters.Add(param);

        try
        {
            GenericDataAccess.ExecuteNonQuery(comm);
            return true;
        }
        catch
        {
            return false;
        }
    }


    // Create a new order from the shopping cart
    public static string CreateOrder()
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CreateOrder";
        // create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CartID";
        param.Value = shoppingCartID;
        param.DbType = DbType.String;
        param.Size = 36;
        comm.Parameters.Add(param);
        // return the result table
        return GenericDataAccess.ExecuteScalar(comm);
    }

    // Create a new order with customer ID
    public static string CreateCommerceLibOrder()
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CreateCustomerOrder";
        // create parameters
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CartID";
        param.Value = shoppingCartID;
        param.DbType = DbType.String;
        param.Size = 36;
        comm.Parameters.Add(param);
        // create a new parameter
        param = comm.CreateParameter();
        param.ParameterName = "@CustomerId";
        param.Value =
           Membership.GetUser(
           HttpContext.Current.User.Identity.Name)
           .ProviderUserKey;
        param.DbType = DbType.Guid;
        param.Size = 16;
        comm.Parameters.Add(param);

        // return the result table
        return GenericDataAccess.ExecuteScalar(comm);
    }
}
